/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;

final class MapResolver
implements EventResolver {
    private final String key;
    private final boolean stringified;

    static String getName() {
        return "map";
    }

    MapResolver(TemplateResolverConfig config) {
        this.key = config.getString("key");
        this.stringified = config.getBoolean("stringified", false);
        if (this.key == null) {
            throw new IllegalArgumentException("missing key: " + config);
        }
    }

    @Override
    public boolean isResolvable(LogEvent logEvent) {
        return logEvent.getMessage() instanceof MapMessage;
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        Message message = logEvent.getMessage();
        if (!(message instanceof MapMessage)) {
            jsonWriter.writeNull();
        } else {
            MapMessage mapMessage = (MapMessage)message;
            IndexedReadOnlyStringMap map = mapMessage.getIndexedReadOnlyStringMap();
            Object value = map.getValue(this.key);
            if (this.stringified) {
                String stringifiedValue = String.valueOf(value);
                jsonWriter.writeString(stringifiedValue);
            } else {
                jsonWriter.writeValue(value);
            }
        }
    }
}

