/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json;

import java.nio.ByteBuffer;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.ByteBufferDestinationHelper;

class BlackHoleByteBufferDestination
implements ByteBufferDestination {
    private final ByteBuffer byteBuffer;

    BlackHoleByteBufferDestination(int maxByteCount) {
        this.byteBuffer = ByteBuffer.allocate(maxByteCount);
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public ByteBuffer drain(ByteBuffer byteBuffer) {
        byteBuffer.flip();
        if (this.byteBuffer != byteBuffer) {
            this.byteBuffer.clear();
            this.byteBuffer.put(byteBuffer);
        }
        byteBuffer.clear();
        return byteBuffer;
    }

    public void writeBytes(ByteBuffer byteBuffer) {
        ByteBufferDestinationHelper.writeToUnsynchronized((ByteBuffer)byteBuffer, (ByteBufferDestination)this);
    }

    public void writeBytes(byte[] buffer, int offset, int length) {
        ByteBufferDestinationHelper.writeToUnsynchronized((byte[])buffer, (int)offset, (int)length, (ByteBufferDestination)this);
    }
}

