/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ResourceBundle;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyKey;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.Supplier;
import org.apache.logging.log4j.util.TimeUnit;

public interface PropertyEnvironment {
    public void addPropertySource(PropertySource var1);

    public boolean hasProperty(String var1);

    default public boolean hasProperty(PropertyKey key) {
        return this.hasProperty(key.getKey());
    }

    default public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    default public boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    default public boolean getBooleanProperty(PropertyKey key) {
        if (key == null) {
            return false;
        }
        return this.getBooleanProperty(key.getKey());
    }

    default public boolean getBooleanProperty(PropertyKey key, boolean defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        return this.getBooleanProperty(key.getKey(), defaultValue);
    }

    default public boolean getBooleanProperty(String name, boolean defaultValueIfAbsent, boolean defaultValueIfPresent) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValueIfAbsent : (prop.isEmpty() ? defaultValueIfPresent : "true".equalsIgnoreCase(prop));
    }

    default public boolean getBooleanProperty(PropertyKey key, boolean defaultValueIfAbsent, boolean defaultValueIfPresent) {
        if (key == null) {
            return defaultValueIfAbsent;
        }
        return this.getBooleanProperty(key.getKey(), defaultValueIfAbsent, defaultValueIfPresent);
    }

    default public Boolean getBooleanProperty(String[] prefixes, String key, Supplier<Boolean> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key)) continue;
            return this.getBooleanProperty(prefix + key);
        }
        return supplier != null ? (Boolean)supplier.get() : null;
    }

    default public Charset getCharsetProperty(String name) {
        return this.getCharsetProperty(name, Charset.defaultCharset());
    }

    default public Charset getCharsetProperty(PropertyKey key) {
        if (key == null) {
            return null;
        }
        return this.getCharsetProperty(key.getKey());
    }

    default public Charset getCharsetProperty(PropertyKey key, Charset defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        return this.getCharsetProperty(key.getKey(), defaultValue);
    }

    default public Charset getCharsetProperty(String name, Charset defaultValue) {
        String mapped;
        String charsetName = this.getStringProperty(name);
        if (charsetName == null) {
            return defaultValue;
        }
        if (Charset.isSupported(charsetName)) {
            return Charset.forName(charsetName);
        }
        ResourceBundle bundle = PropertiesUtil.getCharsetsResourceBundle();
        if (bundle.containsKey(name) && Charset.isSupported(mapped = bundle.getString(name))) {
            return Charset.forName(mapped);
        }
        LowLevelLogUtil.log("Unable to get Charset '" + charsetName + "' for property '" + name + "', using default " + defaultValue + " and continuing.");
        return defaultValue;
    }

    default public int getIntegerProperty(String name, int defaultValue) {
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                return Integer.parseInt(prop);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    default public int getIntegerProperty(PropertyKey key, int defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        return this.getIntegerProperty(key.getKey(), defaultValue);
    }

    default public Integer getIntegerProperty(String[] prefixes, String key, Supplier<Integer> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key)) continue;
            return this.getIntegerProperty(prefix + key, 0);
        }
        return supplier != null ? (Integer)supplier.get() : null;
    }

    default public long getLongProperty(PropertyKey key, long defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        return this.getLongProperty(key.getKey(), defaultValue);
    }

    default public long getLongProperty(String name, long defaultValue) {
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                return Long.parseLong(prop);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    default public Long getLongProperty(String[] prefixes, String key, Supplier<Long> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key)) continue;
            return this.getLongProperty(prefix + key, 0L);
        }
        return supplier != null ? (Long)supplier.get() : null;
    }

    default public Duration getDurationProperty(PropertyKey key, Duration defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        return this.getDurationProperty(key.getKey(), defaultValue);
    }

    default public Duration getDurationProperty(String name, Duration defaultValue) {
        String prop = this.getStringProperty(name);
        if (prop != null) {
            return TimeUnit.getDuration(prop);
        }
        return defaultValue;
    }

    default public Duration getDurationProperty(String[] prefixes, String key, Supplier<Duration> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key)) continue;
            return this.getDurationProperty(prefix + key, null);
        }
        return supplier != null ? (Duration)supplier.get() : null;
    }

    default public String getStringProperty(String[] prefixes, String key, Supplier<String> supplier) {
        for (String prefix : prefixes) {
            String result = this.getStringProperty(prefix + key);
            if (result == null) continue;
            return result;
        }
        return supplier != null ? (String)supplier.get() : null;
    }

    default public String getStringProperty(PropertyKey key) {
        if (key == null) {
            return null;
        }
        return this.getStringProperty(key.getKey());
    }

    public String getStringProperty(String var1);

    default public String getStringProperty(PropertyKey key, String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        return this.getStringProperty(key.getKey(), defaultValue);
    }

    default public String getStringProperty(String name, String defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : prop;
    }

    default public boolean isOsWindows() {
        return this.getStringProperty("os.name", "").startsWith("Windows");
    }
}

