/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junitpioneer.jupiter.ReadsSystemProperty;

public class PropertiesUtilTest {
    private final Properties properties = new Properties();
    private static final String[][] data = new String[][]{{null, "org.apache.logging.log4j.level"}, {null, "Log4jAnotherProperty"}, {null, "log4j2.catalinaBase"}, {"ok", "log4j2.configurationFile"}, {"ok", "log4j2.defaultStatusLevel"}, {"ok", "log4j2.newLevel"}, {"ok", "log4j2.asyncLoggerTimeout"}, {"ok", "log4j2.asyncLoggerConfigRingBufferSize"}, {"ok", "log4j2.disableThreadContext"}, {"ok", "log4j2.disableThreadContextStack"}, {"ok", "log4j2.disableThreadContextMap"}, {"ok", "log4j2.isThreadContextMapInheritable"}};

    @BeforeEach
    public void setUp() throws Exception {
        this.properties.load(ClassLoader.getSystemResourceAsStream("PropertiesUtilTest.properties"));
    }

    @Test
    public void testExtractSubset() {
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"a"));
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"b."));
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"c.1"));
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"dd"));
        Assertions.assertEquals((int)1, (int)this.properties.size());
    }

    @Test
    public void testPartitionOnCommonPrefix() {
        Map parts = PropertiesUtil.partitionOnCommonPrefixes((Properties)this.properties);
        Assertions.assertEquals((int)4, (int)parts.size());
        PropertiesUtilTest.assertHasAllProperties((Properties)parts.get("a"));
        PropertiesUtilTest.assertHasAllProperties((Properties)parts.get("b"));
        PropertiesUtilTest.assertHasAllProperties((Properties)PropertiesUtil.partitionOnCommonPrefixes((Properties)((Properties)parts.get("c"))).get("1"));
        PropertiesUtilTest.assertHasAllProperties((Properties)parts.get("dd"));
    }

    private static void assertHasAllProperties(Properties properties) {
        Assertions.assertNotNull((Object)properties);
        Assertions.assertEquals((Object)"1", (Object)properties.getProperty("1"));
        Assertions.assertEquals((Object)"2", (Object)properties.getProperty("2"));
        Assertions.assertEquals((Object)"3", (Object)properties.getProperty("3"));
    }

    @Test
    public void testGetCharsetProperty() {
        Properties p = new Properties();
        p.setProperty("e.1", StandardCharsets.US_ASCII.name());
        p.setProperty("e.2", "wrong-charset-name");
        PropertiesUtil pu = new PropertiesUtil(p);
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)pu.getCharsetProperty("e.0"));
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)pu.getCharsetProperty("e.1"));
        Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)pu.getCharsetProperty("e.2"));
    }

    @Test
    @ResourceLock(value="java.lang.System.properties", mode=ResourceAccessMode.READ)
    public void testGetMappedProperty_sun_stdout_encoding() {
        PropertiesUtil pu = new PropertiesUtil(System.getProperties());
        Charset expected = System.console() == null ? Charset.defaultCharset() : StandardCharsets.UTF_8;
        Assertions.assertEquals((Object)expected, (Object)pu.getCharsetProperty("sun.stdout.encoding"));
    }

    @Test
    @ResourceLock(value="java.lang.System.properties", mode=ResourceAccessMode.READ)
    public void testGetMappedProperty_sun_stderr_encoding() {
        PropertiesUtil pu = new PropertiesUtil(System.getProperties());
        Charset expected = System.console() == null ? Charset.defaultCharset() : StandardCharsets.UTF_8;
        Assertions.assertEquals((Object)expected, (Object)pu.getCharsetProperty("sun.err.encoding"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ResourceLock(value="java.lang.System.properties")
    public void testNonStringSystemProperties() {
        String key1 = "1";
        Object key2 = new Object();
        System.getProperties().put(key1, new Object());
        System.getProperties().put(key2, "value-2");
        try {
            PropertiesUtil util = new PropertiesUtil(new Properties());
            Assertions.assertNull((Object)util.getStringProperty("1"));
        }
        finally {
            System.getProperties().remove(key1);
            System.getProperties().remove(key2);
        }
    }

    @Test
    @ResourceLock(value="java.lang.System.properties", mode=ResourceAccessMode.READ)
    public void testPublish() {
        Properties props = new Properties();
        PropertiesUtil util = new PropertiesUtil(props);
        String value = System.getProperty("Application");
        Assertions.assertNotNull((Object)value, (String)"System property was not published");
        Assertions.assertEquals((Object)"Log4j", (Object)value);
    }

    @Test
    @ResourceLock(value="java.lang.System.properties", mode=ResourceAccessMode.READ)
    public void testResolvesOnlyLog4jProperties() {
        PropertiesUtil util = new PropertiesUtil("Jira3413Test.properties");
        for (String[] pair : data) {
            Assertions.assertEquals((Object)pair[0], (Object)util.getStringProperty(pair[1]));
        }
    }

    @Test
    @ReadsSystemProperty
    public void testLog4jProperty() {
        Properties props = new Properties();
        String incorrect = "log4j2.";
        String correct = "not.starting.with.log4j";
        props.setProperty("log4j2.", "log4j2.");
        props.setProperty("not.starting.with.log4j", "not.starting.with.log4j");
        PropertiesUtil util = new PropertiesUtil(props);
        Assertions.assertEquals((Object)"not.starting.with.log4j", (Object)util.getStringProperty("not.starting.with.log4j"));
    }
}

