/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.LambdaUtil;
import org.apache.logging.log4j.util.MessageSupplier;
import org.apache.logging.log4j.util.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LambdaUtilTest {
    @Test
    public void testGetSupplierResultOfSupplier() {
        String expected = "result";
        Object actual = LambdaUtil.get(() -> "result");
        Assertions.assertSame((Object)"result", (Object)actual);
    }

    @Test
    public void testGetMessageSupplierResultOfSupplier() {
        SimpleMessage expected = new SimpleMessage("hi");
        Message actual = LambdaUtil.get(() -> LambdaUtilTest.lambda$testGetMessageSupplierResultOfSupplier$1((Message)expected));
        Assertions.assertSame((Object)expected, (Object)actual);
    }

    @Test
    public void testGetSupplierReturnsNullIfSupplierNull() {
        Object actual = LambdaUtil.get((Supplier)null);
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void testGetMessageSupplierReturnsNullIfSupplierNull() {
        Message actual = LambdaUtil.get((MessageSupplier)null);
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void testGetSupplierExceptionIfSupplierThrowsException() {
        Assertions.assertThrows(RuntimeException.class, () -> LambdaUtil.get(() -> {
            throw new RuntimeException();
        }));
    }

    @Test
    public void testGetMessageSupplierExceptionIfSupplierThrowsException() {
        Assertions.assertThrows(RuntimeException.class, () -> LambdaUtil.get(() -> {
            throw new RuntimeException();
        }));
    }

    @Test
    public void testGetAllReturnsResultOfSuppliers() {
        String expected1 = "result1";
        Supplier function1 = () -> "result1";
        String expected2 = "result2";
        Supplier function2 = () -> "result2";
        Supplier[] functions = new Supplier[]{function1, function2};
        Object[] actual = LambdaUtil.getAll((Supplier[])functions);
        Assertions.assertEquals((int)actual.length, (int)functions.length);
        Assertions.assertSame((Object)"result1", (Object)actual[0]);
        Assertions.assertSame((Object)"result2", (Object)actual[1]);
    }

    @Test
    public void testGetAllReturnsNullArrayIfSupplierArrayNull() {
        Object[] actual = LambdaUtil.getAll((Supplier[])null);
        Assertions.assertNull((Object)actual);
    }

    @Test
    public void testGetAllReturnsNullElementsIfSupplierArrayContainsNulls() {
        Supplier[] functions = new Supplier[3];
        Object[] actual = LambdaUtil.getAll((Supplier[])functions);
        Assertions.assertEquals((int)actual.length, (int)functions.length);
        for (Object object : actual) {
            Assertions.assertNull((Object)object);
        }
    }

    @Test
    public void testGetAllThrowsExceptionIfAnyOfTheSuppliersThrowsException() {
        Supplier function1 = () -> "abc";
        Supplier function2 = () -> {
            throw new RuntimeException();
        };
        Supplier[] functions = new Supplier[]{function1, function2};
        Assertions.assertThrows(RuntimeException.class, () -> LambdaUtil.getAll((Supplier[])functions));
    }

    private static /* synthetic */ Message lambda$testGetMessageSupplierResultOfSupplier$1(Message expected) {
        return expected;
    }
}

