/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.stream.IntStream;
import org.apache.logging.log4j.util.Chars;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class CharsTest {
    @ParameterizedTest
    @ValueSource(ints={-1, 16, 400, -1, 16, 400})
    public void invalidDigitReturnsNullCharacter(int invalidDigit) {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((char)'\u0000', (char)Chars.getUpperCaseHex((int)invalidDigit)), () -> Assertions.assertEquals((char)'\u0000', (char)Chars.getLowerCaseHex((int)invalidDigit))});
    }

    @Test
    public void validDigitReturnsProperCharacter() {
        char[] expectedLower = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] expectedUpper = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        Assertions.assertAll(IntStream.range(0, 16).mapToObj(i -> () -> Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((char)expectedLower[i], (char)Chars.getLowerCaseHex((int)i), (String)String.format("Expected %x", i)), () -> Assertions.assertEquals((char)expectedUpper[i], (char)Chars.getUpperCaseHex((int)i), (String)String.format("Expected %X", i))})));
    }
}

