/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MutableThreadContextStackTest {
    @Test
    public void testEmptyIfConstructedWithEmptyList() {
        MutableThreadContextStack stack = new MutableThreadContextStack(new ArrayList());
        Assertions.assertTrue((boolean)stack.isEmpty());
    }

    @Test
    public void testConstructorCopiesListContents() {
        List<String> initial = Arrays.asList("a", "b", "c");
        MutableThreadContextStack stack = new MutableThreadContextStack(initial);
        Assertions.assertFalse((boolean)stack.isEmpty());
        Assertions.assertTrue((boolean)stack.containsAll(initial));
    }

    @Test
    public void testPushAndAddIncreaseStack() {
        MutableThreadContextStack stack = new MutableThreadContextStack(new ArrayList());
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        Assertions.assertEquals((int)2, (int)stack.size());
    }

    @Test
    public void testPeekReturnsLastAddedItem() {
        MutableThreadContextStack stack = new MutableThreadContextStack(new ArrayList());
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        Assertions.assertEquals((int)2, (int)stack.size());
        Assertions.assertEquals((Object)"msg2", (Object)stack.peek());
        stack.push("msg3");
        Assertions.assertEquals((Object)"msg3", (Object)stack.peek());
    }

    @Test
    public void testPopRemovesLastAddedItem() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Assertions.assertEquals((int)3, (int)stack.getDepth());
        Assertions.assertEquals((Object)"msg3", (Object)stack.pop());
        Assertions.assertEquals((int)2, (int)stack.size());
        Assertions.assertEquals((int)2, (int)stack.getDepth());
        Assertions.assertEquals((Object)"msg2", (Object)stack.pop());
        Assertions.assertEquals((int)1, (int)stack.size());
        Assertions.assertEquals((int)1, (int)stack.getDepth());
        Assertions.assertEquals((Object)"msg1", (Object)stack.pop());
        Assertions.assertEquals((int)0, (int)stack.size());
        Assertions.assertEquals((int)0, (int)stack.getDepth());
    }

    @Test
    public void testAsList() {
        MutableThreadContextStack stack = new MutableThreadContextStack(new ArrayList());
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        stack.push("msg3");
        Assertions.assertEquals(Arrays.asList("msg1", "msg2", "msg3"), (Object)stack.asList());
    }

    @Test
    public void testTrim() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        stack.trim(1);
        Assertions.assertEquals((int)1, (int)stack.size());
        Assertions.assertEquals((Object)"msg1", (Object)stack.peek());
    }

    @Test
    public void testCopy() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        ThreadContextStack copy = stack.copy();
        Assertions.assertEquals((int)3, (int)copy.size());
        Assertions.assertTrue((boolean)copy.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
        Assertions.assertEquals((int)3, (int)copy.size());
        Assertions.assertTrue((boolean)copy.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        copy.add((Object)"other");
        Assertions.assertEquals((int)4, (int)copy.size());
        Assertions.assertTrue((boolean)stack.isEmpty());
        stack.push("newStackMsg");
        Assertions.assertEquals((int)1, (int)stack.size());
        Assertions.assertEquals((int)4, (int)copy.size());
        copy.clear();
        Assertions.assertTrue((boolean)copy.isEmpty());
        Assertions.assertEquals((int)1, (int)stack.size());
    }

    @Test
    public void testClear() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        stack.clear();
        Assertions.assertTrue((boolean)stack.isEmpty());
    }

    @Test
    public void testEqualsVsSameKind() {
        MutableThreadContextStack stack1 = MutableThreadContextStackTest.createStack();
        MutableThreadContextStack stack2 = MutableThreadContextStackTest.createStack();
        Assertions.assertEquals((Object)stack1, (Object)stack1);
        Assertions.assertEquals((Object)stack2, (Object)stack2);
        Assertions.assertEquals((Object)stack1, (Object)stack2);
        Assertions.assertEquals((Object)stack2, (Object)stack1);
    }

    @Test
    public void testHashCodeVsSameKind() {
        MutableThreadContextStack stack1 = MutableThreadContextStackTest.createStack();
        MutableThreadContextStack stack2 = MutableThreadContextStackTest.createStack();
        Assertions.assertEquals((int)stack1.hashCode(), (int)stack2.hashCode());
    }

    static MutableThreadContextStack createStack() {
        MutableThreadContextStack stack1 = new MutableThreadContextStack(new ArrayList());
        stack1.clear();
        Assertions.assertTrue((boolean)stack1.isEmpty());
        stack1.push("msg1");
        stack1.add("msg2");
        stack1.push("msg3");
        Assertions.assertEquals((int)3, (int)stack1.size());
        return stack1;
    }

    @Test
    public void testContains() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Assertions.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testIteratorReturnsInListOrderNotStackOrder() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Iterator iter = stack.iterator();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"msg1", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"msg2", iter.next());
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((Object)"msg3", iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testToArray() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Object[] expecteds = new String[]{"msg1", "msg2", "msg3"};
        Assertions.assertArrayEquals((Object[])expecteds, (Object[])stack.toArray());
    }

    @Test
    public void testToArrayTArray() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Object[] expecteds = new String[]{"msg1", "msg2", "msg3"};
        Object[] result = new String[3];
        Assertions.assertArrayEquals((Object[])expecteds, (Object[])stack.toArray(result));
        Assertions.assertSame((Object)result, (Object)stack.toArray(result));
    }

    @Test
    public void testRemove() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Assertions.assertTrue((boolean)stack.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        stack.remove((Object)"msg1");
        Assertions.assertEquals((int)2, (int)stack.size());
        Assertions.assertTrue((boolean)stack.containsAll(Arrays.asList("msg2", "msg3")));
        Assertions.assertEquals((Object)"msg3", (Object)stack.peek());
        stack.remove((Object)"msg3");
        Assertions.assertEquals((int)1, (int)stack.size());
        Assertions.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assertions.assertEquals((Object)"msg2", (Object)stack.peek());
    }

    @Test
    public void testContainsAll() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        Assertions.assertTrue((boolean)stack.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
    }

    @Test
    public void testAddAll() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        stack.addAll(Arrays.asList("msg4", "msg5"));
        Assertions.assertEquals((int)5, (int)stack.size());
        Assertions.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg3"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg4"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg5"));
    }

    @Test
    public void testRemoveAll() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        stack.removeAll(Arrays.asList("msg1", "msg3"));
        Assertions.assertEquals((int)1, (int)stack.size());
        Assertions.assertFalse((boolean)stack.contains((Object)"msg1"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assertions.assertFalse((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testRetainAll() {
        MutableThreadContextStack stack = MutableThreadContextStackTest.createStack();
        stack.retainAll(Arrays.asList("msg1", "msg3"));
        Assertions.assertEquals((int)2, (int)stack.size());
        Assertions.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assertions.assertFalse((boolean)stack.contains((Object)"msg2"));
        Assertions.assertTrue((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testToStringShowsListContents() {
        MutableThreadContextStack stack = new MutableThreadContextStack(new ArrayList());
        Assertions.assertEquals((Object)"[]", (Object)stack.toString());
        stack.push("msg1");
        stack.add("msg2");
        stack.push("msg3");
        Assertions.assertEquals((Object)"[msg1, msg2, msg3]", (Object)stack.toString());
        stack.retainAll(Arrays.asList("msg1", "msg3"));
        Assertions.assertEquals((Object)"[msg1, msg3]", (Object)stack.toString());
    }

    @Test
    public void testIsFrozenIsFalseByDefault() {
        Assertions.assertFalse((boolean)new MutableThreadContextStack().isFrozen());
        Assertions.assertFalse((boolean)MutableThreadContextStackTest.createStack().isFrozen());
    }

    @Test
    public void testIsFrozenIsTrueAfterCallToFreeze() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        Assertions.assertFalse((boolean)stack.isFrozen());
        stack.freeze();
        Assertions.assertTrue((boolean)stack.isFrozen());
    }

    @Test
    public void testAddAllOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> stack.addAll(Arrays.asList("a", "b", "c")));
    }

    @Test
    public void testAddOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> stack.add("a"));
    }

    @Test
    public void testClearOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((MutableThreadContextStack)stack).clear());
    }

    @Test
    public void testPopOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((MutableThreadContextStack)stack).pop());
    }

    @Test
    public void testPushOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> stack.push("a"));
    }

    @Test
    public void testRemoveOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> stack.remove((Object)"a"));
    }

    @Test
    public void testRemoveAllOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> stack.removeAll(Arrays.asList("a", "b")));
    }

    @Test
    public void testRetainAllOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> stack.retainAll(Arrays.asList("a", "b")));
    }

    @Test
    public void testTrimOnFrozenStackThrowsException() {
        MutableThreadContextStack stack = new MutableThreadContextStack();
        stack.freeze();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> stack.trim(3));
    }
}

