/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.net.URI;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.StringFormatterMessageFactory;
import org.apache.logging.log4j.simple.SimpleLoggerContextFactory;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.ProviderUtil;

public class LogManager {
    private static volatile LoggerContextFactory factory;
    public static final String FACTORY_PROPERTY_NAME = "log4j2.loggerContextFactory";
    private static final Logger LOGGER;
    public static final String ROOT_LOGGER_NAME = "";

    public static boolean exists(String name) {
        return LogManager.getContext().hasLogger(name);
    }

    private static String getClassName(int depth) {
        return new Throwable().getStackTrace()[depth].getClassName();
    }

    public static LoggerContext getContext() {
        return factory.getContext(LogManager.class.getName(), null, null, true);
    }

    public static LoggerContext getContext(boolean currentContext) {
        return factory.getContext(LogManager.class.getName(), null, null, currentContext, null, null);
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext) {
        return factory.getContext(LogManager.class.getName(), loader, null, currentContext);
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, Object externalContext) {
        return factory.getContext(LogManager.class.getName(), loader, externalContext, currentContext);
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, URI configLocation) {
        return factory.getContext(LogManager.class.getName(), loader, null, currentContext, configLocation, null);
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, Object externalContext, URI configLocation) {
        return factory.getContext(LogManager.class.getName(), loader, externalContext, currentContext, configLocation, null);
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, Object externalContext, URI configLocation, String name) {
        return factory.getContext(LogManager.class.getName(), loader, externalContext, currentContext, configLocation, name);
    }

    protected static LoggerContext getContext(String fqcn, boolean currentContext) {
        return factory.getContext(fqcn, null, null, currentContext);
    }

    protected static LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        return factory.getContext(fqcn, loader, null, currentContext);
    }

    public static LoggerContextFactory getFactory() {
        return factory;
    }

    public static void setFactory(LoggerContextFactory factory) {
        LogManager.factory = factory;
    }

    public static Logger getFormatterLogger(Class<?> clazz) {
        return LogManager.getLogger(clazz != null ? clazz.getName() : LogManager.getClassName(2), (MessageFactory)StringFormatterMessageFactory.INSTANCE);
    }

    public static Logger getFormatterLogger(Object value) {
        return LogManager.getLogger(value != null ? value.getClass().getName() : LogManager.getClassName(2), (MessageFactory)StringFormatterMessageFactory.INSTANCE);
    }

    public static Logger getFormatterLogger(String name) {
        return LogManager.getLogger(name != null ? name : LogManager.getClassName(2), (MessageFactory)StringFormatterMessageFactory.INSTANCE);
    }

    public static Logger getLogger() {
        return LogManager.getLogger(LogManager.getClassName(2));
    }

    public static Logger getLogger(Class<?> clazz) {
        return LogManager.getLogger(clazz != null ? clazz.getName() : LogManager.getClassName(2));
    }

    public static Logger getLogger(Class<?> clazz, MessageFactory messageFactory) {
        return LogManager.getLogger(clazz != null ? clazz.getName() : LogManager.getClassName(2), messageFactory);
    }

    public static Logger getLogger(MessageFactory messageFactory) {
        return LogManager.getLogger(LogManager.getClassName(2), messageFactory);
    }

    public static Logger getLogger(Object value) {
        return LogManager.getLogger(value != null ? value.getClass().getName() : LogManager.getClassName(2));
    }

    public static Logger getLogger(Object value, MessageFactory messageFactory) {
        return LogManager.getLogger(value != null ? value.getClass().getName() : LogManager.getClassName(2), messageFactory);
    }

    public static Logger getLogger(String name) {
        String actualName = name != null ? name : LogManager.getClassName(2);
        return factory.getContext(LogManager.class.getName(), null, null, false).getLogger(actualName);
    }

    public static Logger getLogger(String name, MessageFactory messageFactory) {
        String actualName = name != null ? name : LogManager.getClassName(2);
        return factory.getContext(LogManager.class.getName(), null, null, false).getLogger(actualName, messageFactory);
    }

    protected static Logger getLogger(String fqcn, String name) {
        return factory.getContext(fqcn, null, null, false).getLogger(name);
    }

    public static Logger getRootLogger() {
        return LogManager.getLogger(ROOT_LOGGER_NAME);
    }

    protected LogManager() {
    }

    static {
        LOGGER = StatusLogger.getLogger();
        PropertiesUtil managerProps = PropertiesUtil.getProperties();
        String factoryClassName = managerProps.getStringProperty(FACTORY_PROPERTY_NAME);
        ClassLoader cl = LoaderUtil.getThreadContextClassLoader();
        if (factoryClassName != null) {
            try {
                Class<?> clazz = cl.loadClass(factoryClassName);
                if (LoggerContextFactory.class.isAssignableFrom(clazz)) {
                    factory = (LoggerContextFactory)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.error("Unable to locate configured LoggerContextFactory {}", factoryClassName);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to create configured LoggerContextFactory {}", factoryClassName, ex);
            }
        }
        if (factory == null) {
            TreeMap<Integer, LoggerContextFactory> factories = new TreeMap<Integer, LoggerContextFactory>();
            if (ProviderUtil.hasProviders()) {
                for (Provider provider : ProviderUtil.getProviders()) {
                    Class<? extends LoggerContextFactory> factoryClass = provider.loadLoggerContextFactory();
                    if (factoryClass == null) continue;
                    try {
                        factories.put(provider.getPriority(), factoryClass.newInstance());
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to create class {} specified in {}", factoryClass.getName(), provider.getUrl().toString(), e);
                    }
                }
                if (factories.isEmpty()) {
                    LOGGER.error("Log4j2 could not find a logging implementation. Please add log4j-core to the classpath. Using SimpleLogger to log to the console...");
                    factory = new SimpleLoggerContextFactory();
                } else {
                    StringBuilder sb = new StringBuilder("Multiple logging implementations found: \n");
                    for (Map.Entry entry : factories.entrySet()) {
                        sb.append("Factory: ").append(((LoggerContextFactory)entry.getValue()).getClass().getName());
                        sb.append(", Weighting: ").append(entry.getKey()).append('\n');
                    }
                    factory = (LoggerContextFactory)factories.get(factories.lastKey());
                    sb.append("Using factory: ").append(factory.getClass().getName());
                    LOGGER.warn(sb.toString());
                }
            } else {
                LOGGER.error("Log4j2 could not find a logging implementation. Please add log4j-core to the classpath. Using SimpleLogger to log to the console...");
                factory = new SimpleLoggerContextFactory();
            }
        }
    }
}

