/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class LoaderUtil {
    private static final PrivilegedAction<ClassLoader> TCCL_GETTER = new ThreadContextClassLoaderGetter();

    private LoaderUtil() {
    }

    public static ClassLoader getThreadContextClassLoader() {
        return System.getSecurityManager() == null ? TCCL_GETTER.run() : AccessController.doPrivileged(TCCL_GETTER);
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
    }

    private static class ThreadContextClassLoaderGetter
    implements PrivilegedAction<ClassLoader> {
        private ThreadContextClassLoaderGetter() {
        }

        @Override
        public ClassLoader run() {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl == null ? ClassLoader.getSystemClassLoader() : cl;
        }
    }
}

