/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.message.LoggerNameAwareMessage;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.status.StatusLogger;

public class LocalizedMessage
extends ParameterizedMessage
implements LoggerNameAwareMessage {
    private static final long serialVersionUID = 3893703791567290742L;
    private String bundleId;
    private transient ResourceBundle bundle;
    private Locale locale;
    private transient StatusLogger logger = StatusLogger.getLogger();
    private String loggerName = null;

    public LocalizedMessage(String messagePattern, String[] stringArgs, Throwable throwable) {
        super(messagePattern, stringArgs, throwable);
        this.setup(null, null, null);
    }

    public LocalizedMessage(String bundleId, String key, String[] stringArgs, Throwable throwable) {
        super(key, stringArgs, throwable);
        this.setup(bundleId, null, null);
    }

    public LocalizedMessage(ResourceBundle bundle, String key, String[] stringArgs, Throwable throwable) {
        super(key, stringArgs, throwable);
        this.setup(null, bundle, null);
    }

    public LocalizedMessage(String bundleId, Locale locale, String key, String[] stringArgs, Throwable throwable) {
        super(key, stringArgs, throwable);
        this.setup(bundleId, null, locale);
    }

    public LocalizedMessage(ResourceBundle bundle, Locale locale, String key, String[] stringArgs, Throwable throwable) {
        super(key, stringArgs, throwable);
        this.setup(null, bundle, locale);
    }

    public LocalizedMessage(Locale locale, String key, String[] stringArgs, Throwable throwable) {
        super(key, stringArgs, throwable);
        this.setup(null, null, locale);
    }

    public LocalizedMessage(String messagePattern, Object[] arguments) {
        super(messagePattern, arguments);
        this.setup(null, null, null);
    }

    public LocalizedMessage(String bundleId, String key, Object[] arguments) {
        super(key, arguments);
        this.setup(bundleId, null, null);
    }

    public LocalizedMessage(ResourceBundle bundle, String key, Object[] arguments) {
        super(key, arguments);
        this.setup(null, bundle, null);
    }

    public LocalizedMessage(String bundleId, Locale locale, String key, Object[] arguments) {
        super(key, arguments);
        this.setup(bundleId, null, locale);
    }

    public LocalizedMessage(ResourceBundle bundle, Locale locale, String key, Object[] arguments) {
        super(key, arguments);
        this.setup(null, bundle, locale);
    }

    public LocalizedMessage(Locale locale, String key, Object[] arguments) {
        super(key, arguments);
        this.setup(null, null, locale);
    }

    public LocalizedMessage(String messagePattern, Object arg) {
        super(messagePattern, arg);
        this.setup(null, null, null);
    }

    public LocalizedMessage(String bundleId, String key, Object arg) {
        super(key, arg);
        this.setup(bundleId, null, null);
    }

    public LocalizedMessage(ResourceBundle bundle, String key, Object arg) {
        super(key, arg);
        this.setup(null, bundle, null);
    }

    public LocalizedMessage(String bundleId, Locale locale, String key, Object arg) {
        super(key, arg);
        this.setup(bundleId, null, locale);
    }

    public LocalizedMessage(ResourceBundle bundle, Locale locale, String key, Object arg) {
        super(key, arg);
        this.setup(null, bundle, locale);
    }

    public LocalizedMessage(Locale locale, String key, Object arg) {
        super(key, arg);
        this.setup(null, null, locale);
    }

    public LocalizedMessage(String messagePattern, Object arg1, Object arg2) {
        super(messagePattern, arg1, arg2);
        this.setup(null, null, null);
    }

    public LocalizedMessage(String bundleId, String key, Object arg1, Object arg2) {
        super(key, arg1, arg2);
        this.setup(bundleId, null, null);
    }

    public LocalizedMessage(ResourceBundle bundle, String key, Object arg1, Object arg2) {
        super(key, arg1, arg2);
        this.setup(null, bundle, null);
    }

    public LocalizedMessage(String bundleId, Locale locale, String key, Object arg1, Object arg2) {
        super(key, arg1, arg2);
        this.setup(bundleId, null, locale);
    }

    public LocalizedMessage(ResourceBundle bundle, Locale locale, String key, Object arg1, Object arg2) {
        super(key, arg1, arg2);
        this.setup(null, bundle, locale);
    }

    public LocalizedMessage(Locale locale, String key, Object arg1, Object arg2) {
        super(key, arg1, arg2);
        this.setup(null, null, locale);
    }

    public void setLoggerName(String name) {
        this.loggerName = name;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    private void setup(String bundleId, ResourceBundle bundle, Locale locale) {
        this.bundleId = bundleId;
        this.bundle = bundle;
        this.locale = locale;
    }

    public String formatMessage(String messagePattern, String[] args) {
        ResourceBundle bundle = this.bundle;
        if (bundle == null) {
            bundle = this.bundleId != null ? this.getBundle(this.bundleId, this.locale, false) : this.getBundle(this.loggerName, this.locale, true);
        }
        String msgPattern = bundle == null || !bundle.containsKey(messagePattern) ? messagePattern : bundle.getString(messagePattern);
        return LocalizedMessage.format(msgPattern, args);
    }

    protected ResourceBundle getBundle(String key, Locale locale, boolean loop) {
        int i;
        ResourceBundle rb;
        block7: {
            rb = null;
            if (key == null) {
                return null;
            }
            try {
                rb = locale != null ? ResourceBundle.getBundle(key, locale) : ResourceBundle.getBundle(key);
            }
            catch (MissingResourceException ex) {
                if (loop) break block7;
                this.logger.debug("Unable to locate ResourceBundle " + key);
                return null;
            }
        }
        String substr = key;
        while (rb == null && (i = substr.lastIndexOf(".")) > 0) {
            substr = substr.substring(0, i);
            try {
                if (locale != null) {
                    rb = ResourceBundle.getBundle(substr, locale);
                    continue;
                }
                rb = ResourceBundle.getBundle(substr);
            }
            catch (MissingResourceException ex) {
                this.logger.debug("Unable to locate ResourceBundle " + substr);
            }
        }
        return rb;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.bundle = null;
        this.logger = StatusLogger.getLogger();
    }
}

