/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.sparkmeasure;

import ch.cern.sparkmeasure.StageMetrics;
import ch.cern.sparkmeasure.TaskMetrics;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.storage.FSFactory$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\b\u0011\u0001uA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\ta\u0001\u0011\t\u0011)A\u0005i!Aq\b\u0001B\u0001B\u0003%A\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011\u001dy\u0005A1A\u0005\nACa!\u0015\u0001!\u0002\u0013!\u0004\"\u0002*\u0001\t\u0003\u0019\u0006\"\u00028\u0001\t\u0003y\u0007\"B9\u0001\t\u0013\u0011\b\"\u0002<\u0001\t\u00039\b\"B>\u0001\t\u0003a\b\"\u0002@\u0001\t\u0013\u0001\u0006BB@\u0001\t\u0013\t\tAA\bTa\u0006\u00148nU9m\u001b\u0016\f7/\u001e:f\u0015\t\t\"#\u0001\u0007ta\u0006\u00148.\\3bgV\u0014XM\u0003\u0002\u0014)\u0005)1\u000f]1sW*\u0011QCF\u0001\rK:<\u0017N\\3qYV<\u0017N\u001c\u0006\u0003/a\ta\u0001\\5oW&\u001c(BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0015)H/\u001b7t\u0015\tIc#\u0001\u0004d_6lwN\\\u0005\u0003W\u0019\u0012q\u0001T8hO&tw-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002/e5\tqF\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005MA\u0012BA\u001a0\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o!\t)DH\u0004\u00027uA\u0011q\u0007I\u0007\u0002q)\u0011\u0011\bH\u0001\u0007yI|w\u000e\u001e \n\u0005m\u0002\u0013A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!a\u000f\u0011\u0002\u00155,GO]5d)f\u0004X-\u0001\u0006pkR\u0004X\u000f\u001e)bi\"\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u0015\u0002\u0005%|\u0017B\u0001$D\u0005\u001915\u000fU1uQ\u00061A(\u001b8jiz\"R!S&M\u001b:\u0003\"A\u0013\u0001\u000e\u0003AAQ\u0001L\u0003A\u00025BQ\u0001M\u0003A\u0002QBQaP\u0003A\u0002QBQ\u0001Q\u0003A\u0002\u0005\u000bqa]9m)f\u0004X-F\u00015\u0003!\u0019\u0018\u000f\u001c+za\u0016\u0004\u0013!\u00022fO&tGC\u0001+X!\tyR+\u0003\u0002WA\t!QK\\5u\u0011\u0015A\u0006\u00021\u0001Z\u0003\u001diW\r\u001e:jGN\u0004BAW0cW:\u00111,\u0018\b\u0003oqK\u0011!I\u0005\u0003=\u0002\nq\u0001]1dW\u0006<W-\u0003\u0002aC\n1Q)\u001b;iKJT!A\u0018\u0011\u0011\u0005\rLW\"\u00013\u000b\u0005E)'B\u00014h\u0003\u0011\u0019WM\u001d8\u000b\u0003!\f!a\u00195\n\u0005)$'\u0001D*uC\u001e,W*\u001a;sS\u000e\u001c\bCA2m\u0013\tiGMA\u0006UCN\\W*\u001a;sS\u000e\u001c\u0018aA3oIR\u0011A\u000b\u001d\u0005\u00061&\u0001\r!W\u0001\u0013K:\f'\r\\3Ta\u0006\u00148.T3bgV\u0014X-F\u0001t!\tyB/\u0003\u0002vA\t9!i\\8mK\u0006t\u0017aD4fiN\u0003\u0018M]6NKR\u0014\u0018nY:\u0016\u0003a\u00042aH=Z\u0013\tQ\bE\u0001\u0004PaRLwN\\\u0001\u000e_V$\b/\u001e;NKR\u0014\u0018nY:\u0015\u0005Qk\b\"\u0002-\r\u0001\u0004I\u0016\u0001\u00053fi\u0016\u0014X.\u001b8f'FdG+\u001f9f\u00039\u0019w\u000e\u001c7fGRlU\r\u001e:jGN$B!a\u0001\u0002\u001aA9\u0011QAA\bi\u0005MQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u001b\tAA[1wC&!\u0011\u0011CA\u0004\u0005\ri\u0015\r\u001d\t\u0004?\u0005U\u0011bAA\fA\t!Aj\u001c8h\u0011\u0015Af\u00021\u0001Z\u0001")
public class SparkSqlMeasure
implements Logging {
    private final SparkSession sparkSession;
    private final String sql;
    private final String metricType;
    private final FsPath outputPath;
    private final String sqlType;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SparkSqlMeasure sparkSqlMeasure = this;
        synchronized (sparkSqlMeasure) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String sqlType() {
        return this.sqlType;
    }

    public void begin(Either<StageMetrics, TaskMetrics> metrics) {
        Either<StageMetrics, TaskMetrics> either = metrics;
        if (either instanceof Left) {
            Left left = (Left)either;
            StageMetrics stageMetrics = (StageMetrics)left.value();
            stageMetrics.begin();
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            TaskMetrics taskMetrics = (TaskMetrics)right.value();
            taskMetrics.begin();
            return;
        }
        throw new MatchError(either);
    }

    public void end(Either<StageMetrics, TaskMetrics> metrics) {
        Either<StageMetrics, TaskMetrics> either = metrics;
        if (either instanceof Left) {
            Left left = (Left)either;
            StageMetrics stageMetrics = (StageMetrics)left.value();
            stageMetrics.end();
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            TaskMetrics taskMetrics = (TaskMetrics)right.value();
            taskMetrics.end();
            return;
        }
        throw new MatchError(either);
    }

    private boolean enableSparkMeasure() {
        String string = this.sqlType();
        return "SELECT".equals(string) ? true : "INSERT".equals(string);
    }

    public Option<Either<StageMetrics, TaskMetrics>> getSparkMetrics() {
        if (this.enableSparkMeasure()) {
            String string = this.metricType;
            if ("stage".equals(string)) {
                return new Some((Object)package$.MODULE$.Left().apply((Object)new StageMetrics(this.sparkSession)));
            }
            if ("task".equals(string)) {
                return new Some((Object)package$.MODULE$.Right().apply((Object)new TaskMetrics(this.sparkSession)));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public void outputMetrics(Either<StageMetrics, TaskMetrics> metrics) {
        if (this.enableSparkMeasure()) {
            Map<String, Object> metricsMap = this.collectMetrics(metrics);
            if (MapUtils.isNotEmpty(metricsMap)) {
                HashMap<String, Object> retMap = new HashMap<String, Object>();
                retMap.put("execution_code", this.sql);
                retMap.put("metrics", metricsMap);
                ObjectMapper mapper = new ObjectMapper();
                byte[] bytes = mapper.writeValueAsBytes(retMap);
                try (Fs fs = FSFactory$.MODULE$.getFs(this.outputPath);){
                    Object object = !fs.exists(this.outputPath.getParent()) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(this.outputPath.getParent())) : BoxedUnit.UNIT;
                    OutputStream out = fs.write(this.outputPath, true);
                    try {
                        out.write(bytes);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)out);
                    }
                }
                return;
            }
            return;
        }
    }

    private String determineSqlType() {
        ParserInterface parser = this.sparkSession.sessionState().sqlParser();
        LogicalPlan logicalPlan = parser.parsePlan(this.sql);
        String string = logicalPlan.getClass().getSimpleName();
        if ("UnresolvedWith".equals(string) ? true : ("Project".equals(string) ? true : "GlobalLimit".equals(string))) {
            return "SELECT";
        }
        if ("InsertIntoStatement".equals(string) ? true : ("CreateTableAsSelectStatement".equals(string) ? true : "CreateTableAsSelect".equals(string))) {
            return "INSERT";
        }
        this.logger().info("Unsupported sql type");
        return string;
    }

    private Map<String, Object> collectMetrics(Either<StageMetrics, TaskMetrics> metrics) {
        Either<StageMetrics, TaskMetrics> either = metrics;
        if (either instanceof Left) {
            Left left = (Left)either;
            StageMetrics stageMetrics = (StageMetrics)left.value();
            return stageMetrics.aggregateStageMetricsJavaMap();
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            TaskMetrics taskMetrics = (TaskMetrics)right.value();
            return taskMetrics.aggregateTaskMetricsJavaMap();
        }
        return new HashMap<String, Object>();
    }

    public SparkSqlMeasure(SparkSession sparkSession, String sql, String metricType, FsPath outputPath) {
        this.sparkSession = sparkSession;
        this.sql = sql;
        this.metricType = metricType;
        this.outputPath = outputPath;
        Logging.$init$((Logging)this);
        this.sqlType = this.determineSqlType();
    }
}

