/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.pipeline.executor;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.manager.engineplugin.pipeline.conf.PipelineEngineConfiguration$;
import org.apache.linkis.manager.engineplugin.pipeline.executor.CopyExecutor$;
import org.apache.linkis.manager.engineplugin.pipeline.executor.OutputStreamCache$;
import org.apache.linkis.manager.engineplugin.pipeline.executor.PipeLineExecutor;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.storage.FSFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3AAC\u0006\u00015!)Q\u0005\u0001C\u0001M!)\u0001\u0006\u0001C!S!)Q\n\u0001C!\u001d\u001e)qj\u0003E\u0001!\u001a)!b\u0003E\u0001#\")Q%\u0002C\u0001%\"91+\u0002b\u0001\n\u0003!\u0006BB+\u0006A\u0003%q\u0005C\u0003W\u000b\u0011\u0005qK\u0001\u0007D_BLX\t_3dkR|'O\u0003\u0002\r\u001b\u0005AQ\r_3dkR|'O\u0003\u0002\u000f\u001f\u0005A\u0001/\u001b9fY&tWM\u0003\u0002\u0011#\u0005aQM\\4j]\u0016\u0004H.^4j]*\u0011!cE\u0001\b[\u0006t\u0017mZ3s\u0015\t!R#\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\rj\u0011aC\u0005\u0003I-\u0011\u0001\u0003U5qK2Kg.Z#yK\u000e,Ho\u001c:\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0012\u0001\u0003\u001d)\u00070Z2vi\u0016$BA\u000b\u001a@\u0003B\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\tKb,7-\u001e;fe*\u0011qfE\u0001\ng\u000eDW\rZ;mKJL!!\r\u0017\u0003\u001f\u0015CXmY;uKJ+7\u000f]8og\u0016DQa\r\u0002A\u0002Q\n!b]8ve\u000e,\u0007+\u0019;i!\t)DH\u0004\u00027uA\u0011q'H\u0007\u0002q)\u0011\u0011(G\u0001\u0007yI|w\u000e\u001e \n\u0005mj\u0012A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!aO\u000f\t\u000b\u0001\u0013\u0001\u0019\u0001\u001b\u0002\u0011\u0011,7\u000f\u001e)bi\"DQA\u0011\u0002A\u0002\r\u000ba#\u001a8hS:,W\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0003\t.k\u0011!\u0012\u0006\u0003Q\u0019S!\u0001D$\u000b\u0005!K\u0015aC2p[B,H/\u0019;j_:T!AS\n\u0002\u0015\u0015tw-\u001b8fG>tg.\u0003\u0002M\u000b\n1RI\\4j]\u0016,\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0003LS:$W#\u0001\u001b\u0002\u0019\r{\u0007/_#yK\u000e,Ho\u001c:\u0011\u0005\t*1CA\u0003\u001c)\u0005\u0001\u0016\u0001D2paf,\u00050Z2vi>\u0014X#A\u0014\u0002\u001b\r|\u0007/_#yK\u000e,Ho\u001c:!\u0003-9W\r^%ogR\fgnY3\u0016\u0003\u0005\u0002")
public class CopyExecutor
implements PipeLineExecutor {
    private Map<String, String> options;

    public static PipeLineExecutor getInstance() {
        return CopyExecutor$.MODULE$.getInstance();
    }

    public static CopyExecutor copyExecutor() {
        return CopyExecutor$.MODULE$.copyExecutor();
    }

    @Override
    public void init(Map<String, String> newOptions) {
        PipeLineExecutor.init$(this, newOptions);
    }

    @Override
    public void cleanOptions() {
        PipeLineExecutor.cleanOptions$(this);
    }

    @Override
    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public void options_$eq(Map<String, String> x$1) {
        this.options = x$1;
    }

    @Override
    public ExecuteResponse execute(String sourcePath, String destPath, EngineExecutionContext engineExecutionContext) {
        FsPath sourceFsPath = new FsPath(sourcePath);
        FsPath destFsPath = new FsPath(destPath);
        Fs sourceFs = FSFactory$.MODULE$.getFs(sourceFsPath);
        sourceFs.init(null);
        Fs destFs = FSFactory$.MODULE$.getFs(destFsPath);
        destFs.init(null);
        InputStream inputStream = sourceFs.read(sourceFsPath);
        boolean isOverWrite = BoxesRunTime.unboxToBoolean((Object)PipelineEngineConfiguration$.MODULE$.PIPELINE_OUTPUT_ISOVERWRITE_SWITCH().getValue(this.options()));
        if (!isOverWrite && !destFs.exists(destFsPath)) {
            isOverWrite = true;
        }
        OutputStream outputStream = destFs.write(destFsPath, isOverWrite);
        OutputStreamCache$.MODULE$.osCache().put((String)engineExecutionContext.getJobId().get(), outputStream);
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((Closeable)sourceFs);
        IOUtils.closeQuietly((Closeable)destFs);
        return PipeLineExecutor.execute$(this, sourcePath, destPath, engineExecutionContext);
    }

    @Override
    public String Kind() {
        return "cp";
    }

    public CopyExecutor() {
        PipeLineExecutor.$init$(this);
    }
}

