/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.jdbc.executor;

import java.io.Closeable;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.OverloadUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.entity.EngineConnTask;
import org.apache.linkis.engineconn.computation.executor.execute.ConcurrentComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.SQLCodeParser;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.engineplugin.common.util.NodeResourceUtils$;
import org.apache.linkis.manager.engineplugin.jdbc.ConnectionManager;
import org.apache.linkis.manager.engineplugin.jdbc.conf.JDBCConfiguration$;
import org.apache.linkis.manager.engineplugin.jdbc.errorcode.JDBCErrorCodeSummary;
import org.apache.linkis.manager.engineplugin.jdbc.exception.JDBCGetDatasourceInfoException;
import org.apache.linkis.manager.engineplugin.jdbc.exception.JDBCParamsIllegalException;
import org.apache.linkis.manager.engineplugin.jdbc.executor.JDBCEngineConfig$;
import org.apache.linkis.manager.engineplugin.jdbc.executor.JDBCHelper;
import org.apache.linkis.manager.engineplugin.jdbc.executor.JDBCMultiDatasourceParser$;
import org.apache.linkis.manager.engineplugin.jdbc.monitor.ProgressMonitor;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.scheduler.executer.AliasOutputExecuteResponse;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.domain.DataType$;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.springframework.util.CollectionUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001\u0002\u0013&\u0001QB\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t%\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0005\"A\u0011\n\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003C\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u001d\t\u0006A1A\u0005\nICaa\u0016\u0001!\u0002\u0013\u0019\u0006b\u0002-\u0001\u0005\u0004%I!\u0017\u0005\u0007_\u0002\u0001\u000b\u0011\u0002.\t\u000f]\u0004!\u0019!C\u0005q\"9\u00111\u0005\u0001!\u0002\u0013I\b\"CA\u0013\u0001\t\u0007I\u0011BA\u0014\u0011!\t9\u0004\u0001Q\u0001\n\u0005%\u0002bBA\u001d\u0001\u0011\u0005\u00131\b\u0005\u0007q\u0001!\t%a\u0011\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0004bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\ti\n\u0001C\u0005\u0003?Cq!!*\u0001\t#\t9\u000bC\u0004\u00028\u0002!\t%!/\t\u000f\u0005U\u0007\u0001\"\u0015\u0002<!9\u0011q\u001b\u0001\u0005B\u0005e\u0007bBAr\u0001\u0011\u0005\u00131\b\u0005\b\u0003K\u0004A\u0011IAt\u0011\u001d\t\t\u0010\u0001C!\u0003gDqA!\u0001\u0001\t\u0003\u0012\u0019\u0001C\u0004\u0003\u0016\u0001!\tEa\u0006\t\u000f\t=\u0002\u0001\"\u0011\u00032!9!1\u0007\u0001\u0005B\tU\u0002b\u0002B\u001c\u0001\u0011\u0005#\u0011\b\u0005\u0007\u0005w\u0001A\u0011I!\t\u000f\tu\u0002\u0001\"\u0011\u0002<!9!q\b\u0001\u0005B\t\u0005#A\u0006&E\u0005\u000e+enZ5oK\u000e{gN\\#yK\u000e,Ho\u001c:\u000b\u0005\u0019:\u0013\u0001C3yK\u000e,Ho\u001c:\u000b\u0005!J\u0013\u0001\u00026eE\u000eT!AK\u0016\u0002\u0019\u0015tw-\u001b8fa2,x-\u001b8\u000b\u00051j\u0013aB7b]\u0006<WM\u001d\u0006\u0003]=\na\u0001\\5oW&\u001c(B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001kA\u0011aGP\u0007\u0002o)\u0011\u0001(O\u0001\bKb,7-\u001e;f\u0015\t1#H\u0003\u0002<y\u0005Y1m\\7qkR\fG/[8o\u0015\tiT&\u0001\u0006f]\u001eLg.Z2p]:L!aP\u001c\u0003;\r{gnY;se\u0016tGoQ8naV$\u0018\r^5p]\u0016CXmY;u_J\f\u0001c\\;uaV$\bK]5oi2KW.\u001b;\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u00131!\u00138u\u0003EyW\u000f\u001e9viB\u0013\u0018N\u001c;MS6LG\u000fI\u0001\u0003S\u0012\f1!\u001b3!\u0003\u0019a\u0014N\\5u}Q\u0019Qj\u0014)\u0011\u00059\u0003Q\"A\u0013\t\u000b\u0001+\u0001\u0019\u0001\"\t\u000b%+\u0001\u0019\u0001\"\u0002#\r|gN\\3di&|g.T1oC\u001e,'/F\u0001T!\t!V+D\u0001(\u0013\t1vEA\tD_:tWm\u0019;j_:l\u0015M\\1hKJ\f!cY8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3sA\u0005qQ\r_3dkR|'\u000fT1cK2\u001cX#\u0001.\u0011\u0007m\u0003'-D\u0001]\u0015\tif,\u0001\u0003vi&d'\"A0\u0002\t)\fg/Y\u0005\u0003Cr\u0013A\u0001T5tiB\u00121-\u001c\t\u0004I&\\W\"A3\u000b\u0005\u0019<\u0017AB3oi&$\u0018P\u0003\u0002iW\u0005)A.\u00192fY&\u0011!.\u001a\u0002\u0006\u0019\u0006\u0014W\r\u001c\t\u0003Y6d\u0001\u0001B\u0005o\u0013\u0005\u0005\t\u0011!B\u0001a\n\u0019q\fJ\u0019\u0002\u001f\u0015DXmY;u_Jd\u0015MY3mg\u0002\n\"!\u001d;\u0011\u0005\r\u0013\u0018BA:E\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aQ;\n\u0005Y$%aA!os\u0006\u0001\u0002O]8he\u0016\u001c8/T8oSR|'o]\u000b\u0002sB)1L\u001f?\u0002\u0010%\u00111\u0010\u0018\u0002\u0004\u001b\u0006\u0004\bcA?\u0002\n9\u0019a0!\u0002\u0011\u0005}$UBAA\u0001\u0015\r\t\u0019aM\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001dA)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\tiA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000f!\u0005\u0007BA\t\u0003?\u0001b!a\u0005\u0002\u001a\u0005uQBAA\u000b\u0015\r\t9bJ\u0001\b[>t\u0017\u000e^8s\u0013\u0011\tY\"!\u0006\u0003\u001fA\u0013xn\u001a:fgNluN\\5u_J\u00042\u0001\\A\u0010\t)\t\tcCA\u0001\u0002\u0003\u0015\t\u0001\u001d\u0002\u0004?\u0012\u001a\u0014!\u00059s_\u001e\u0014Xm]:N_:LGo\u001c:tA\u0005y1m\u001c8oK\u000e$\u0018n\u001c8DC\u000eDW-\u0006\u0002\u0002*A)1L\u001f?\u0002,A!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022y\u000b1a]9m\u0013\u0011\t)$a\f\u0003\u0015\r{gN\\3di&|g.\u0001\td_:tWm\u0019;j_:\u001c\u0015m\u00195fA\u0005!\u0011N\\5u)\t\ti\u0004E\u0002D\u0003\u007fI1!!\u0011E\u0005\u0011)f.\u001b;\u0015\t\u0005\u0015\u0013Q\u000b\t\u0005\u0003\u000f\n\t&\u0004\u0002\u0002J)!\u00111JA'\u0003!)\u00070Z2vi\u0016\u0014(bAA([\u0005I1o\u00195fIVdWM]\u0005\u0005\u0003'\nIEA\bFq\u0016\u001cW\u000f^3SKN\u0004xN\\:f\u0011\u001d\t9f\u0004a\u0001\u00033\na\"\u001a8hS:,7i\u001c8o)\u0006\u001c8\u000e\u0005\u0003\u0002\\\u0005}SBAA/\u0015\t1\u0017(\u0003\u0003\u0002b\u0005u#AD#oO&tWmQ8o]R\u000b7o[\u0001\u000eO\u0016$8i\u001c8oK\u000e$\u0018n\u001c8\u0015\t\u0005-\u0012q\r\u0005\b\u0003S\u0002\u0002\u0019AA6\u0003U)gnZ5oK\u0016CXmY;u_J\u001cuN\u001c;fqR\u00042ANA7\u0013\r\tyg\u000e\u0002\u0017\u000b:<\u0017N\\3Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006YQ\r_3dkR,G*\u001b8f)\u0019\t)%!\u001e\u0002x!9\u0011\u0011N\tA\u0002\u0005-\u0004BBA=#\u0001\u0007A0\u0001\u0003d_\u0012,\u0017\u0001F4fi*#%i\u0011*v]RLW.\u001a)be\u0006l7\u000f\u0006\u0003\u0002\u0000\u0005\u0005\u0005\u0003B.{yrDq!!\u001b\u0013\u0001\u0004\tY'\u0001\fhKR,\u00050Z2SKN,H\u000e^*fi>+H\u000f];u)!\t)%a\"\u0002\n\u0006M\u0005bBA5'\u0001\u0007\u00111\u000e\u0005\b\u0003\u0017\u001b\u0002\u0019AAG\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0005\u0003\u0002.\u0005=\u0015\u0002BAI\u0003_\u0011\u0011b\u0015;bi\u0016lWM\u001c;\t\u000f\u0005U5\u00031\u0001\u0002\u0018\u0006I!/Z:vYR\u001cV\r\u001e\t\u0005\u0003[\tI*\u0003\u0003\u0002\u001c\u0006=\"!\u0003*fgVdGoU3u\u000399W\r^#yK\u000e\u001c\u0016\u000f\\+tKJ$2\u0001`AQ\u0011\u001d\t\u0019\u000b\u0006a\u0001\u0003W\na#\u001a8hS:,W\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\rSN$E\tT\"p[6\fg\u000e\u001a\u000b\u0007\u0003S\u000by+a-\u0011\u0007\r\u000bY+C\u0002\u0002.\u0012\u0013qAQ8pY\u0016\fg\u000e\u0003\u0004\u00022V\u0001\rAQ\u0001\rkB$\u0017\r^3e\u0007>,h\u000e\u001e\u0005\u0007\u0003k+\u0002\u0019\u0001\"\u0002\u0017\r|G.^7o\u0007>,h\u000e^\u0001\u0010O\u0016$\bK]8he\u0016\u001c8/\u00138g_R!\u00111XAi!\u0015\u0019\u0015QXAa\u0013\r\ty\f\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u0007\fi-\u0004\u0002\u0002F*!\u0011qYAe\u0003\u0019)gnZ5oK*\u0019\u00111Z\u0017\u0002\u0011A\u0014x\u000e^8d_2LA!a4\u0002F\ny!j\u001c2Qe><'/Z:t\u0013:4w\u000e\u0003\u0004\u0002TZ\u0001\r\u0001`\u0001\u0007i\u0006\u001c8.\u0013#\u0002\u0011\r\fG\u000e\u001c2bG.\f\u0001\u0002\u001d:pOJ,7o\u001d\u000b\u0005\u00037\f\t\u000fE\u0002D\u0003;L1!a8E\u0005\u00151En\\1u\u0011\u0019\t\u0019\u000e\u0007a\u0001y\u0006)1\r\\8tK\u0006\tR\r_3dkR,7i\\7qY\u0016$X\r\\=\u0015\u0011\u0005\u0015\u0013\u0011^Av\u0003[Dq!!\u001b\u001b\u0001\u0004\tY\u0007\u0003\u0004\u0002zi\u0001\r\u0001 \u0005\u0007\u0003_T\u0002\u0019\u0001?\u0002\u001b\r|W\u000e\u001d7fi\u0016$G*\u001b8f\u0003E9W\r^#yK\u000e,Ho\u001c:MC\n,Gn\u001d\u000b\u0003\u0003k\u0004Ba\u00171\u0002xB\"\u0011\u0011`A\u007f!\u0011!\u0017.a?\u0011\u00071\fi\u0010\u0002\u0006\u0002\u0000n\t\t\u0011!A\u0003\u0002A\u00141a\u0018\u00136\u0003E\u0019X\r^#yK\u000e,Ho\u001c:MC\n,Gn\u001d\u000b\u0005\u0003{\u0011)\u0001C\u0004\u0003\bq\u0001\rA!\u0003\u0002\r1\f'-\u001a7t!\u0011Y\u0006Ma\u00031\t\t5!\u0011\u0003\t\u0005I&\u0014y\u0001E\u0002m\u0005#!1Ba\u0005\u0003\u0006\u0005\u0005\t\u0011!B\u0001a\n\u0019q\f\n\u001c\u0002/I,\u0017/^3ti\u0016C\b/Z2uK\u0012\u0014Vm]8ve\u000e,G\u0003\u0002B\r\u0005W\u0001BAa\u0007\u0003(5\u0011!Q\u0004\u0006\u0005\u0005?\u0011\t#\u0001\u0005sKN|WO]2f\u0015\r1'1\u0005\u0006\u0004\u0005KY\u0013AB2p[6|g.\u0003\u0003\u0003*\tu!\u0001\u0004(pI\u0016\u0014Vm]8ve\u000e,\u0007b\u0002B\u0017;\u0001\u0007!\u0011D\u0001\u0011Kb\u0004Xm\u0019;fIJ+7o\\;sG\u0016\facZ3u\u0007V\u0014(/\u001a8u\u001d>$WMU3t_V\u00148-\u001a\u000b\u0003\u00053\t1c];qa>\u0014HoQ1mY\n\u000b7m\u001b'pON$\"!!+\u0002\u000b\u001d,G/\u00133\u0016\u0003q\f!cZ3u\u0007>t7-\u001e:sK:$H*[7ji\u000691.\u001b7m\u00032d\u0017\u0001C6jY2$\u0016m]6\u0015\t\u0005u\"1\t\u0005\u0007\u0005\u000b\u001a\u0003\u0019\u0001?\u0002\rQ\f7o[%e\u0001")
public class JDBCEngineConnExecutor
extends ConcurrentComputationExecutor {
    private final int outputPrintLimit;
    private final int id;
    private final ConnectionManager connectionManager;
    private final List<Label<?>> executorLabels;
    private final Map<String, ProgressMonitor<?>> progressMonitors;
    private final Map<String, Connection> connectionCache;

    public int outputPrintLimit() {
        return this.outputPrintLimit;
    }

    public int id() {
        return this.id;
    }

    private ConnectionManager connectionManager() {
        return this.connectionManager;
    }

    private List<Label<?>> executorLabels() {
        return this.executorLabels;
    }

    private Map<String, ProgressMonitor<?>> progressMonitors() {
        return this.progressMonitors;
    }

    private Map<String, Connection> connectionCache() {
        return this.connectionCache;
    }

    public void init() {
        this.logger().info("jdbc executor start init.");
        this.setCodeParser((CodeParser)new SQLCodeParser());
        super.init();
        if (BoxesRunTime.unboxToBoolean((Object)JDBCConfiguration$.MODULE$.JDBC_KERBEROS_ENABLE().getValue())) {
            this.connectionManager().startRefreshKerberosLoginStatusThread();
            return;
        }
    }

    public ExecuteResponse execute(EngineConnTask engineConnTask) {
        Object object;
        ExecuteResponse executeResponse = super.execute(engineConnTask);
        if (StringUtils.isNotBlank((CharSequence)engineConnTask.getTaskId())) {
            Connection connection = this.connectionCache().remove(engineConnTask.getTaskId());
            this.logger().info(new StringBuilder(23).append("remove task ").append(engineConnTask.getTaskId()).append(" connection").toString());
            object = Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> connection.close(), this.logger());
        } else {
            object = BoxedUnit.UNIT;
        }
        return executeResponse;
    }

    private Connection getConnection(EngineExecutionContext engineExecutorContext) {
        String taskId = (String)engineExecutorContext.getJobId().orNull(Predef$.MODULE$.$conforms());
        if (StringUtils.isNotBlank((CharSequence)taskId) && this.connectionCache().containsKey(taskId)) {
            this.logger().info(new StringBuilder(43).append("Task ").append(taskId).append("  paragraph ").append(engineExecutorContext.getCurrentParagraph()).append(" from cache get connection").toString());
            return this.connectionCache().get(taskId);
        }
        Map<String, String> properties = this.getJDBCRuntimeParams(engineExecutorContext);
        this.logger().info(new StringBuilder(24).append("The jdbc properties is: ").append(properties).toString());
        String dataSourceName = properties.get("wds.linkis.engine.runtime.datasource");
        String dataSourceMaxVersionId = properties.get("wds.linkis.engine.runtime.datasource.maxVersionId");
        this.logger().info(new StringBuilder(67).append("The data source name is [").append(dataSourceName).append("], and the jdbc client begins to run task ").append(taskId).toString());
        this.logger().info(new StringBuilder(30).append("The data source properties is ").append(properties).toString());
        String jdbcUrl = properties.get("wds.linkis.jdbc.connect.url");
        String execUser = properties.get("execUser");
        String proxyUser = properties.get("wds.linkis.jdbc.proxy.user.property");
        String dataSourceIdentifier = new StringBuilder(2).append(jdbcUrl).append("-").append(execUser).append("-").append(proxyUser).toString();
        if (StringUtils.isNotBlank((CharSequence)dataSourceName)) {
            dataSourceIdentifier = new StringBuilder(1).append(dataSourceName).append("-").append(dataSourceMaxVersionId).toString();
        }
        Connection connection = this.connectionManager().getConnection(dataSourceIdentifier, properties);
        Object object = StringUtils.isNotBlank((CharSequence)taskId) ? this.connectionCache().put(taskId, connection) : BoxedUnit.UNIT;
        return connection;
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutorContext, String code) {
        ErrorExecuteResponse errorExecuteResponse;
        String taskId = (String)engineExecutorContext.getJobId().get();
        Connection connection = this.getConnection(engineExecutorContext);
        ObjectRef statement = ObjectRef.create(null);
        ObjectRef resultSet = ObjectRef.create(null);
        try {
            try {
                Object object;
                statement.elem = connection.createStatement();
                if (((Statement)statement.elem).getQueryTimeout() == 0) {
                    ((Statement)statement.elem).setQueryTimeout(BoxesRunTime.unboxToInt((Object)JDBCConfiguration$.MODULE$.JDBC_QUERY_TIMEOUT().getValue()));
                }
                ((Statement)statement.elem).setFetchSize(this.outputPrintLimit());
                ((Statement)statement.elem).setMaxRows(this.outputPrintLimit());
                ProgressMonitor<?> monitor = ProgressMonitor.attachMonitor((Statement)statement.elem);
                if (monitor != null) {
                    monitor.callback(new Runnable(this, engineExecutorContext, taskId){
                        private final /* synthetic */ JDBCEngineConnExecutor $outer;
                        private final EngineExecutionContext engineExecutorContext$1;
                        private final String taskId$1;

                        public void run() {
                            this.engineExecutorContext$1.pushProgress(this.$outer.progress(this.taskId$1), this.$outer.getProgressInfo(this.taskId$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.engineExecutorContext$1 = engineExecutorContext$1;
                            this.taskId$1 = taskId$1;
                        }
                    });
                    object = this.progressMonitors().put(taskId, monitor);
                } else {
                    object = BoxedUnit.UNIT;
                }
                this.logger().info(new StringBuilder(22).append("create statement is:  ").append((Statement)statement.elem).toString());
                this.connectionManager().saveStatement(taskId, (Statement)statement.elem);
                boolean isResultSetAvailable = ((Statement)statement.elem).execute(code);
                this.logger().info(new StringBuilder(27).append("Is ResultSet available ? : ").append(isResultSetAvailable).toString());
                if (monitor != null) {
                    engineExecutorContext.pushProgress(this.progress(taskId), this.getProgressInfo(taskId));
                }
                try {
                    if (isResultSetAvailable) {
                        this.logger().info("ResultSet is available");
                        resultSet.elem = ((Statement)statement.elem).getResultSet();
                        errorExecuteResponse = this.getExecResultSetOutput(engineExecutorContext, (Statement)statement.elem, (ResultSet)resultSet.elem);
                    } else {
                        int updateCount = ((Statement)statement.elem).getUpdateCount();
                        this.logger().info(new StringBuilder(26).append("only return affect rows : ").append(updateCount).toString());
                        engineExecutorContext.appendStdout(new StringBuilder(26).append("only return affect rows : ").append(updateCount).toString());
                        errorExecuteResponse = new SuccessExecuteResponse();
                    }
                }
                catch (Throwable throwable) {
                    Object object2 = (ResultSet)resultSet.elem != null ? Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ResultSet)resultSet$1.elem).close(), this.logger()) : BoxedUnit.UNIT;
                    if ((Statement)statement.elem != null) {
                        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Statement)statement$1.elem).close(), this.logger());
                    }
                    throw throwable;
                }
                Object object3 = (ResultSet)resultSet.elem != null ? Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ResultSet)resultSet$1.elem).close(), this.logger()) : BoxedUnit.UNIT;
                if ((Statement)statement.elem != null) {
                    Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Statement)statement$1.elem).close(), this.logger());
                }
            }
            catch (Throwable e) {
                this.logger().error(new StringBuilder(11).append("Cannot run ").append(code).toString(), e);
                errorExecuteResponse = new ErrorExecuteResponse(e.getMessage(), e);
            }
        }
        finally {
            this.connectionManager().removeStatement(taskId);
        }
        return errorExecuteResponse;
    }

    private Map<String, String> getJDBCRuntimeParams(EngineExecutionContext engineExecutorContext) {
        Object object;
        String execSqlUser = this.getExecSqlUser(engineExecutorContext);
        HashMap executorProperties = engineExecutorContext.getProperties();
        if (executorProperties == null) {
            executorProperties = new HashMap();
        }
        Map globalConfig = (Map)Utils$.MODULE$.tryAndWarn((Function0 & Serializable & scala.Serializable)() -> JDBCEngineConfig$.MODULE$.getCacheMap(engineExecutorContext.getLabels()), this.logger());
        ObjectRef dataSourceInfo = ObjectRef.create(new HashMap());
        ObjectRef dataSourceName = ObjectRef.create((Object)executorProperties.getOrDefault("wds.linkis.engine.runtime.datasource", ""));
        String dataSourceQuerySystemParam = executorProperties.getOrDefault("wds.linkis.engine.runtime.datasource.systemQueryParam", "");
        if (StringUtils.isNotBlank((CharSequence)((String)dataSourceName.elem))) {
            this.logger().info("Start getting data source connection parameters from the data source hub.");
            object = Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                dataSourceInfo$1.elem = JDBCMultiDatasourceParser$.MODULE$.queryDatasourceInfoByName((String)dataSourceName$1.elem, execSqlUser, dataSourceQuerySystemParam);
            }, (Function1 & Serializable & scala.Serializable)e -> {
                JDBCEngineConnExecutor.$anonfun$getJDBCRuntimeParams$3(e);
                return BoxedUnit.UNIT;
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        if (StringUtils.isBlank((CharSequence)((String)dataSourceName.elem))) {
            dataSourceName.elem = "jdbc";
        }
        if ((Map)dataSourceInfo.elem != null && !((Map)dataSourceInfo.elem).isEmpty()) {
            globalConfig.putAll((Map)dataSourceInfo.elem);
        }
        if (!executorProperties.isEmpty()) {
            globalConfig.putAll(executorProperties);
        }
        globalConfig.put("wds.linkis.engine.runtime.datasource", (String)dataSourceName.elem);
        globalConfig.put("execUser", execSqlUser);
        globalConfig.put("wds.linkis.jdbc.proxy.user", globalConfig.getOrDefault("wds.linkis.jdbc.proxy.user", execSqlUser));
        return globalConfig;
    }

    private ExecuteResponse getExecResultSetOutput(EngineExecutionContext engineExecutorContext, Statement statement, ResultSet resultSet) {
        ExecuteResponse executeResponse;
        Object object = new Object();
        try {
            if (this.isDDLCommand(statement.getUpdateCount(), resultSet.getMetaData().getColumnCount())) {
                this.logger().info("current result is a ResultSet Object , but there are no more results!");
                executeResponse = new SuccessExecuteResponse();
            } else {
                ResultSetMetaData md = resultSet.getMetaData();
                ArrayBuffer metaArrayBuffer = new ArrayBuffer();
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), md.getColumnCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> metaArrayBuffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)md.getColumnName(i), (Object)JDBCHelper.getTypeStr(md.getColumnType(i)))})));
                Column[] columns = (Column[])((TraversableOnce)metaArrayBuffer.map((Function1 & Serializable & scala.Serializable)c -> new Column((String)c._1(), DataType$.MODULE$.toDataType((String)c._2()), ""), ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Column.class));
                TableMetaData metaData = new TableMetaData(columns);
                ResultSetWriter resultSetWriter = engineExecutorContext.createResultSetWriter(ResultSetFactory$.MODULE$.TABLE_TYPE());
                resultSetWriter.addMetaData((MetaData)metaData);
                IntRef count = IntRef.create((int)0);
                Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    while (count$1.elem < this.outputPrintLimit() && resultSet.next()) {
                        Object[] r = (Object[])((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).indices().map((Function1 & Serializable & scala.Serializable)i -> JDBCEngineConnExecutor.$anonfun$getExecResultSetOutput$4(resultSet, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
                        resultSetWriter.addRecord((Record)new TableRecord(r));
                        ++count$1.elem;
                    }
                }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    JDBCEngineConnExecutor.$anonfun$getExecResultSetOutput$5(object, x0$1);
                    return BoxedUnit.UNIT;
                });
                String output = resultSetWriter != null ? resultSetWriter.toString() : null;
                Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((Closeable)resultSetWriter));
                this.logger().info("sql executed completed.");
                executeResponse = new AliasOutputExecuteResponse(null, output);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                executeResponse = (ExecuteResponse)ex.value();
            }
            throw ex;
        }
        return executeResponse;
    }

    private String getExecSqlUser(EngineExecutionContext engineExecutionContext) {
        UserCreatorLabel userCreatorLabel = (UserCreatorLabel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])engineExecutionContext.getLabels())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JDBCEngineConnExecutor.$anonfun$getExecSqlUser$1(x$1))).get();
        return userCreatorLabel.getUser();
    }

    public boolean isDDLCommand(int updatedCount, int columnCount) {
        return updatedCount < 0 && columnCount <= 0;
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        ProgressMonitor<?> monitor = this.progressMonitors().get(taskID);
        if (monitor != null) {
            return (JobProgressInfo[])((Object[])new JobProgressInfo[]{monitor.jobProgressInfo(taskID)});
        }
        return (JobProgressInfo[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(JobProgressInfo.class));
    }

    public void callback() {
    }

    public float progress(String taskID) {
        ProgressMonitor<?> monitor = this.progressMonitors().get(taskID);
        if (monitor != null) {
            return monitor.getSqlProgress();
        }
        return 0.0f;
    }

    public void close() {
        this.logger().info("Start closing the jdbc engine.");
        this.connectionManager().close();
        if (BoxesRunTime.unboxToBoolean((Object)JDBCConfiguration$.MODULE$.JDBC_KERBEROS_ENABLE().getValue())) {
            this.connectionManager().shutdownRefreshKerberosLoginService();
        }
        this.logger().info("The jdbc engine has closed successfully.");
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutorContext, String code, String completedLine) {
        return null;
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels();
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        if (!CollectionUtils.isEmpty(labels)) {
            this.executorLabels().clear();
            this.executorLabels().addAll(labels);
            return;
        }
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public NodeResource getCurrentNodeResource() {
        NodeResourceUtils$.MODULE$.appendMemoryUnitIfMissing(EngineConnObject$.MODULE$.getEngineCreationContext().getOptions());
        CommonNodeResource resource = new CommonNodeResource();
        LoadResource usedResource = new LoadResource(OverloadUtils$.MODULE$.getProcessMaxMemory(), 1);
        resource.setUsedResource((Resource)usedResource);
        return resource;
    }

    public boolean supportCallBackLogs() {
        return false;
    }

    public String getId() {
        return new StringBuilder(1).append(Sender$.MODULE$.getThisServiceInstance().getInstance()).append("_").append(this.id()).toString();
    }

    public int getConcurrentLimit() {
        return BoxesRunTime.unboxToInt((Object)JDBCConfiguration$.MODULE$.JDBC_CONCURRENT_LIMIT().getValue());
    }

    public void killAll() {
        this.logger().info("Killing all query task.");
        this.connectionManager().initTaskStatementMap();
        this.logger().info("All query task has killed successfully.");
    }

    public void killTask(String taskId) {
        this.logger().info(new StringBuilder(24).append("Killing jdbc query task ").append(taskId).toString());
        this.connectionManager().cancelStatement(taskId);
        super.killTask(taskId);
        this.logger().info(new StringBuilder(40).append("The query task ").append(taskId).append(" has killed successfully.").toString());
    }

    public static final /* synthetic */ void $anonfun$getJDBCRuntimeParams$3(Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof JDBCParamsIllegalException) {
            JDBCParamsIllegalException jDBCParamsIllegalException = (JDBCParamsIllegalException)((Object)throwable);
            throw new JDBCGetDatasourceInfoException(jDBCParamsIllegalException.getErrCode(), jDBCParamsIllegalException.getDesc(), e);
        }
        throw new JDBCGetDatasourceInfoException(JDBCErrorCodeSummary.JDBC_GET_DATASOURCEINFO_ERROR.getErrorCode(), e.getMessage(), e);
    }

    public static final /* synthetic */ String $anonfun$getExecResultSetOutput$4(ResultSet resultSet$2, int i) {
        Object object = resultSet$2.getObject(i + 1);
        String data = object instanceof byte[] ? new String((byte[])resultSet$2.getObject(i + 1)) : (object != null ? resultSet$2.getString(i + 1) : null);
        return data;
    }

    public static final /* synthetic */ void $anonfun$getExecResultSetOutput$5(Object nonLocalReturnKey1$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new ErrorExecuteResponse("query jdbc failed", (Throwable)exception));
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ boolean $anonfun$getExecSqlUser$1(Label x$1) {
        return x$1 instanceof UserCreatorLabel;
    }

    public JDBCEngineConnExecutor(int outputPrintLimit, int id) {
        this.outputPrintLimit = outputPrintLimit;
        this.id = id;
        super(outputPrintLimit);
        this.connectionManager = ConnectionManager.getInstance();
        this.executorLabels = new ArrayList(2);
        this.progressMonitors = new ConcurrentHashMap();
        this.connectionCache = new HashMap<String, Connection>();
    }
}

