/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.jdbc.errorcode;

import org.apache.linkis.common.errorcode.ErrorCodeUtils;
import org.apache.linkis.common.errorcode.LinkisErrorCode;

public enum JDBCErrorCodeSummary implements LinkisErrorCode
{
    JDBC_GET_DATASOURCEINFO_ERROR(26010, "Failed to get datasource info from datasource server(\u4ece\u6570\u636e\u6e90\u670d\u52a1\u5668\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f\u5931\u8d25)"),
    JDBC_PARAMS_ILLEGAL(26011, "JDBC related parameters are illegal(JDBC \u76f8\u5173\u53c2\u6570\u975e\u6cd5)"),
    DRIVER_CLASS_NAME_ERROR(26012, "The driver class name is required(\u9a71\u52a8\u7a0b\u5e8f\u7c7b\u540d\u662f\u5fc5\u9700\u7684)"),
    UNSUPPORT_JDBC_AUTHENTICATION_TYPES(26013, "Unsupported jdbc authentication types:{0}(\u4e0d\u652f\u6301\u7684 jdbc \u8eab\u4efd\u9a8c\u8bc1\u7c7b\u578b:{0})"),
    NO_EXEC_USER_ERROR(26014, "execUser is empty (execUser \u4e3a\u7a7a)"),
    GET_CURRENT_USER_ERROR(26015, "Error in getCurrentUser(\u83b7\u53d6\u5f53\u524d\u7528\u6237\u51fa\u9519)"),
    DOAS_FOR_GET_CONNECTION_ERROR(26016, "Error in doAs to get one connection(\u6267\u884c doAs \u83b7\u53d6\u4e00\u4e2a\u8fde\u63a5\u65f6\u51fa\u9519)"),
    JDBC_USERNAME_NOT_EMPTY(26017, "The jdbc username cannot be empty(jdbc \u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a)"),
    JDBC_PASSWORD_NOT_EMPTY(26018, "The jdbc password cannot be empty(jdbc \u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a)"),
    DATA_SOURCE_INFO_NOT_FOUND(26019, "Data source info of datasource name:[{0}] not found(\u6570\u636e\u6e90\uff1a[{0}] \u4fe1\u606f\u672a\u627e\u5230)"),
    DATA_SOURCE_NOT_PUBLISHED(26020, "Data source of datasource name:[{0}] not yet published(\u6570\u636e\u6e90\uff1a[{0}]\u5c1a\u672a\u53d1\u5e03)"),
    DATA_SOURCE_EXPIRED(26021, "Data source of datasource name:[{0}] is expired(\u6570\u636e\u6e90\uff1a[{0}]\u5df2\u8fc7\u671f)"),
    DATA_SOURCE_JDBC_TYPE_NOT_NULL(26022, "The data source jdbc type cannot be null(\u6570\u636e\u6e90 jdbc \u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a)"),
    JDBC_CONNECTION_INFO_NOT_NULL(26023, "The data source jdbc connection info cannot be null(\u6570\u636e\u6e90 jdbc \u8fde\u63a5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a)"),
    JDBC_DRIVER_CLASS_NAME_NOT_NULL(26024, "The data source jdbc driverClassName cannot be null(\u6570\u636e\u6e90 jdbc driverClassName \u4e0d\u80fd\u4e3a\u7a7a)"),
    JDBC_HOST_NOT_NULL(26025, "The data source jdbc connection host cannot be null(\u6570\u636e\u6e90 jdbc \u8fde\u63a5\u4e3b\u673a\u4e0d\u80fd\u4e3a\u7a7a)"),
    JDBC_PORT_NOT_NULL(26026, "The data source jdbc connection port cannot be null(\u6570\u636e\u6e90jdbc\u8fde\u63a5\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a)"),
    KERBEROS_PRINCIPAL_NOT_NULL(26027, "In the jdbc authentication mode of kerberos, the kerberos principal cannot be empty(kerberos\u7684jdbc\u8ba4\u8bc1\u65b9\u5f0f\u4e0b\uff0ckerberos principal\u4e0d\u80fd\u4e3a\u7a7a)"),
    KERBEROS_KEYTAB_NOT_NULL(26028, "In the jdbc authentication mode of kerberos, the kerberos keytab cannot be empty(kerberos\u7684jdbc\u8ba4\u8bc1\u65b9\u5f0f\u4e0b\uff0ckerberos keytab\u4e0d\u80fd\u4e3a\u7a7a)"),
    UNSUPPORTED_AUTHENTICATION_TYPE(26029, "Unsupported authentication type:{0}(\u4e0d\u652f\u6301\u7684\u8eab\u4efd\u9a8c\u8bc1\u7c7b\u578b)"),
    UNSUPPORTED_DS_TYPE(26030, "Unsupported datasource type:{0}(\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b)");

    private final int errorCode;
    private final String errorDesc;

    private JDBCErrorCodeSummary(int errorCode, String errorDesc) {
        ErrorCodeUtils.validateErrorCode((int)errorCode, (int)26000, (int)29999);
        this.errorCode = errorCode;
        this.errorDesc = errorDesc;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDesc() {
        return this.errorDesc;
    }
}

