/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.elasticsearch.executor.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.util.Locale;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.ElasticSearchResponse;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.impl.ResponseHandlerImpl;
import org.apache.linkis.storage.domain.ArrayType$;
import org.apache.linkis.storage.domain.BinaryType$;
import org.apache.linkis.storage.domain.BooleanType$;
import org.apache.linkis.storage.domain.DataType;
import org.apache.linkis.storage.domain.DateType$;
import org.apache.linkis.storage.domain.DecimalType$;
import org.apache.linkis.storage.domain.NullType$;
import org.apache.linkis.storage.domain.StringType$;
import org.apache.linkis.storage.domain.StructType$;
import org.elasticsearch.client.Response;
import scala.runtime.BoxesRunTime;

public final class ResponseHandler$ {
    public static ResponseHandler$ MODULE$;
    private final ResponseHandlerImpl RESPONSE_HANDLER;
    private final ObjectMapper jsonMapper;
    private final YAMLMapper yamlMapper;
    private final ObjectMapper cborMapper;
    private final ObjectMapper smileMapper;
    private final CsvMapper csvMapper;

    static {
        new ResponseHandler$();
    }

    public ResponseHandlerImpl RESPONSE_HANDLER() {
        return this.RESPONSE_HANDLER;
    }

    public ElasticSearchResponse handle(Response response) {
        return this.RESPONSE_HANDLER().handle(response);
    }

    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    public YAMLMapper yamlMapper() {
        return this.yamlMapper;
    }

    public ObjectMapper cborMapper() {
        return this.cborMapper;
    }

    public ObjectMapper smileMapper() {
        return this.smileMapper;
    }

    public CsvMapper csvMapper() {
        return this.csvMapper;
    }

    public DataType getNodeDataType(JsonNode node) {
        JsonNodeType jsonNodeType = node.getNodeType();
        if (JsonNodeType.ARRAY.equals(jsonNodeType)) {
            return ArrayType$.MODULE$;
        }
        if (JsonNodeType.BINARY.equals(jsonNodeType)) {
            return BinaryType$.MODULE$;
        }
        if (JsonNodeType.BOOLEAN.equals(jsonNodeType)) {
            return BooleanType$.MODULE$;
        }
        if (JsonNodeType.NULL.equals(jsonNodeType)) {
            return NullType$.MODULE$;
        }
        if (JsonNodeType.NUMBER.equals(jsonNodeType)) {
            return DecimalType$.MODULE$;
        }
        if (JsonNodeType.OBJECT.equals(jsonNodeType)) {
            return StructType$.MODULE$;
        }
        if (JsonNodeType.POJO.equals(jsonNodeType)) {
            return StructType$.MODULE$;
        }
        if (JsonNodeType.STRING.equals(jsonNodeType)) {
            return StringType$.MODULE$;
        }
        if (JsonNodeType.MISSING.equals(jsonNodeType)) {
            return StringType$.MODULE$;
        }
        return StringType$.MODULE$;
    }

    public DataType getNodeTypeByEsType(String estype) {
        String string = estype.toLowerCase(Locale.getDefault());
        if ("long".equals(string) ? true : ("integer".equals(string) ? true : ("short".equals(string) ? true : ("byte".equals(string) ? true : ("double".equals(string) ? true : ("float".equals(string) ? true : ("half_float".equals(string) ? true : "scaled_float".equals(string)))))))) {
            return DecimalType$.MODULE$;
        }
        if ("text".equals(string) ? true : "keyword".equals(string)) {
            return StringType$.MODULE$;
        }
        if ("date".equals(string)) {
            return DateType$.MODULE$;
        }
        if ("binary".equals(string)) {
            return BinaryType$.MODULE$;
        }
        return StringType$.MODULE$;
    }

    public Object getNodeValue(JsonNode node) {
        JsonNodeType jsonNodeType = node.getNodeType();
        if (JsonNodeType.NUMBER.equals(jsonNodeType)) {
            return BoxesRunTime.boxToDouble((double)node.asDouble());
        }
        if (JsonNodeType.NULL.equals(jsonNodeType)) {
            return null;
        }
        return node.toString().replaceAll("\n|\t", " ");
    }

    private ResponseHandler$() {
        MODULE$ = this;
        this.RESPONSE_HANDLER = new ResponseHandlerImpl();
        this.jsonMapper = new ObjectMapper();
        this.yamlMapper = new YAMLMapper();
        this.cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
        this.smileMapper = new ObjectMapper((JsonFactory)new SmileFactory());
        this.csvMapper = new CsvMapper();
    }
}

