/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.elasticsearch.executor.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.engineplugin.elasticsearch.conf.ElasticSearchConfiguration;
import org.apache.linkis.engineplugin.elasticsearch.errorcode.EasticsearchErrorCodeSummary;
import org.apache.linkis.engineplugin.elasticsearch.exception.EsParamsIllegalException;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.EsClient;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.EsClientImpl;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.Sniffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(EsClientFactory.class);
    private static int MAX_CACHE_CLIENT_SIZE = 20;
    private static Map<String, EsClient> ES_CLIENT_MAP = new LinkedHashMap<String, EsClient>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, EsClient> eldest) {
            if (this.size() > MAX_CACHE_CLIENT_SIZE) {
                eldest.getValue().close();
                return true;
            }
            return false;
        }
    };
    private static CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
    private static EsClient defaultClient;
    private static Header[] defaultHeaders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsClient getRestClient(Map<String, String> options) {
        String key = EsClientFactory.getDatasourceName(options);
        if (StringUtils.isBlank((CharSequence)key)) {
            return defaultClient;
        }
        if (!ES_CLIENT_MAP.containsKey(key)) {
            Map<String, EsClient> map = ES_CLIENT_MAP;
            synchronized (map) {
                if (!ES_CLIENT_MAP.containsKey(key)) {
                    try {
                        EsClientFactory.cacheClient(EsClientFactory.createRestClient(options));
                    }
                    catch (ErrorException e) {
                        logger.error("es createRestClient failed, reason:", (Throwable)e);
                    }
                }
            }
        }
        return ES_CLIENT_MAP.get(key);
    }

    private static String getDatasourceName(Map<String, String> options) {
        return options.getOrDefault(ElasticSearchConfiguration.ES_DATASOURCE_NAME.key(), "");
    }

    private static void cacheClient(EsClient client) {
        ES_CLIENT_MAP.put(client.getDatasourceName(), client);
    }

    private static EsClient createRestClient(Map<String, String> options) throws ErrorException {
        String clusterStr = options.get(ElasticSearchConfiguration.ES_CLUSTER.key());
        if (StringUtils.isBlank((CharSequence)clusterStr)) {
            throw new EsParamsIllegalException(EasticsearchErrorCodeSummary.CLUSTER_IS_BLANK.getErrorDesc());
        }
        HttpHost[] cluster = EsClientFactory.getCluster(clusterStr);
        if (cluster.length == 0) {
            throw new EsParamsIllegalException(EasticsearchErrorCodeSummary.CLUSTER_IS_BLANK.getErrorDesc());
        }
        String username = options.get(ElasticSearchConfiguration.ES_USERNAME.key());
        String password = options.get(ElasticSearchConfiguration.ES_PASSWORD.key());
        if (((Boolean)ElasticSearchConfiguration.ES_AUTH_CACHE.getValue()).booleanValue()) {
            EsClientFactory.setAuthScope(cluster, username, password);
        }
        HttpHost[] httpHosts = (HttpHost[])Arrays.stream(cluster).map(item -> new HttpHost(item.getHostName(), item.getPort())).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                if (!((Boolean)ElasticSearchConfiguration.ES_AUTH_CACHE.getValue()).booleanValue()) {
                    httpAsyncClientBuilder.disableAuthCaching();
                }
                return httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
        });
        if (defaultHeaders != null) {
            builder.setDefaultHeaders(defaultHeaders);
        }
        RestClient restClient = builder.build();
        Sniffer sniffer = (Boolean)ElasticSearchConfiguration.ES_SNIFFER_ENABLE.getValue(options) != false ? Sniffer.builder((RestClient)restClient).build() : null;
        return new EsClientImpl(EsClientFactory.getDatasourceName(options), restClient, sniffer);
    }

    private static HttpHost[] getCluster(String clusterStr) {
        if (StringUtils.isNotBlank((CharSequence)clusterStr)) {
            return (HttpHost[])Arrays.stream(clusterStr.split(",")).map(value -> {
                String[] arr = value.replace("http://", "").split(":");
                return new HttpHost(arr[0].trim(), Integer.parseInt(arr[1].trim()));
            }).toArray(HttpHost[]::new);
        }
        return new HttpHost[0];
    }

    private static void setAuthScope(HttpHost[] cluster, String username, String password) {
        if (cluster != null && cluster.length > 0 && StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            Arrays.stream(cluster).forEach(host -> credentialsProvider.setCredentials(new AuthScope(host.getHostName(), host.getPort(), AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(username, password)));
        }
    }

    static {
        String cluster = (String)ElasticSearchConfiguration.ES_CLUSTER.getValue();
        if (StringUtils.isBlank((CharSequence)cluster)) {
            defaultClient = null;
        } else {
            HashMap<String, String> defaultOpts = new HashMap<String, String>();
            defaultOpts.put(ElasticSearchConfiguration.ES_CLUSTER.key(), cluster);
            defaultOpts.put(ElasticSearchConfiguration.ES_DATASOURCE_NAME.key(), (String)ElasticSearchConfiguration.ES_DATASOURCE_NAME.getValue());
            defaultOpts.put(ElasticSearchConfiguration.ES_USERNAME.key(), (String)ElasticSearchConfiguration.ES_USERNAME.getValue());
            defaultOpts.put(ElasticSearchConfiguration.ES_PASSWORD.key(), (String)ElasticSearchConfiguration.ES_PASSWORD.getValue());
            EsClient client = null;
            try {
                client = EsClientFactory.createRestClient(defaultOpts);
            }
            catch (ErrorException e) {
                logger.error("es createRestClient failed, reason:", (Throwable)e);
            }
            EsClientFactory.cacheClient(client);
            defaultClient = client;
        }
        defaultHeaders = (Header[])CommonVars.properties().entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null && entry.getKey().toString().startsWith("linkis.es.headers.")).map(entry -> new BasicHeader(entry.getKey().toString(), entry.getValue().toString())).toArray(Header[]::new);
    }
}

