/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.doris.executor;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.linkis.common.utils.JsonUtils;
import org.apache.linkis.datasource.client.impl.LinkisDataSourceRemoteClient;
import org.apache.linkis.datasource.client.request.GetInfoPublishedByDataSourceNameAction;
import org.apache.linkis.datasourcemanager.common.domain.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisDatasourceParser {
    private static final Logger logger = LoggerFactory.getLogger(DorisDatasourceParser.class);

    public static Map<String, String> queryDatasourceInfoByName(String datasourceName, String username, String system) {
        logger.info("Starting query [" + system + ", " + username + ", " + datasourceName + "] datasource info ......");
        LinkisDataSourceRemoteClient dataSourceClient = new LinkisDataSourceRemoteClient();
        DataSource dataSource = dataSourceClient.getInfoPublishedByDataSourceName(GetInfoPublishedByDataSourceNameAction.builder().setSystem(system).setDataSourceName(datasourceName).setUser(username).build()).getDataSource();
        return DorisDatasourceParser.queryDatasourceParam(datasourceName, dataSource);
    }

    private static Map<String, String> queryDatasourceParam(String datasourceName, DataSource dataSource) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (dataSource == null) {
            logger.warn("Doris dataSource is null: {}", (Object)datasourceName);
            return paramMap;
        }
        if (dataSource.isExpire()) {
            logger.warn("Doris dataSource of datasource name: {} is expired", (Object)datasourceName);
            return paramMap;
        }
        Map connectParams = dataSource.getConnectParams();
        if (MapUtils.isEmpty((Map)connectParams)) {
            logger.warn("Doris dataSource connectParams is empty: {}", (Object)datasourceName);
            return paramMap;
        }
        paramMap.put("host", String.valueOf(connectParams.getOrDefault("host", "")));
        paramMap.put("port", String.valueOf(connectParams.getOrDefault("port", "")));
        paramMap.put("username", String.valueOf(connectParams.getOrDefault("username", "")));
        paramMap.put("password", String.valueOf(connectParams.getOrDefault("password", "")));
        paramMap.put("databaseName", String.valueOf(connectParams.getOrDefault("databaseName", connectParams.getOrDefault("instance", ""))));
        try {
            HashMap<String, String> printMap = new HashMap<String, String>();
            printMap.putAll(paramMap);
            if (printMap.containsKey("password")) {
                printMap.put("password", "******");
            }
            String printMapString = JsonUtils.jackson().writeValueAsString(printMap);
            logger.info("Load dataSource param: {}", (Object)printMapString);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return paramMap;
    }
}

