/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.executor;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQueryBase;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.table.planner.plan.metadata.FlinkDefaultRelMetadataProvider$;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.deployment.AbstractSessionClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.client.deployment.ClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.client.deployment.ClusterDescriptorAdapterFactory;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.ExecutorInitException;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlParseException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.AbstractJobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.JobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.Operation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.OperationFactory;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl.InsertOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultKind;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;
import org.apache.linkis.engineconnplugin.flink.client.sql.parser.SqlCommandCall;
import org.apache.linkis.engineconnplugin.flink.client.sql.parser.SqlCommandParser;
import org.apache.linkis.engineconnplugin.flink.config.FlinkExecutionTargetType$;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;
import org.apache.linkis.engineconnplugin.flink.executor.DevFlinkSQLStreamingListener;
import org.apache.linkis.engineconnplugin.flink.executor.FlinkExecutor;
import org.apache.linkis.engineconnplugin.flink.executor.FlinkExecutor$;
import org.apache.linkis.engineconnplugin.flink.executor.FlinkSQLStatusListener;
import org.apache.linkis.engineconnplugin.flink.executor.FlinkSQLStreamingResultSetListener;
import org.apache.linkis.engineconnplugin.flink.listener.FlinkListener;
import org.apache.linkis.engineconnplugin.flink.listener.FlinkStatusListener;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.SQLCodeParser;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001\u0002\u000b\u0016\u0001\tB\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\ts\u0001\u0011)\u0019!C)u!A\u0011\t\u0001B\u0001B\u0003%1\bC\u0003C\u0001\u0011\u00051\tC\u0005H\u0001\u0001\u0007\t\u0019!C\u0005\u0011\"I!\u000b\u0001a\u0001\u0002\u0004%Ia\u0015\u0005\n3\u0002\u0001\r\u0011!Q!\n%C\u0011B\u0017\u0001A\u0002\u0003\u0007I\u0011A.\t\u0013\t\u0004\u0001\u0019!a\u0001\n\u0003\u0019\u0007\"C3\u0001\u0001\u0004\u0005\t\u0015)\u0003]\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002&\u0001!\t%a\n\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003BBA'\u0001\u0011\u0005s\rC\u0004\u0002P\u0001!\t%!\u0015\u00037\u0019c\u0017N\\6T#2\u001bu.\u001c9vi\u0006$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s\u0015\t1r#\u0001\u0005fq\u0016\u001cW\u000f^8s\u0015\tA\u0012$A\u0003gY&t7N\u0003\u0002\u001b7\u0005\u0001RM\\4j]\u0016\u001cwN\u001c8qYV<\u0017N\u001c\u0006\u00039u\ta\u0001\\5oW&\u001c(B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001G9\u0002\"\u0001\n\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\u000f\u0015DXmY;uK*\u0011a\u0003\u000b\u0006\u0003S)\n1bY8naV$\u0018\r^5p]*\u00111fG\u0001\u000bK:<\u0017N\\3d_:t\u0017BA\u0017&\u0005M\u0019u.\u001c9vi\u0006$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s!\ty\u0003'D\u0001\u0016\u0013\t\tTCA\u0007GY&t7.\u0012=fGV$xN]\u0001\u0003S\u0012\u0004\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012A\u0001T8oO\u00061b\r\\5oW\u0016sw-\u001b8f\u0007>tgnQ8oi\u0016DH/F\u0001<!\tat(D\u0001>\u0015\tqt#A\u0004d_:$X\r\u001f;\n\u0005\u0001k$A\u0006$mS:\\WI\\4j]\u0016\u001cuN\u001c8D_:$X\r\u001f;\u0002/\u0019d\u0017N\\6F]\u001eLg.Z\"p]:\u001cuN\u001c;fqR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002E\u000b\u001a\u0003\"a\f\u0001\t\u000bI\"\u0001\u0019A\u001a\t\u000be\"\u0001\u0019A\u001e\u0002\u0013=\u0004XM]1uS>tW#A%\u0011\u0005)\u0003V\"A&\u000b\u0005\u001dc%BA'O\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001f^\taa\u00197jK:$\u0018BA)L\u00051QuNY(qKJ\fG/[8o\u00035y\u0007/\u001a:bi&|gn\u0018\u0013fcR\u0011Ak\u0016\t\u0003iUK!AV\u001b\u0003\tUs\u0017\u000e\u001e\u0005\b1\u001a\t\t\u00111\u0001J\u0003\rAH%M\u0001\u000b_B,'/\u0019;j_:\u0004\u0013!E2mkN$XM\u001d#fg\u000e\u0014\u0018\u000e\u001d;peV\tA\f\u0005\u0002^A6\taL\u0003\u0002`\u001d\u0006QA-\u001a9m_flWM\u001c;\n\u0005\u0005t&aJ!cgR\u0014\u0018m\u0019;TKN\u001c\u0018n\u001c8DYV\u001cH/\u001a:EKN\u001c'/\u001b9u_J\fE-\u00199uKJ\fQc\u00197vgR,'\u000fR3tGJL\u0007\u000f^8s?\u0012*\u0017\u000f\u0006\u0002UI\"9\u0001,CA\u0001\u0002\u0004a\u0016AE2mkN$XM\u001d#fg\u000e\u0014\u0018\u000e\u001d;pe\u0002\nA!\u001b8jiR\tA+A\u0006fq\u0016\u001cW\u000f^3MS:,Gc\u00016soB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\tKb,7-\u001e;fe*\u0011qnG\u0001\ng\u000eDW\rZ;mKJL!!\u001d7\u0003\u001f\u0015CXmY;uKJ+7\u000f]8og\u0016DQa\u001d\u0007A\u0002Q\fa#\u001a8hS:,W\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0003IUL!A^\u0013\u0003-\u0015sw-\u001b8f\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDQ\u0001\u001f\u0007A\u0002e\fAaY8eKB\u0019!0a\u0001\u000f\u0005m|\bC\u0001?6\u001b\u0005i(B\u0001@\"\u0003\u0019a$o\\8u}%\u0019\u0011\u0011A\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\t)!a\u0002\u0003\rM#(/\u001b8h\u0015\r\t\t!N\u0001\u0012Kb,7-\u001e;f\u0007>l\u0007\u000f\\3uK2LHc\u00026\u0002\u000e\u0005E\u00111\u0003\u0005\u0007\u0003\u001fi\u0001\u0019\u0001;\u0002+\u0015tw-\u001b8f\u000bb,7-\u001e;pe\u000e{g\u000e^3yi\")\u00010\u0004a\u0001s\"1\u0011QC\u0007A\u0002e\fQbY8na2,G/\u001a3MS:,\u0017\u0001\u00039s_\u001e\u0014Xm]:\u0015\t\u0005m\u0011\u0011\u0005\t\u0004i\u0005u\u0011bAA\u0010k\t)a\t\\8bi\"1\u00111\u0005\bA\u0002e\fa\u0001^1tW&#\u0015aD4fiB\u0013xn\u001a:fgNLeNZ8\u0015\t\u0005%\u0012q\b\t\u0006i\u0005-\u0012qF\u0005\u0004\u0003[)$!B!se\u0006L\b\u0003BA\u0019\u0003wi!!a\r\u000b\t\u0005U\u0012qG\u0001\u0007K:<\u0017N\\3\u000b\u0007\u0005e2$\u0001\u0005qe>$xnY8m\u0013\u0011\ti$a\r\u0003\u001f){'\r\u0015:pOJ,7o]%oM>Da!a\t\u0010\u0001\u0004I\u0018\u0001C6jY2$\u0016m]6\u0015\u0007Q\u000b)\u0005\u0003\u0004\u0002HA\u0001\r!_\u0001\u0007i\u0006\u001c8.\u00133\u0002\u000b\u001d,G/\u00133\u0016\u0003e\fQa\u00197pg\u0016\f1\u0002\u001e:z'\",H\u000fZ8x]R\u0011\u00111\u000b\t\u0004i\u0005U\u0013bAA,k\t9!i\\8mK\u0006t\u0007")
public class FlinkSQLComputationExecutor
extends ComputationExecutor
implements FlinkExecutor {
    private final long id;
    private final FlinkEngineConnContext flinkEngineConnContext;
    private JobOperation operation;
    private AbstractSessionClusterDescriptorAdapter clusterDescriptor;
    private String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$jobID;
    private String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$applicationId;
    private String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$kubernetesClusterID;
    private String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$applicationURL;
    private String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$yarnMode;
    private String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$queue;
    private String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$namespace;
    private List<Label<?>> org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$executorLabels;

    @Override
    public String getJobID() {
        return FlinkExecutor.getJobID$(this);
    }

    @Override
    public void setJobID(String jobID) {
        FlinkExecutor.setJobID$(this, jobID);
    }

    @Override
    public String getApplicationId() {
        return FlinkExecutor.getApplicationId$(this);
    }

    @Override
    public void setApplicationId(String applicationId) {
        FlinkExecutor.setApplicationId$(this, applicationId);
    }

    @Override
    public String getKubernetesClusterID() {
        return FlinkExecutor.getKubernetesClusterID$(this);
    }

    @Override
    public void setKubernetesClusterID(String kubernetesClusterID) {
        FlinkExecutor.setKubernetesClusterID$(this, kubernetesClusterID);
    }

    @Override
    public String getApplicationURL() {
        return FlinkExecutor.getApplicationURL$(this);
    }

    @Override
    public void setApplicationURL(String applicationURL) {
        FlinkExecutor.setApplicationURL$(this, applicationURL);
    }

    @Override
    public String getYarnMode() {
        return FlinkExecutor.getYarnMode$(this);
    }

    @Override
    public void setYarnMode(String yarnMode) {
        FlinkExecutor.setYarnMode$(this, yarnMode);
    }

    @Override
    public String getQueue() {
        return FlinkExecutor.getQueue$(this);
    }

    @Override
    public void setQueue(String queue) {
        FlinkExecutor.setQueue$(this, queue);
    }

    @Override
    public String getNamespace() {
        return FlinkExecutor.getNamespace$(this);
    }

    @Override
    public void setNamespace(String namespace) {
        FlinkExecutor.setNamespace$(this, namespace);
    }

    @Override
    public List<Label<?>> getExecutorLabels() {
        return FlinkExecutor.getExecutorLabels$(this);
    }

    @Override
    public void setExecutorLabels(List<Label<?>> labels) {
        FlinkExecutor.setExecutorLabels$(this, labels);
    }

    @Override
    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return FlinkExecutor.requestExpectedResource$(this, expectedResource);
    }

    @Override
    public NodeResource getCurrentNodeResource() {
        return FlinkExecutor.getCurrentNodeResource$(this);
    }

    @Override
    public boolean supportCallBackLogs() {
        return FlinkExecutor.supportCallBackLogs$(this);
    }

    @Override
    public String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$jobID() {
        return this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$jobID;
    }

    @Override
    public void org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$jobID_$eq(String x$1) {
        this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$jobID = x$1;
    }

    @Override
    public String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$applicationId() {
        return this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$applicationId;
    }

    @Override
    public void org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$applicationId_$eq(String x$1) {
        this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$applicationId = x$1;
    }

    @Override
    public String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$kubernetesClusterID() {
        return this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$kubernetesClusterID;
    }

    @Override
    public void org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$kubernetesClusterID_$eq(String x$1) {
        this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$kubernetesClusterID = x$1;
    }

    @Override
    public String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$applicationURL() {
        return this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$applicationURL;
    }

    @Override
    public void org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$applicationURL_$eq(String x$1) {
        this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$applicationURL = x$1;
    }

    @Override
    public String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$yarnMode() {
        return this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$yarnMode;
    }

    @Override
    public void org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$yarnMode_$eq(String x$1) {
        this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$yarnMode = x$1;
    }

    @Override
    public String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$queue() {
        return this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$queue;
    }

    @Override
    public void org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$queue_$eq(String x$1) {
        this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$queue = x$1;
    }

    @Override
    public String org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$namespace() {
        return this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$namespace;
    }

    @Override
    public void org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$namespace_$eq(String x$1) {
        this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$namespace = x$1;
    }

    @Override
    public List<Label<?>> org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$executorLabels() {
        return this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$executorLabels;
    }

    @Override
    public void org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$executorLabels_$eq(List<Label<?>> x$1) {
        this.org$apache$linkis$engineconnplugin$flink$executor$FlinkExecutor$$executorLabels = x$1;
    }

    @Override
    public FlinkEngineConnContext flinkEngineConnContext() {
        return this.flinkEngineConnContext;
    }

    private JobOperation operation() {
        return this.operation;
    }

    private void operation_$eq(JobOperation x$1) {
        this.operation = x$1;
    }

    public AbstractSessionClusterDescriptorAdapter clusterDescriptor() {
        return this.clusterDescriptor;
    }

    public void clusterDescriptor_$eq(AbstractSessionClusterDescriptorAdapter x$1) {
        this.clusterDescriptor = x$1;
    }

    public void init() {
        this.setCodeParser((CodeParser)new SQLCodeParser());
        ClusterDescriptorAdapter clusterDescriptorAdapter = ClusterDescriptorAdapterFactory.create(this.flinkEngineConnContext().getExecutionContext());
        if (!(clusterDescriptorAdapter instanceof AbstractSessionClusterDescriptorAdapter)) {
            if (clusterDescriptorAdapter != null) {
                throw new ExecutorInitException(MessageFormat.format(FlinkErrorCodeSummary.NOT_SUPPORT_SIMPLENAME.getErrorDesc(), clusterDescriptorAdapter.getClass().getSimpleName()));
            }
            throw new ExecutorInitException(FlinkErrorCodeSummary.ADAPTER_IS_NULL.getErrorDesc());
        }
        AbstractSessionClusterDescriptorAdapter abstractSessionClusterDescriptorAdapter = (AbstractSessionClusterDescriptorAdapter)clusterDescriptorAdapter;
        this.clusterDescriptor_$eq(abstractSessionClusterDescriptorAdapter);
        this.logger().info("Try to start a yarn-session application for interactive query.");
        this.clusterDescriptor().deployCluster();
        String flinkDeploymentTarget = (String)this.flinkEngineConnContext().getExecutionContext().getFlinkConfig().get(DeploymentOptions.TARGET);
        if (FlinkExecutionTargetType$.MODULE$.isYarnExecutionTargetType(flinkDeploymentTarget)) {
            String applicationId = ConverterUtils.toString((ApplicationId)this.clusterDescriptor().getClusterID());
            this.setApplicationId(applicationId);
            this.setApplicationURL(this.clusterDescriptor().getWebInterfaceUrl());
            this.flinkEngineConnContext().getEnvironmentContext().getFlinkConfig().setString(YarnConfigOptions.APPLICATION_ID, applicationId);
            this.logger().info(new StringBuilder(58).append("Application is started, applicationId: ").append(this.getApplicationId()).append(", applicationURL: ").append(this.getApplicationURL()).append(".").toString());
        } else if (FlinkExecutionTargetType$.MODULE$.isKubernetesExecutionTargetType(flinkDeploymentTarget)) {
            String kubernetesClusterID = this.clusterDescriptor().getKubernetesClusterID();
            this.setKubernetesClusterID(kubernetesClusterID);
            this.setApplicationURL(this.clusterDescriptor().getWebInterfaceUrl());
            this.flinkEngineConnContext().getEnvironmentContext().getFlinkConfig().setString(KubernetesConfigOptions.CLUSTER_ID, kubernetesClusterID);
            this.logger().info(new StringBuilder(58).append("Application is started, applicationId: ").append(this.getKubernetesClusterID()).append(", applicationURL: ").append(this.getApplicationURL()).append(".").toString());
        }
        super.init();
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutionContext, String code) {
        ExecuteResponse executeResponse;
        Object object = new Object();
        try {
            Operation operation;
            Optional<SqlCommandCall> callOpt = SqlCommandParser.getSqlCommandParser().parse(code.trim(), true);
            if (!callOpt.isPresent()) {
                throw new SqlParseException(MessageFormat.format(FlinkErrorCodeSummary.UNKNOWN_STATEMENT.getErrorDesc(), code));
            }
            SqlCommandCall callSQL = callOpt.get();
            RelMetadataQueryBase.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)FlinkDefaultRelMetadataProvider$.MODULE$.INSTANCE()));
            Operation operation2 = operation = OperationFactory.getOperationFactory().createOperation(callSQL, this.flinkEngineConnContext());
            if (operation2 instanceof JobOperation) {
                JobOperation jobOperation = (JobOperation)operation2;
                jobOperation.setClusterDescriptorAdapter(this.clusterDescriptor());
                this.operation_$eq(jobOperation);
                jobOperation.addFlinkListener(new FlinkSQLStatusListener(jobOperation, engineExecutionContext));
                jobOperation.addFlinkListener(new FlinkSQLStreamingResultSetListener(jobOperation, engineExecutionContext));
                Map properties = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(engineExecutionContext.getProperties()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        if (v instanceof String) {
                            String string = (String)v;
                            return new Tuple2((Object)k, (Object)string);
                        }
                    }
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        if (v != null) {
                            return new Tuple2((Object)k, (Object)v.toString());
                        }
                    }
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        return new Tuple2((Object)k, null);
                    }
                    throw new MatchError((Object)tuple2);
                }, Map$.MODULE$.canBuildFrom())).asJava();
                jobOperation.addFlinkListener(new DevFlinkSQLStreamingListener(jobOperation, properties));
            }
            ResultSet resultSet = operation.execute();
            ResultKind resultKind = resultSet.getResultKind();
            if (((Object)((Object)ResultKind.SUCCESS)).equals((Object)resultKind)) {
                executeResponse = new SuccessExecuteResponse();
            } else if (((Object)((Object)ResultKind.SUCCESS_WITH_CONTENT)).equals((Object)resultKind) && !(operation instanceof JobOperation)) {
                FlinkExecutor$.MODULE$.writeAndSendResultSet(resultSet, engineExecutionContext);
                executeResponse = new SuccessExecuteResponse();
            } else {
                Operation operation3 = operation;
                if (operation3 instanceof InsertOperation) {
                    InsertOperation insertOperation = (InsertOperation)operation3;
                    JobID jobId = insertOperation.transformToJobInfo(resultSet);
                    this.setJobID(jobId.toHexString());
                    this.setYarnMode("client");
                    FlinkStatusListener flinkStatusListener = insertOperation.getFlinkStatusListeners().get(0);
                    if (flinkStatusListener instanceof FlinkSQLStatusListener) {
                        FlinkSQLStatusListener flinkSQLStatusListener = (FlinkSQLStatusListener)flinkStatusListener;
                        return flinkSQLStatusListener.getResponse();
                    }
                } else if (operation3 instanceof AbstractJobOperation) {
                    AbstractJobOperation abstractJobOperation = (AbstractJobOperation)operation3;
                    JobID jobId = abstractJobOperation.transformToJobInfo(resultSet);
                    this.setJobID(jobId.toHexString());
                    this.setYarnMode("client");
                    FlinkStatusListener flinkStatusListener = abstractJobOperation.getFlinkStatusListeners().get(0);
                    if (flinkStatusListener instanceof FlinkSQLStatusListener) {
                        FlinkSQLStatusListener flinkSQLStatusListener = (FlinkSQLStatusListener)flinkStatusListener;
                        flinkSQLStatusListener.waitForCompleted();
                        return flinkSQLStatusListener.getResponse();
                    }
                } else if (operation3 instanceof JobOperation) {
                    JobOperation jobOperation = (JobOperation)operation3;
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(jobOperation.getFlinkListeners()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkSQLComputationExecutor.$anonfun$executeLine$2(x$1))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        FlinkListener flinkListener = x0$2;
                        if (flinkListener instanceof FlinkSQLStatusListener) {
                            FlinkSQLStatusListener flinkSQLStatusListener = (FlinkSQLStatusListener)flinkListener;
                            flinkSQLStatusListener.waitForCompleted();
                            throw new NonLocalReturnControl(object, (Object)flinkSQLStatusListener.getResponse());
                        }
                        throw new MatchError((Object)flinkListener);
                    });
                } else {
                    throw new MatchError((Object)operation3);
                }
                executeResponse = new SuccessExecuteResponse();
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                executeResponse = (ExecuteResponse)ex.value();
            }
            throw ex;
        }
        return executeResponse;
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutorContext, String code, String completedLine) {
        String newCode = new StringBuilder(0).append(completedLine).append(code).toString();
        this.logger().info(new StringBuilder(11).append("newCode is ").append(newCode).toString());
        return this.executeLine(engineExecutorContext, newCode);
    }

    public float progress(String taskID) {
        if (this.operation() == null) {
            return 0.0f;
        }
        JobStatus jobStatus = this.operation().getJobStatus();
        if (jobStatus.isGloballyTerminalState()) {
            return 1.0f;
        }
        if (JobStatus.RUNNING.equals(jobStatus)) {
            return 0.5f;
        }
        return 0.0f;
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        return (JobProgressInfo[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(JobProgressInfo.class));
    }

    public void killTask(String taskId) {
        this.logger().info(new StringBuilder(41).append("Start to kill task ").append(taskId).append(", the flink jobId is ").append(this.clusterDescriptor().getJobId()).append(".").toString());
        if (this.operation() != null) {
            this.operation().cancelJob();
        }
        super.killTask(taskId);
    }

    public String getId() {
        return new StringBuilder(20).append("FlinkComputationSQL_").append(this.id).toString();
    }

    public void close() {
        Object object = this.operation() != null ? Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.operation().cancelJob()) : BoxedUnit.UNIT;
        this.flinkEngineConnContext().getExecutionContext().createClusterDescriptor().close();
        this.flinkEngineConnContext().getExecutionContext().getClusterClientFactory().close();
        super.close();
    }

    public boolean tryShutdown() {
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.close(), this.logger());
        return super.tryShutdown();
    }

    public static final /* synthetic */ boolean $anonfun$executeLine$2(FlinkListener x$1) {
        return x$1 instanceof FlinkSQLStatusListener;
    }

    public FlinkSQLComputationExecutor(long id, FlinkEngineConnContext flinkEngineConnContext) {
        this.id = id;
        this.flinkEngineConnContext = flinkEngineConnContext;
        super(ComputationExecutor$.MODULE$.$lessinit$greater$default$1());
        FlinkExecutor.$init$(this);
    }
}

