/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl;

import java.text.MessageFormat;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlExecutionException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.NonJobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.OperationUtil;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;

public class UseCatalogOperation
implements NonJobOperation {
    private final ExecutionContext context;
    private final String catalogName;

    public UseCatalogOperation(FlinkEngineConnContext context, String catalogName) {
        this.context = context.getExecutionContext();
        this.catalogName = catalogName;
    }

    @Override
    public ResultSet execute() throws SqlExecutionException {
        TableEnvironment tableEnv = this.context.getTableEnvironment();
        try {
            this.context.wrapClassLoader(() -> {
                tableEnv.useCatalog(this.catalogName);
                return null;
            });
        }
        catch (CatalogException e) {
            throw new SqlExecutionException(MessageFormat.format(FlinkErrorCodeSummary.FAILED_SWITCH_CATALOG.getErrorDesc(), this.catalogName), (Throwable)e);
        }
        return OperationUtil.OK;
    }
}

