/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ColumnInfo;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultKind;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;

public class OperationUtil {
    public static final ResultSet OK = ResultSet.builder().resultKind(ResultKind.SUCCESS).columns(ColumnInfo.create("result", (LogicalType)new VarCharType(2))).data(Row.of((Object[])new Object[]{"OK"})).build();

    public static ResultSet singleStringToResultSet(String str, String columnName) {
        int length;
        boolean isNullable;
        if (str == null) {
            isNullable = true;
            length = 1;
        } else {
            isNullable = false;
            length = str.length();
        }
        return ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(ColumnInfo.create(columnName, (LogicalType)new VarCharType(isNullable, length))).data(Row.of((Object[])new Object[]{str})).build();
    }

    public static ResultSet stringListToResultSet(List<String> strings, String columnName) {
        ArrayList<Row> data = new ArrayList<Row>();
        boolean isNullable = false;
        int maxLength = 1;
        for (String str : strings) {
            if (str == null) {
                isNullable = true;
                continue;
            }
            maxLength = Math.max(str.length(), maxLength);
            data.add(Row.of((Object[])new Object[]{str}));
        }
        return ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(ColumnInfo.create(columnName, (LogicalType)new VarCharType(isNullable, maxLength))).data(data).build();
    }
}

