/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.factory;

import java.io.Closeable;
import java.io.IOException;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptionsInternal;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.YarnClientYarnClusterInformationRetriever;
import org.apache.flink.yarn.YarnClusterClientFactory;
import org.apache.flink.yarn.YarnClusterDescriptor;
import org.apache.flink.yarn.YarnClusterInformationRetriever;
import org.apache.flink.yarn.configuration.YarnLogConfigUtil;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.linkis.engineconnplugin.flink.client.utils.YarnConfLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisYarnClusterClientFactory
extends YarnClusterClientFactory
implements Closeable {
    public static final ConfigOption<String> YARN_CONFIG_DIR = ConfigOptions.key((String)"$internal.yarn.config-dir").stringType().noDefaultValue().withDescription("**DO NOT USE** The location of the log config file, e.g. the path to your log4j.properties for log4j.");
    private YarnConfiguration yarnConfiguration;
    private YarnClient yarnClient;
    private Configuration configuration;
    private static final Logger LOG = LoggerFactory.getLogger(LinkisYarnClusterClientFactory.class);

    private void initYarnClient(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String configurationDirectory = (String)configuration.get(DeploymentOptionsInternal.CONF_DIR);
        YarnLogConfigUtil.setLogConfigFileInConfig((Configuration)configuration, (String)configurationDirectory);
        String yarnConfDir = configuration.getString(YARN_CONFIG_DIR);
        this.configuration = configuration;
        this.yarnConfiguration = YarnConfLoader.getYarnConf(yarnConfDir);
        this.yarnClient = YarnClient.createYarnClient();
        this.yarnClient.init((org.apache.hadoop.conf.Configuration)this.yarnConfiguration);
        this.yarnClient.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YarnConfiguration getYarnConfiguration(Configuration configuration) {
        if (this.yarnClient == null) {
            LinkisYarnClusterClientFactory linkisYarnClusterClientFactory = this;
            synchronized (linkisYarnClusterClientFactory) {
                if (this.yarnClient == null) {
                    this.initYarnClient(configuration);
                }
            }
        }
        return this.yarnConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YarnClusterDescriptor createClusterDescriptor(Configuration configuration) {
        if (this.yarnClient == null) {
            LinkisYarnClusterClientFactory linkisYarnClusterClientFactory = this;
            synchronized (linkisYarnClusterClientFactory) {
                if (this.yarnClient == null) {
                    this.initYarnClient(configuration);
                }
            }
        }
        return new YarnClusterDescriptor(configuration, this.yarnConfiguration, this.yarnClient, (YarnClusterInformationRetriever)YarnClientYarnClusterInformationRetriever.create((YarnClient)this.yarnClient), true);
    }

    @Override
    public void close() throws IOException {
        if (this.yarnClient != null) {
            ApplicationId applicationId = this.getClusterId(this.configuration);
            if (applicationId != null) {
                LOG.info("Begin to kill application {}", (Object)applicationId);
                try {
                    this.yarnClient.killApplication(applicationId);
                }
                catch (YarnException e) {
                    LOG.error("Failed to kill application {}.", (Object)applicationId, (Object)e);
                }
            }
            this.yarnClient.close();
            LOG.info("End to kill application {},", (Object)applicationId);
        } else {
            LOG.warn("yarnClient is null, this is not able to kill application");
        }
    }
}

