/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs;

import java.util.List;
import java.util.Map;
import org.apache.linkis.cs.ContextSearch;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.condition.Condition;
import org.apache.linkis.cs.condition.construction.ConditionParser;
import org.apache.linkis.cs.condition.impl.AndCondition;
import org.apache.linkis.cs.condition.impl.ContainsCondition;
import org.apache.linkis.cs.condition.impl.ContextScopeCondition;
import org.apache.linkis.cs.condition.impl.ContextTypeCondition;
import org.apache.linkis.cs.condition.impl.ContextValueTypeCondition;
import org.apache.linkis.cs.condition.impl.NearestCondition;
import org.apache.linkis.cs.condition.impl.NotCondition;
import org.apache.linkis.cs.condition.impl.OrCondition;
import org.apache.linkis.cs.condition.impl.RegexCondition;
import org.apache.linkis.cs.contextcache.ContextCacheService;
import org.apache.linkis.cs.errorcode.LinkisCsServerErrorCodeSummary;
import org.apache.linkis.cs.exception.ContextSearchFailedException;
import org.apache.linkis.cs.execution.ConditionExecution;
import org.apache.linkis.cs.execution.impl.AndConditionExecution;
import org.apache.linkis.cs.execution.impl.ContainsConditionExecution;
import org.apache.linkis.cs.execution.impl.ContextScopeConditionExecution;
import org.apache.linkis.cs.execution.impl.ContextTypeConditionExecution;
import org.apache.linkis.cs.execution.impl.ContextValueTypeConditionExecution;
import org.apache.linkis.cs.execution.impl.NearestConditionExecution;
import org.apache.linkis.cs.execution.impl.NotConditionExecution;
import org.apache.linkis.cs.execution.impl.OrConditionExecution;
import org.apache.linkis.cs.execution.impl.RegexConditionExecution;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContextSearch
implements ContextSearch {
    private static Logger logger = LoggerFactory.getLogger(DefaultContextSearch.class);

    @Override
    public List<ContextKeyValue> search(ContextCacheService contextCacheService, ContextID contextID, Map<Object, Object> conditionMap) throws ContextSearchFailedException {
        logger.info("Got search condition: \n" + BDPJettyServerHelper.gson().toJson(conditionMap));
        ConditionParser conditionParser = ConditionParser.parserMap.get(conditionMap.get("type"));
        return this.search(contextCacheService, contextID, conditionParser.parse(conditionMap));
    }

    @Override
    public List<ContextKeyValue> search(ContextCacheService contextCacheService, ContextID contextID, Condition condition) throws ContextSearchFailedException {
        return this.getExecution(contextCacheService, contextID, condition).execute();
    }

    private ConditionExecution getExecution(ContextCacheService contextCacheService, ContextID contextID, Condition condition) throws ContextSearchFailedException {
        if (condition instanceof ContextTypeCondition) {
            return new ContextTypeConditionExecution((ContextTypeCondition)condition, contextCacheService, contextID);
        }
        if (condition instanceof ContextScopeCondition) {
            return new ContextScopeConditionExecution((ContextScopeCondition)condition, contextCacheService, contextID);
        }
        if (condition instanceof RegexCondition) {
            return new RegexConditionExecution((RegexCondition)condition, contextCacheService, contextID);
        }
        if (condition instanceof ContainsCondition) {
            return new ContainsConditionExecution((ContainsCondition)condition, contextCacheService, contextID);
        }
        if (condition instanceof AndCondition) {
            return new AndConditionExecution((AndCondition)condition, contextCacheService, contextID);
        }
        if (condition instanceof OrCondition) {
            return new OrConditionExecution((OrCondition)condition, contextCacheService, contextID);
        }
        if (condition instanceof NotCondition) {
            return new NotConditionExecution((NotCondition)condition, contextCacheService, contextID);
        }
        if (condition instanceof NearestCondition) {
            return new NearestConditionExecution((NearestCondition)condition, contextCacheService, contextID);
        }
        if (condition instanceof ContextValueTypeCondition) {
            return new ContextValueTypeConditionExecution((ContextValueTypeCondition)condition, contextCacheService, contextID);
        }
        throw new ContextSearchFailedException(LinkisCsServerErrorCodeSummary.UNKNOWN_CONDITION_TYPE.getErrorCode(), LinkisCsServerErrorCodeSummary.UNKNOWN_CONDITION_TYPE.getErrorDesc());
    }
}

