/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.basedatamanager.server.restful;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.basedatamanager.server.domain.DatasourceTypeKeyEntity;
import org.apache.linkis.basedatamanager.server.service.DatasourceTypeKeyService;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/basedata-manager/datasource-type-key"})
public class DatasourceTypeKeyRestfulApi {
    private DatasourceTypeKeyService datasourceTypeKeyService;

    public DatasourceTypeKeyRestfulApi(DatasourceTypeKeyService datasourceTypeKeyService) {
        this.datasourceTypeKeyService = datasourceTypeKeyService;
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="string", name="searchName"), @ApiImplicitParam(paramType="query", dataType="int", name="currentPage"), @ApiImplicitParam(paramType="query", dataType="int", name="pageSize")})
    @ApiOperation(value="list", notes="list Datasource Type Key", httpMethod="GET")
    @RequestMapping(path={""}, method={RequestMethod.GET})
    public Message list(HttpServletRequest request, @RequestParam(value="searchName", required=false) String searchName, @RequestParam(value="dataSourceTypeId", required=false) Integer dataSourceTypeId, Integer currentPage, Integer pageSize) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Query list data of Datasource Type Key,search name:" + searchName));
        PageInfo pageList = this.datasourceTypeKeyService.getListByPage(searchName, dataSourceTypeId, currentPage, pageSize);
        return Message.ok((String)"").data("list", (Object)pageList);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="get", notes="Get a Datasource Type Key by id", httpMethod="GET")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.GET})
    public Message get(HttpServletRequest request, @PathVariable(value="id") Long id) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Get a Datasource Type Key Record,id:" + id.toString()));
        DatasourceTypeKeyEntity datasourceType = (DatasourceTypeKeyEntity)this.datasourceTypeKeyService.getById(id);
        return Message.ok((String)"").data("item", (Object)datasourceType);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="DatasourceTypeEntity", name="datasourceType")})
    @ApiOperation(value="add", notes="Add a Datasource Type Key Record", httpMethod="POST")
    @RequestMapping(path={""}, method={RequestMethod.POST})
    public Message add(HttpServletRequest request, @RequestBody DatasourceTypeKeyEntity datasourceType) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Add a Datasource Type Key Record," + datasourceType.toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.datasourceTypeKeyService.save(datasourceType);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="remove", notes="Remove a Datasource Type Key Record by id", httpMethod="DELETE")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.DELETE})
    public Message remove(HttpServletRequest request, @PathVariable(value="id") Long id) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Remove a Datasource Type Key Record,id:" + id.toString()));
        boolean result = this.datasourceTypeKeyService.removeById(id);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="body", dataType="DatasourceTypeEntity", name="datasourceType")})
    @ApiOperation(value="update", notes="Update a Datasource Type Key Record", httpMethod="PUT")
    @RequestMapping(path={""}, method={RequestMethod.PUT})
    public Message update(HttpServletRequest request, @RequestBody DatasourceTypeKeyEntity datasourceType) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Update a Datasource Type Key Record,id:" + datasourceType.getId().toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.datasourceTypeKeyService.updateById(datasourceType);
        return Message.ok((String)"").data("result", (Object)result);
    }
}

