/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.basedatamanager.server.restful;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.basedatamanager.server.domain.DatasourceAccessEntity;
import org.apache.linkis.basedatamanager.server.service.DatasourceAccessService;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"DatasourceAccessRestfulApi"})
@RestController
@RequestMapping(path={"/basedata-manager/datasource-access"})
public class DatasourceAccessRestfulApi {
    @Autowired
    DatasourceAccessService datasourceAccessService;

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="request"), @ApiImplicitParam(paramType="query", dataType="string", name="searchName"), @ApiImplicitParam(paramType="query", dataType="int", name="currentPage"), @ApiImplicitParam(paramType="query", dataType="int", name="pageSize")})
    @ApiOperation(value="list", notes="list Datasource Accesses", httpMethod="GET")
    @RequestMapping(path={""}, method={RequestMethod.GET})
    public Message list(HttpServletRequest request, String searchName, Integer currentPage, Integer pageSize) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Query list data of Datasource Access,search name:" + searchName));
        PageInfo pageList = this.datasourceAccessService.getListByPage(searchName, currentPage, pageSize);
        return Message.ok((String)"").data("list", (Object)pageList);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="request"), @ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="get", notes="Get a Datasource Access Record", httpMethod="GET")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.GET})
    public Message get(HttpServletRequest request, @PathVariable(value="id") Long id) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Get a Datasource Access Record,id:" + id.toString()));
        DatasourceAccessEntity datasourceAccess = (DatasourceAccessEntity)this.datasourceAccessService.getById(id);
        return Message.ok((String)"").data("item", (Object)datasourceAccess);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="request"), @ApiImplicitParam(paramType="body", dataType="DatasourceAccessEntity", name="datasourceAccess")})
    @ApiOperation(value="add", notes="", httpMethod="POST")
    @RequestMapping(path={""}, method={RequestMethod.POST})
    public Message add(HttpServletRequest request, @RequestBody DatasourceAccessEntity datasourceAccess) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Add a Datasource Access Record," + datasourceAccess.toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        datasourceAccess.setAccessTime(new Date());
        boolean result = this.datasourceAccessService.save(datasourceAccess);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="request"), @ApiImplicitParam(paramType="path", dataType="long", name="id")})
    @ApiOperation(value="remove", notes="Remove a Datasource Access Record", httpMethod="DELETE")
    @RequestMapping(path={"/{id}"}, method={RequestMethod.DELETE})
    public Message remove(HttpServletRequest request, @PathVariable(value="id") Long id) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Remove a Datasource Access Record,id:" + id.toString()));
        boolean result = this.datasourceAccessService.removeById(id);
        return Message.ok((String)"").data("result", (Object)result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(paramType="query", dataType="HttpServletRequest", name="request"), @ApiImplicitParam(paramType="body", dataType="DatasourceAccessEntity", name="datasourceAccess")})
    @ApiOperation(value="update", notes="Update a Datasource Access Record", httpMethod="PUT")
    @RequestMapping(path={""}, method={RequestMethod.PUT})
    public Message update(HttpServletRequest request, @RequestBody DatasourceAccessEntity datasourceAccess) {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("Update a Datasource Access Record,id:" + datasourceAccess.getId().toString()));
        if (!Configuration.isAdmin((String)username)) {
            return Message.error((String)("User '" + username + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        boolean result = this.datasourceAccessService.updateById(datasourceAccess);
        return Message.ok((String)"").data("result", (Object)result);
    }
}

