/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.score;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.manager.common.entity.node.ScoreServiceInstance;
import org.apache.linkis.manager.common.entity.persistence.PersistenceLabel;
import org.apache.linkis.manager.label.conf.LabelCommonConfig;
import org.apache.linkis.manager.label.entity.Feature;
import org.apache.linkis.manager.label.score.LabelScoreServiceInstance;
import org.apache.linkis.manager.label.score.NodeLabelScorer;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction2;

@Component
@ScalaSignature(bytes="\u0006\u0001q4AAB\u0004\u0001)!)q\u0004\u0001C\u0001A!)!\u0005\u0001C!G!)Q\n\u0001C\u0005\u001d\")Q\r\u0001C\u0005M\")q\u000e\u0001C\u0005a\n1B)\u001a4bk2$hj\u001c3f\u0019\u0006\u0014W\r\\*d_J,'O\u0003\u0002\t\u0013\u0005)1oY8sK*\u0011!bC\u0001\u0006Y\u0006\u0014W\r\u001c\u0006\u0003\u00195\tq!\\1oC\u001e,'O\u0003\u0002\u000f\u001f\u00051A.\u001b8lSNT!\u0001E\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0012aA8sO\u000e\u00011c\u0001\u0001\u00167A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"\u0001H\u000f\u000e\u0003\u001dI!AH\u0004\u0003\u001f9{G-\u001a'bE\u0016d7kY8sKJ\fa\u0001P5oSRtD#A\u0011\u0011\u0005q\u0001\u0011!C2bY\u000e,H.\u0019;f)\u0011!s\bS&\u0011\t\u0015RCFN\u0007\u0002M)\u0011q\u0005K\u0001\u0005kRLGNC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-2#aA'baB\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u0005]>$WM\u0003\u00022e\u00051QM\u001c;jifT!aM\u0006\u0002\r\r|W.\\8o\u0013\t)dF\u0001\u000bTG>\u0014XmU3sm&\u001cW-\u00138ti\u0006t7-\u001a\t\u0004K]J\u0014B\u0001\u001d'\u0005\u0011a\u0015n\u001d;\u0011\u0005ijT\"A\u001e\u000b\u0005q\u0002\u0014a\u00039feNL7\u000f^3oG\u0016L!AP\u001e\u0003!A+'o]5ti\u0016t7-\u001a'bE\u0016d\u0007\"\u0002!\u0003\u0001\u0004\t\u0015\u0001D5o\u001d>$W\rR3he\u0016,\u0007\u0003B\u0013+s\t\u00032!J\u001cD!\t!e)D\u0001F\u0015\t\u0019T\"\u0003\u0002H\u000b\ny1+\u001a:wS\u000e,\u0017J\\:uC:\u001cW\rC\u0003J\u0005\u0001\u0007!*A\u0007pkRtu\u000eZ3EK\u001e\u0014X-\u001a\t\u0005K)\u001ae\u0007C\u0003M\u0005\u0001\u0007a'\u0001\u0004mC\n,Gn]\u0001\u001diJ\fg/\u001a:tC2\fe\u000eZ*d_J,wJ\\(vi\u0012+wM]3f)\u0015y5\fY2e!\u0011)#\u0006U\u001d\u0011\u0005ECfB\u0001*W!\t\u0019v#D\u0001U\u0015\t)6#\u0001\u0004=e>|GOP\u0005\u0003/^\ta\u0001\u0015:fI\u00164\u0017BA-[\u0005\u0019\u0019FO]5oO*\u0011qk\u0006\u0005\u00069\u000e\u0001\r!X\u0001\tE\u0006\u001cXmQ8sKB\u0011aCX\u0005\u0003?^\u0011a\u0001R8vE2,\u0007\"B1\u0004\u0001\u0004\u0011\u0017A\u00038pI\u0016\u001c6m\u001c:fgB!QEK\"^\u0011\u0015I5\u00011\u0001K\u0011\u0015a5\u00011\u00017\u0003m!(/\u0019<feN\fG.\u00118e'\u000e|'/Z(o\u0013:$Um\u001a:fKR)qM[6m[B\u0011a\u0003[\u0005\u0003S^\u0011A!\u00168ji\")A\f\u0002a\u0001;\")\u0011\r\u0002a\u0001E\")\u0001\t\u0002a\u0001\u0003\")a\u000e\u0002a\u0001\u001f\u0006yA.\u00192fY&#Gk\\#oi&$\u00180\u0001\no_Jl\u0017\r\\5{K\u0006sGmT;uaV$Hc\u0001\u0013re\")\u0011-\u0002a\u0001E\")\u0011*\u0002a\u0001\u0015\"\u0012\u0001\u0001\u001e\t\u0003kjl\u0011A\u001e\u0006\u0003ob\f!b\u001d;fe\u0016|G/\u001f9f\u0015\tI\u0018#A\btaJLgn\u001a4sC6,wo\u001c:l\u0013\tYhOA\u0005D_6\u0004xN\\3oi\u0002")
public class DefaultNodeLabelScorer
implements NodeLabelScorer {
    @Override
    public java.util.Map<ScoreServiceInstance, List<PersistenceLabel>> calculate(java.util.Map<PersistenceLabel, List<ServiceInstance>> inNodeDegree, java.util.Map<ServiceInstance, List<PersistenceLabel>> outNodeDegree, List<PersistenceLabel> labels) {
        double baseCore = Predef$.MODULE$.Double2double((Double)LabelCommonConfig.LABEL_SCORER_BASE_CORE.getValue());
        HashMap<ServiceInstance, Object> nodeScores = new HashMap<ServiceInstance, Object>();
        java.util.Map<String, PersistenceLabel> labelIdToEntity = this.traversalAndScoreOnOutDegree(baseCore, nodeScores, outNodeDegree, labels);
        this.traversalAndScoreOnInDegree(baseCore, nodeScores, inNodeDegree, labelIdToEntity);
        return this.normalizeAndOutput(nodeScores, outNodeDegree);
    }

    private java.util.Map<String, PersistenceLabel> traversalAndScoreOnOutDegree(double baseCore, java.util.Map<ServiceInstance, Object> nodeScores, java.util.Map<ServiceInstance, List<PersistenceLabel>> outNodeDegree, List<PersistenceLabel> labels) {
        HashMap ftCounts = new HashMap();
        BiFunction<Feature, Integer, Integer> countFunction = new BiFunction<Feature, Integer, Integer>(null){

            public <V> BiFunction<Feature, Integer, V> andThen(Function<? super Integer, ? extends V> x$1) {
                return BiFunction.super.andThen(x$1);
            }

            public Integer apply(Feature t, Integer count) {
                Integer count0 = count;
                if (Option$.MODULE$.apply((Object)count0).isEmpty()) {
                    count0 = Predef$.MODULE$.int2Integer(0);
                }
                count0 = Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(count0) + 1);
                return count0;
            }
        };
        scala.collection.immutable.Map labelIdToEntity = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(labels).asScala()).map((Function1 & Serializable & scala.Serializable)label -> {
            ftCounts.compute(label.getFeature(), countFunction);
            return new Tuple2((Object)String.valueOf(label.getId()), label);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(outNodeDegree).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)DefaultNodeLabelScorer.$anonfun$traversalAndScoreOnOutDegree$2(labelIdToEntity, baseCore, ftCounts, nodeScores, x0$1)));
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)labelIdToEntity).asJava();
    }

    private void traversalAndScoreOnInDegree(double baseCore, java.util.Map<ServiceInstance, Object> nodeScores, java.util.Map<PersistenceLabel, List<ServiceInstance>> inNodeDegree, java.util.Map<String, PersistenceLabel> labelIdToEntity) {
        Integer relateLimit = (Integer)LabelCommonConfig.LABEL_SCORER_RELATE_LIMIT.getValue();
        DoubleRef relateSum = DoubleRef.create((double)0.0);
        IntRef relateCount = IntRef.create((int)0);
        ((IterableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(inNodeDegree).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PersistenceLabel label = (PersistenceLabel)tuple2._1();
                List nodes = (List)tuple2._2();
                if (nodes.size() <= Predef$.MODULE$.Integer2int(relateLimit)) {
                    return new Tuple2((Object)label, (Object)BoxesRunTime.boxToDouble((double)0.0));
                }
                return new Tuple2((Object)label, (Object)BoxesRunTime.boxToDouble((double)((double)nodes.size() / (double)nodeScores.size())));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DefaultNodeLabelScorer.$anonfun$traversalAndScoreOnInDegree$2(labelIdToEntity, relateSum, relateCount, x0$2)))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DefaultNodeLabelScorer.$anonfun$traversalAndScoreOnInDegree$3(inNodeDegree, relateSum, relateCount, nodeScores, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private java.util.Map<ScoreServiceInstance, List<PersistenceLabel>> normalizeAndOutput(java.util.Map<ServiceInstance, Object> nodeScores, java.util.Map<ServiceInstance, List<PersistenceLabel>> outNodeDegree) {
        double average = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodeScores.values()).asScala()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$3, x$4) -> x$3 + x$4)) / (double)nodeScores.size();
        double deviation = package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodeScores.values()).asScala()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(sum, score) -> sum + package$.MODULE$.pow(score - average, 2.0))) * (1.0 / (double)nodeScores.size()));
        DoubleRef offset = DoubleRef.create((double)0.0);
        scala.collection.mutable.Map rawOutput = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(nodeScores).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                double scoreCalculate;
                ServiceInstance node = (ServiceInstance)tuple2._1();
                double score = tuple2._2$mcD$sp();
                LabelScoreServiceInstance labelScoreServiceInstance = new LabelScoreServiceInstance(node);
                double d = scoreCalculate = deviation != 0.0 ? (score - average) / deviation : score;
                if (scoreCalculate < offset$1.elem) {
                    offset$1.elem = scoreCalculate;
                }
                labelScoreServiceInstance.setScore(scoreCalculate);
                return new Tuple2((Object)labelScoreServiceInstance, outNodeDegree.get(node));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        rawOutput.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DefaultNodeLabelScorer.$anonfun$normalizeAndOutput$4(offset, x0$2);
            return BoxedUnit.UNIT;
        });
        if (rawOutput != null && rawOutput.nonEmpty()) {
            return new HashMap<ScoreServiceInstance, List<PersistenceLabel>>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)rawOutput.toMap(Predef$.MODULE$.$conforms())).asJava());
        }
        return new HashMap<ScoreServiceInstance, List<PersistenceLabel>>();
    }

    public static final /* synthetic */ double $anonfun$traversalAndScoreOnOutDegree$3(scala.collection.immutable.Map labelIdToEntity$1, double baseCore$1, HashMap ftCounts$1, PersistenceLabel label) {
        if (labelIdToEntity$1.contains((Object)String.valueOf(label.getId()))) {
            Feature feature = (Feature)Option$.MODULE$.apply((Object)label.getFeature()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Feature.OPTIONAL);
            return baseCore$1 / (double)Predef$.MODULE$.Integer2int((Integer)ftCounts$1.get(feature)) * (double)feature.getBoost();
        }
        return 0.0;
    }

    public static final /* synthetic */ double $anonfun$traversalAndScoreOnOutDegree$2(scala.collection.immutable.Map labelIdToEntity$1, double baseCore$1, HashMap ftCounts$1, java.util.Map nodeScores$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ServiceInstance node = (ServiceInstance)tuple2._1();
            List outLabels = (List)tuple2._2();
            double scoreOutDegree = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(outLabels).asScala()).map((Function1 & Serializable & scala.Serializable)label -> BoxesRunTime.boxToDouble((double)DefaultNodeLabelScorer.$anonfun$traversalAndScoreOnOutDegree$3(labelIdToEntity$1, baseCore$1, ftCounts$1, label)), Buffer$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2));
            return BoxesRunTime.unboxToDouble((Object)nodeScores$1.put(node, BoxesRunTime.boxToDouble((double)scoreOutDegree)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$traversalAndScoreOnInDegree$2(java.util.Map labelIdToEntity$2, DoubleRef relateSum$1, IntRef relateCount$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            boolean isMatch;
            PersistenceLabel label = (PersistenceLabel)tuple2._1();
            double score = tuple2._2$mcD$sp();
            boolean bl = isMatch = !labelIdToEntity$2.containsKey(String.valueOf(label.getId())) && score > 0.0;
            if (isMatch) {
                relateSum$1.elem += score;
                ++relateCount$1.elem;
            }
            return isMatch;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$traversalAndScoreOnInDegree$3(java.util.Map inNodeDegree$1, DoubleRef relateSum$1, IntRef relateCount$1, java.util.Map nodeScores$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            PersistenceLabel label = (PersistenceLabel)tuple2._1();
            double score = tuple2._2$mcD$sp();
            List nodes = (List)inNodeDegree$1.get(label);
            if (Option$.MODULE$.apply((Object)nodes).isDefined()) {
                double minScore = package$.MODULE$.min((double)Feature.UNKNOWN.getBoost() * score / relateSum$1.elem, (double)Feature.UNKNOWN.getBoost() * (double)nodes.size() / (double)relateCount$1.elem);
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(nodes).asScala()).foreach((Function1 & Serializable & scala.Serializable)node -> {
                    double nodeScore = BoxesRunTime.unboxToDouble(nodeScores$2.get(node));
                    if (Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)nodeScore)).isDefined()) {
                        return nodeScores$2.put(node, BoxesRunTime.boxToDouble((double)(nodeScore + minScore)));
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$normalizeAndOutput$4(DoubleRef offset$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            ScoreServiceInstance instance = (ScoreServiceInstance)tuple2._1();
            instance.setScore(instance.getScore() + package$.MODULE$.abs(offset$1.elem));
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

