/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.SourceFactory;
import org.apache.kylin.source.jdbc.ISourceConnector;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.LogicalViewLoader;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.SparderTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSourceInput
implements NSparkCubingEngine.NSparkCubingSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcSourceInput.class);

    public Dataset<Row> getSourceData(TableDesc table, SparkSession ss, Map<String, String> parameters) {
        if (table.getIdentity().contains(table.getConfig().getDDLLogicalViewDB())) {
            LogicalViewLoader.addCatalogConfByJdbc((SparkSession)ss, (String)table.getProject());
            return ((NSparkCubingEngine.NSparkCubingSource)SourceFactory.getSparkSource().adaptToBuildEngine(NSparkCubingEngine.NSparkCubingSource.class)).getSourceData(table, ss, parameters);
        }
        ColumnDesc[] columnDescs = table.getColumns();
        ArrayList tblColNames = Lists.newArrayListWithCapacity((int)columnDescs.length);
        StructType kylinSchema = new StructType();
        for (ColumnDesc columnDesc : columnDescs) {
            if (columnDesc.isComputedColumn()) continue;
            kylinSchema = kylinSchema.add(columnDesc.getName(), SparderTypeUtil.toSparkType((DataType)columnDesc.getType(), (boolean)false), true);
            tblColNames.add(columnDesc.getName());
        }
        Object[] colNames = tblColNames.toArray(new String[0]);
        String colString = Joiner.on((String)",").join(colNames);
        String sql = String.format(Locale.ROOT, "select %s from %s", colString, table.getIdentity());
        KylinConfig config = table.getConfig();
        ISourceConnector connector = (ISourceConnector)ClassUtil.newInstance((String)config.getJdbcSourceConnector());
        parameters.put("table", table.getIdentity());
        log.info("Use source connector: {}", (Object)connector.getClass().getCanonicalName());
        Dataset<Row> dataset = connector.getSourceData(config, ss, sql, parameters);
        StructType sparkSchema = dataset.schema();
        return dataset.select(SparderTypeUtil.alignDataTypeAndName((StructType)sparkSchema, (StructType)kylinSchema));
    }

    public Long getSourceDataCount(TableDesc table, SparkSession ss, Map<String, String> parameters) {
        if (table.getIdentity().contains(table.getConfig().getDDLLogicalViewDB())) {
            LogicalViewLoader.addCatalogConfByJdbc((SparkSession)ss, (String)table.getProject());
            return ((NSparkCubingEngine.NSparkCubingSource)SourceFactory.getSparkSource().adaptToBuildEngine(NSparkCubingEngine.NSparkCubingSource.class)).getSourceDataCount(table, ss, parameters);
        }
        String sql = String.format(Locale.ROOT, "select count(*) from %s", table.getIdentity());
        KylinConfig config = table.getConfig();
        ISourceConnector connector = (ISourceConnector)ClassUtil.newInstance((String)config.getJdbcSourceConnector());
        parameters.put("table", table.getIdentity());
        log.info("Use source connector: {}, sql: {} ", (Object)connector.getClass().getCanonicalName(), (Object)sql);
        Dataset<Row> dataset = connector.getCountData(config, ss, sql, parameters);
        return ((Row)dataset.first()).getLong(0);
    }
}

