/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.discovery.ConditionalOnNodeRegistryZookeeperEnabled;
import org.apache.kylin.rest.discovery.KylinServiceDiscoveryCache;
import org.apache.kylin.rest.discovery.KylinServiceDiscoveryClient;
import org.apache.kylin.rest.response.ServerInfoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.stereotype.Component;

@ConditionalOnZookeeperEnabled
@ConditionalOnNodeRegistryZookeeperEnabled
@Component
public class ZookeeperClusterManager
implements ClusterManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperClusterManager.class);
    @Autowired
    private KylinServiceDiscoveryCache serviceCache;
    @Autowired
    private KylinServiceDiscoveryClient discoveryClient;

    public String getLocalServer() {
        return this.discoveryClient.getLocalServiceServer();
    }

    public List<ServerInfoResponse> getQueryServers() {
        return this.getServerByMode(new ClusterConstant.ServerModeEnum[]{ClusterConstant.ServerModeEnum.ALL, ClusterConstant.ServerModeEnum.QUERY});
    }

    public List<ServerInfoResponse> getServersFromCache() {
        return this.getServers();
    }

    public List<ServerInfoResponse> getJobServers() {
        return this.getServerByMode(new ClusterConstant.ServerModeEnum[]{ClusterConstant.ServerModeEnum.ALL, ClusterConstant.ServerModeEnum.JOB});
    }

    public List<ServerInfoResponse> getServers() {
        return this.getServerByMode(new ClusterConstant.ServerModeEnum[]{ClusterConstant.ServerModeEnum.ALL, ClusterConstant.ServerModeEnum.JOB, ClusterConstant.ServerModeEnum.QUERY});
    }

    private List<ServerInfoResponse> getServerByMode(ClusterConstant.ServerModeEnum ... serverModeEnum) {
        ArrayList<ServerInfoResponse> servers = new ArrayList<ServerInfoResponse>();
        if (ArrayUtils.isEmpty((Object[])serverModeEnum)) {
            return servers;
        }
        for (ClusterConstant.ServerModeEnum nodeModeType : serverModeEnum) {
            servers.addAll(this.serviceCache.getServerInfoByServerMode(new ClusterConstant.ServerModeEnum[]{nodeModeType}));
        }
        return servers;
    }
}

