/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.metrics;

import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.common.Metrics;
import org.apache.kylin.common.metrics.common.MetricsFactory;
import org.apache.kylin.common.metrics.common.MetricsNameBuilder;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class QueryMetrics2Facade {
    private static final Logger logger = LoggerFactory.getLogger(QueryMetrics2Facade.class);
    private static Metrics metrics;
    private static boolean enabled;

    public static void init() {
        enabled = KylinConfig.getInstanceFromEnv().getQueryMetrics2Enabled();
    }

    public static void updateMetrics(SQLRequest sqlRequest, SQLResponse sqlResponse) {
        if (!enabled) {
            return;
        }
        if (metrics == null) {
            metrics = MetricsFactory.getInstance();
        }
        String projectName = sqlRequest.getProject();
        String cube = sqlResponse.getCube();
        if (StringUtils.isEmpty((CharSequence)cube)) {
            return;
        }
        String cubeName = cube.replace("=", "->");
        QueryMetrics2Facade.update(MetricsNameBuilder.buildCubeMetricPrefix((String)"total"), sqlResponse);
        QueryMetrics2Facade.update(MetricsNameBuilder.buildCubeMetricPrefix((String)projectName), sqlResponse);
        String cubeMetricName = MetricsNameBuilder.buildCubeMetricPrefix((String)projectName, (String)cubeName);
        QueryMetrics2Facade.update(cubeMetricName, sqlResponse);
    }

    private static void update(String name, SQLResponse sqlResponse) {
        try {
            QueryMetrics2Facade.incrQueryCount(name, sqlResponse);
            QueryMetrics2Facade.incrCacheHitCount(name, sqlResponse);
            if (!sqlResponse.getIsException()) {
                metrics.updateTimer(MetricsNameBuilder.buildMetricName((String)name, (String)"QueryDuration"), sqlResponse.getDuration(), TimeUnit.MILLISECONDS);
                metrics.updateHistogram(MetricsNameBuilder.buildMetricName((String)name, (String)"QueryResultRowcount"), (long)sqlResponse.getResults().size());
                metrics.updateHistogram(MetricsNameBuilder.buildMetricName((String)name, (String)"QueryScanRowcount"), sqlResponse.getTotalScanCount());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private static void incrQueryCount(String name, SQLResponse sqlResponse) {
        if (!sqlResponse.isHitExceptionCache() && !sqlResponse.getIsException()) {
            metrics.incrementCounter(MetricsNameBuilder.buildMetricName((String)name, (String)"QuerySuccessCount"));
        } else {
            metrics.incrementCounter(MetricsNameBuilder.buildMetricName((String)name, (String)"QueryFailCount"));
        }
        metrics.incrementCounter(MetricsNameBuilder.buildMetricName((String)name, (String)"QueryCount"));
    }

    private static void incrCacheHitCount(String name, SQLResponse sqlResponse) {
        if (sqlResponse.isStorageCacheUsed()) {
            metrics.incrementCounter(MetricsNameBuilder.buildMetricName((String)name, (String)"QueryCacheCount"));
        }
    }

    static {
        enabled = false;
    }
}

