/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.PostConstruct;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.prepare.OnlyPrepareEarlyAbortException;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.kylin.cache.cachemanager.MemcachedCacheManager;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.exceptions.ResourceLimitExceededException;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.CheckUtil;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.ServerMode;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.ModelDimensionDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.querymeta.ColumnMeta;
import org.apache.kylin.metadata.querymeta.ColumnMetaWithType;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.metadata.querymeta.TableMeta;
import org.apache.kylin.metadata.querymeta.TableMetaWithType;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metrics.QuerySparkMetrics;
import org.apache.kylin.query.QueryConnection;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.kylin.query.util.QueryInfoCollector;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.query.util.TempStatementUtil;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.metrics.QueryMetrics2Facade;
import org.apache.kylin.rest.metrics.QueryMetricsFacade;
import org.apache.kylin.rest.model.Query;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.request.PrepareSqlRequest;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.service.BadQueryDetector;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.CacheService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.QueryRecord;
import org.apache.kylin.rest.service.TableACLService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.rest.util.QueryRequestLimits;
import org.apache.kylin.rest.util.SQLResponseSignatureUtil;
import org.apache.kylin.rest.util.TableauInterceptor;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.apache.spark.sql.SparderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="queryService")
public class QueryService
extends BasicService {
    public static final String QUERY_CACHE = "StorageCache";
    public static final String QUERY_STORE_PATH_PREFIX = "/query/";
    private static final Logger logger = LoggerFactory.getLogger(QueryService.class);
    final BadQueryDetector badQueryDetector = new BadQueryDetector();
    final ResourceStore queryStore = ResourceStore.getStore((KylinConfig)this.getConfig());
    @Autowired
    protected CacheManager cacheManager;
    @Autowired
    @Qualifier(value="cacheService")
    private CacheService cacheService;
    @Autowired
    @Qualifier(value="modelMgmtService")
    private ModelService modelService;
    @Autowired
    @Qualifier(value="TableAclService")
    private TableACLService tableAclService;
    @Autowired
    private AclEvaluate aclEvaluate;
    private GenericKeyedObjectPool<PreparedContextKey, PreparedContext> preparedContextPool = this.createPreparedContextPool();

    public QueryService() {
        this.badQueryDetector.start();
    }

    private GenericKeyedObjectPool<PreparedContextKey, PreparedContext> createPreparedContextPool() {
        PreparedContextFactory factory = new PreparedContextFactory();
        KylinConfig kylinConfig = this.getConfig();
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMaxTotalPerKey(kylinConfig.getQueryMaxCacheStatementInstancePerKey());
        config.setMaxTotal(kylinConfig.getQueryMaxCacheStatementNum());
        config.setBlockWhenExhausted(false);
        config.setMinEvictableIdleTimeMillis(600000L);
        config.setTimeBetweenEvictionRunsMillis(60000L);
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)factory, config);
        return pool;
    }

    protected static void close(ResultSet resultSet, Statement stat, Connection conn) {
        OLAPContext.clearParameter();
        DBUtils.closeQuietly((ResultSet)resultSet);
        DBUtils.closeQuietly((Statement)stat);
        DBUtils.closeQuietly((Connection)conn);
    }

    private static String getQueryKeyById(String creator) {
        return QUERY_STORE_PATH_PREFIX + creator;
    }

    @PostConstruct
    public void init() throws IOException {
        Preconditions.checkNotNull((Object)this.cacheManager, (Object)"cacheManager is not injected yet");
    }

    public List<TableMeta> getMetadataFilterByUser(String project) throws SQLException, IOException {
        return this.tableAclService.filterTableMetasByAcl(this.getMetadata(project), project);
    }

    public List<TableMeta> getMetadata(String project) throws SQLException {
        return this.getMetadata(this.getCubeManager(), project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLResponse query(SQLRequest sqlRequest, String queryId) throws Exception {
        String badReason;
        SQLResponse sQLResponse;
        SQLResponse ret = null;
        try {
            String user = SecurityContextHolder.getContext().getAuthentication().getName();
            this.badQueryDetector.queryStart(Thread.currentThread(), sqlRequest, user, queryId);
            sQLResponse = ret = this.queryWithSqlMassage(sqlRequest);
            badReason = ret != null && ret.isPushDown() ? "Pushdown" : null;
        }
        catch (Throwable throwable) {
            String badReason2 = ret != null && ret.isPushDown() ? "Pushdown" : null;
            this.badQueryDetector.queryEnd(Thread.currentThread(), badReason2);
            Thread.interrupted();
            throw throwable;
        }
        this.badQueryDetector.queryEnd(Thread.currentThread(), badReason);
        Thread.interrupted();
        return sQLResponse;
    }

    public SQLResponse update(SQLRequest sqlRequest) throws Exception {
        logger.debug("Query pushdown enabled, redirect the non-select query to pushdown engine.");
        Connection conn = null;
        try {
            conn = QueryConnection.getConnection((String)sqlRequest.getProject());
            Pair r = PushDownUtil.tryPushDownNonSelectQuery((String)sqlRequest.getProject(), (String)sqlRequest.getSql(), (String)conn.getSchema(), (boolean)BackdoorToggles.getPrepareOnly());
            ArrayList columnMetas = Lists.newArrayList();
            columnMetas.add(new SelectedColumnMeta(false, false, false, false, 1, false, Integer.MAX_VALUE, "c0", "c0", null, null, null, Integer.MAX_VALUE, 128, 1, "char", false, false, false));
            SQLResponse sQLResponse = this.buildSqlResponse(sqlRequest.getProject(), true, (List)r.getFirst(), columnMetas);
            return sQLResponse;
        }
        catch (Exception e) {
            logger.info("pushdown engine failed to finish current non-select query");
            throw e;
        }
        finally {
            QueryService.close(null, null, conn);
        }
    }

    public void saveQuery(String creator, Query query) throws IOException {
        List<Query> queries = this.getQueries(creator);
        queries.add(query);
        Query[] queryArray = new Query[queries.size()];
        QueryRecord record = new QueryRecord(queries.toArray(queryArray));
        this.queryStore.putResource(QueryService.getQueryKeyById(creator), (RootPersistentEntity)record, System.currentTimeMillis(), (Serializer)QueryRecordSerializer.getInstance());
    }

    public void removeQuery(String creator, String id) throws IOException {
        List<Query> queries = this.getQueries(creator);
        Iterator<Query> queryIter = queries.iterator();
        boolean changed = false;
        while (queryIter.hasNext()) {
            Query temp = queryIter.next();
            if (!temp.getId().equals(id)) continue;
            queryIter.remove();
            changed = true;
            break;
        }
        if (!changed) {
            return;
        }
        Query[] queryArray = new Query[queries.size()];
        QueryRecord record = new QueryRecord(queries.toArray(queryArray));
        this.queryStore.putResource(QueryService.getQueryKeyById(creator), (RootPersistentEntity)record, System.currentTimeMillis(), (Serializer)QueryRecordSerializer.getInstance());
    }

    public List<Query> getQueries(String creator) throws IOException {
        return this.getQueries(creator, null);
    }

    public List<Query> getQueries(String creator, String project) throws IOException {
        if (null == creator) {
            return null;
        }
        ArrayList<Query> queries = new ArrayList<Query>();
        QueryRecord record = (QueryRecord)this.queryStore.getResource(QueryService.getQueryKeyById(creator), (Serializer)QueryRecordSerializer.getInstance());
        if (record != null) {
            for (Query query : record.getQueries()) {
                if (project != null && !query.getProject().equals(project)) continue;
                queries.add(query);
            }
        }
        return queries;
    }

    public void logQuery(String queryId, SQLRequest request, SQLResponse response) {
        List<QueryContext.CubeSegmentStatisticsResult> cubeSegmentStatisticsList;
        String user = this.aclEvaluate.getCurrentUserName();
        LinkedList<String> realizationNames = new LinkedList<String>();
        LinkedList<Long> cuboidIds = new LinkedList<Long>();
        LinkedList<Boolean> isExactlyMatchSet = new LinkedList<Boolean>();
        float duration = (float)response.getDuration() / 1000.0f;
        boolean storageCacheUsed = response.isStorageCacheUsed();
        boolean isPushDown = response.isPushDown();
        if (!response.isHitExceptionCache() && null != OLAPContext.getThreadLocalContexts()) {
            for (OLAPContext ctx : OLAPContext.getThreadLocalContexts()) {
                Cuboid cuboid = ctx.storageContext.getCuboid();
                if (cuboid != null) {
                    cuboidIds.add(cuboid.getId());
                }
                isExactlyMatchSet.add(ctx.isExactlyAggregate);
                if (ctx.realization == null) continue;
                realizationNames.add(ctx.realization.getCanonicalName());
            }
        }
        if (realizationNames.isEmpty() && !Strings.isNullOrEmpty((String)response.getCube())) {
            realizationNames.addAll(Lists.newArrayList((Object[])StringUtil.splitByComma((String)response.getCube())));
        }
        if (cuboidIds.isEmpty() && CollectionUtils.isNotEmpty(cubeSegmentStatisticsList = response.getCubeSegmentStatisticsList())) {
            cubeSegmentStatisticsList.forEach(cubeSegmentStatResult -> {
                if (MapUtils.isNotEmpty((Map)cubeSegmentStatResult.getCubeSegmentStatisticsMap())) {
                    cubeSegmentStatResult.getCubeSegmentStatisticsMap().values().forEach(cubeSegmentStatMap -> cubeSegmentStatMap.values().forEach(cubeSegmentStat -> cuboidIds.add(cubeSegmentStat.getTargetCuboidId())));
                }
            });
        }
        int resultRowCount = 0;
        if (!response.getIsException() && response.getResults() != null) {
            resultRowCount = response.getResults().size();
        }
        String newLine = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(newLine);
        stringBuilder.append("==========================[QUERY]===============================").append(newLine);
        stringBuilder.append("Query Id: ").append(queryId).append(newLine);
        stringBuilder.append("SQL: ").append(request.getSql()).append(newLine);
        stringBuilder.append("User: ").append(user).append(newLine);
        stringBuilder.append("Success: ").append(null == response.getExceptionMessage()).append(newLine);
        stringBuilder.append("Duration: ").append(duration).append(newLine);
        stringBuilder.append("Project: ").append(request.getProject()).append(newLine);
        stringBuilder.append("Realization Names: ").append(realizationNames).append(newLine);
        stringBuilder.append("Cuboid Ids: ").append(cuboidIds).append(newLine);
        stringBuilder.append("Is Exactly Matched: ").append(isExactlyMatchSet).append(newLine);
        stringBuilder.append("Total scan count: ").append(response.getTotalScanCount()).append(newLine);
        stringBuilder.append("Total scan files: ").append(response.getTotalScanFiles()).append(newLine);
        stringBuilder.append("Total metadata time: ").append(response.getMetadataTime()).append("ms").append(newLine);
        stringBuilder.append("Total spark scan time: ").append(response.getTotalSparkScanTime()).append("ms").append(newLine);
        stringBuilder.append("Total scan bytes: ").append(response.getTotalScanBytes()).append(newLine);
        stringBuilder.append("Result row count: ").append(resultRowCount).append(newLine);
        stringBuilder.append("Storage cache used: ").append(storageCacheUsed).append(newLine);
        stringBuilder.append("Is Query Push-Down: ").append(isPushDown).append(newLine);
        stringBuilder.append("Is Prepare: ").append(BackdoorToggles.getPrepareOnly()).append(newLine);
        stringBuilder.append("Used Spark pool: ").append(response.getSparkPool()).append(newLine);
        stringBuilder.append("Trace URL: ").append(response.getTraceUrl()).append(newLine);
        stringBuilder.append("Message: ").append(response.getExceptionMessage()).append(newLine);
        stringBuilder.append("==========================[QUERY]===============================").append(newLine);
        logger.info(stringBuilder.toString());
    }

    public SQLResponse querySystemCube(String sql) {
        SQLRequest sqlRequest = new SQLRequest();
        sqlRequest.setProject("KYLIN_SYSTEM");
        sqlRequest.setSql(sql);
        return this.doQueryWithCache(sqlRequest, false);
    }

    public SQLResponse doQueryWithCache(SQLRequest sqlRequest) {
        long t = System.currentTimeMillis();
        this.aclEvaluate.checkProjectReadPermission(sqlRequest.getProject());
        logger.info("Check query permission in " + (System.currentTimeMillis() - t) + " ms.");
        return this.doQueryWithCache(sqlRequest, false);
    }

    /*
     * Loose catch block
     */
    public SQLResponse doQueryWithCache(SQLRequest sqlRequest, boolean isQueryInspect) {
        Message msg = MsgPicker.getMsg();
        sqlRequest.setUsername(this.getUserName());
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (!ServerMode.SERVER_MODE.canServeQuery()) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getQUERY_NOT_ALLOWED(), kylinConfig.getServerMode()));
        }
        if (StringUtils.isBlank((String)sqlRequest.getProject())) {
            throw new BadRequestException(msg.getEMPTY_PROJECT_NAME());
        }
        ProjectManager mgr = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        if (mgr.getProject(sqlRequest.getProject()) == null) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getPROJECT_NOT_FOUND(), sqlRequest.getProject()));
        }
        if (StringUtils.isBlank((String)sqlRequest.getSql())) {
            throw new BadRequestException(msg.getNULL_EMPTY_SQL());
        }
        if (sqlRequest.getBackdoorToggles() != null) {
            BackdoorToggles.addToggles(sqlRequest.getBackdoorToggles());
        }
        QueryContext queryContext = QueryContextFacade.current();
        try {
            try (SetThreadName ignored = new SetThreadName("Query %s", new Object[]{queryContext.getQueryId()});){
                OLAPContext.clearThreadLocalContexts();
                SQLResponse sqlResponse = null;
                String sql = sqlRequest.getSql();
                String project = sqlRequest.getProject();
                boolean isQueryCacheEnabled = this.isQueryCacheEnabled(kylinConfig);
                logger.info("Using project: " + project);
                logger.info("The original query:  " + sql);
                sql = QueryUtil.removeCommentInSql((String)sql);
                Pair result = TempStatementUtil.handleTempStatement((String)sql, (KylinConfig)kylinConfig);
                boolean isCreateTempStatement = (Boolean)result.getFirst();
                sql = (String)result.getSecond();
                sqlRequest.setSql(sql);
                try (QueryRequestLimits limit = new QueryRequestLimits(sqlRequest.getProject());){
                    if (sqlResponse == null && isQueryInspect) {
                        sqlResponse = new SQLResponse(null, null, 0, false, sqlRequest.getSql());
                    }
                    if (sqlResponse == null && isCreateTempStatement) {
                        sqlResponse = new SQLResponse(null, null, 0, false, null);
                    }
                    if (sqlResponse == null && isQueryCacheEnabled) {
                        sqlResponse = this.searchQueryInCache(sqlRequest);
                    }
                    if (sqlResponse == null) {
                        sqlResponse = this.queryAndUpdateCache(sqlRequest, isQueryCacheEnabled);
                    }
                }
                sqlResponse.setDuration(queryContext.getAccumulatedMillis());
                if (QuerySparkMetrics.getInstance().getQueryExecutionMetrics(queryContext.getQueryId()) != null) {
                    String sqlTraceUrl = SparderContext.appMasterTrackURL() + "/SQL/execution/?id=" + QuerySparkMetrics.getInstance().getQueryExecutionMetrics(queryContext.getQueryId()).getExecutionId();
                    sqlResponse.setTraceUrl(sqlTraceUrl);
                }
                this.logQuery(queryContext.getQueryId(), sqlRequest, sqlResponse);
                try {
                    this.recordMetric(queryContext.getQueryId(), sqlRequest, sqlResponse);
                }
                catch (Throwable th) {
                    logger.warn("Write metric error.", th);
                }
                if (sqlResponse.getIsException()) {
                    throw new InternalErrorException(sqlResponse.getExceptionMessage(), sqlResponse.getThrowable());
                }
                SQLResponse sQLResponse = sqlResponse;
                return sQLResponse;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            BackdoorToggles.cleanToggles();
            QueryContextFacade.resetCurrent();
            QueryInfoCollector.reset();
        }
    }

    private SQLResponse queryAndUpdateCache(SQLRequest sqlRequest, boolean queryCacheEnabled) {
        SQLResponse sqlResponse;
        block12: {
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            Message msg = MsgPicker.getMsg();
            QueryContext queryContext = QueryContextFacade.current();
            boolean isDummyResponseEnabled = queryCacheEnabled && kylinConfig.isLazyQueryEnabled();
            sqlResponse = null;
            try {
                boolean isSelect;
                if (isDummyResponseEnabled) {
                    SQLResponse dummyResponse = new SQLResponse();
                    dummyResponse.setLazyQueryStartTime(System.currentTimeMillis());
                    this.cacheManager.getCache(QUERY_CACHE).put(sqlRequest.getCacheKey(), (Object)dummyResponse);
                }
                if (isSelect = QueryUtil.isSelectStatement((String)sqlRequest.getSql())) {
                    sqlResponse = this.query(sqlRequest, queryContext.getQueryId());
                } else if (kylinConfig.isPushDownEnabled() && kylinConfig.isPushDownUpdateEnabled()) {
                    sqlResponse = this.update(sqlRequest);
                } else {
                    logger.debug("Directly return exception as the sql is unsupported, and query pushdown is disabled");
                    throw new BadRequestException(msg.getNOT_SUPPORTED_SQL());
                }
                long durationThreshold = kylinConfig.getQueryDurationCacheThreshold();
                long scanCountThreshold = kylinConfig.getQueryScanCountCacheThreshold();
                long scanBytesThreshold = kylinConfig.getQueryScanBytesCacheThreshold();
                sqlResponse.setDuration(queryContext.getAccumulatedMillis());
                logger.info("Stats of SQL response: isException: {}, duration: {}, total scan count {}", new Object[]{String.valueOf(sqlResponse.getIsException()), String.valueOf(sqlResponse.getDuration()), String.valueOf(sqlResponse.getTotalScanCount())});
                boolean realtimeQuery = false;
                Collection olapContexts = OLAPContext.getThreadLocalContexts();
                if (CheckUtil.checkCondition((boolean)queryCacheEnabled, (String)"query cache is disabled", (Object[])new Object[0]) && CheckUtil.checkCondition((!Strings.isNullOrEmpty((String)sqlResponse.getCube()) ? 1 : 0) != 0, (String)"query does not hit cube nor hybrid", (Object[])new Object[0]) && CheckUtil.checkCondition((!sqlResponse.getIsException() ? 1 : 0) != 0, (String)"query has exception", (Object[])new Object[0]) && CheckUtil.checkCondition((!sqlResponse.isPushDown() || isSelect && kylinConfig.isPushdownQueryCacheEnabled() ? 1 : 0) != 0, (String)"query is executed with pushdown, but it is non-select, or the cache for pushdown is disabled", (Object[])new Object[0]) && CheckUtil.checkCondition((this.cacheManager.getCache(QUERY_CACHE) instanceof MemcachedCacheManager.MemCachedCacheAdaptor || sqlResponse.getDuration() > durationThreshold || sqlResponse.getTotalScanCount() > scanCountThreshold || sqlResponse.getTotalScanBytes() > scanBytesThreshold ? 1 : 0) != 0, (String)"query is too lightweight with duration: {} (threshold {}), scan count: {} (threshold {}), scan bytes: {} (threshold {})", (Object[])new Object[]{sqlResponse.getDuration(), durationThreshold, sqlResponse.getTotalScanCount(), scanCountThreshold, sqlResponse.getTotalScanBytes(), scanBytesThreshold}) && CheckUtil.checkCondition((sqlResponse.getResults().size() < kylinConfig.getLargeQueryThreshold() ? 1 : 0) != 0, (String)"query response is too large: {} ({})", (Object[])new Object[]{sqlResponse.getResults().size(), kylinConfig.getLargeQueryThreshold()})) {
                    if (!realtimeQuery) {
                        this.cacheManager.getCache(QUERY_CACHE).put(sqlRequest.getCacheKey(), (Object)sqlResponse);
                    }
                } else if (isDummyResponseEnabled) {
                    this.cacheManager.getCache(QUERY_CACHE).evict(sqlRequest.getCacheKey());
                }
            }
            catch (Throwable e) {
                queryContext.stop(e);
                logger.error("Exception while executing query", e);
                String errMsg = this.makeErrorMsgUserFriendly(e);
                sqlResponse = this.buildSqlResponse(sqlRequest.getProject(), false, null, null, true, errMsg);
                sqlResponse.setThrowable(e.getCause() == null ? e : ExceptionUtils.getRootCause((Throwable)e));
                if (queryCacheEnabled && e.getCause() != null && ExceptionUtils.getRootCause((Throwable)e) instanceof ResourceLimitExceededException) {
                    Cache exceptionCache = this.cacheManager.getCache(QUERY_CACHE);
                    exceptionCache.put(sqlRequest.getCacheKey(), (Object)sqlResponse);
                }
                if (!isDummyResponseEnabled) break block12;
                Cache exceptionCache = this.cacheManager.getCache(QUERY_CACHE);
                exceptionCache.evict(sqlRequest.getCacheKey());
            }
        }
        return sqlResponse;
    }

    private boolean isQueryCacheEnabled(KylinConfig kylinConfig) {
        return CheckUtil.checkCondition((boolean)kylinConfig.isQueryCacheEnabled(), (String)"query cache disabled in KylinConfig", (Object[])new Object[0]) && CheckUtil.checkCondition((!BackdoorToggles.getDisableCache() ? 1 : 0) != 0, (String)"query cache disabled in BackdoorToggles", (Object[])new Object[0]);
    }

    protected void recordMetric(String queryId, SQLRequest sqlRequest, SQLResponse sqlResponse) throws UnknownHostException {
        QueryMetricsFacade.updateMetrics(queryId, sqlRequest, sqlResponse);
        QueryMetrics2Facade.updateMetrics(sqlRequest, sqlResponse);
    }

    private String getUserName() {
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        if (StringUtils.isEmpty((String)username)) {
            username = "";
        }
        return username;
    }

    public SQLResponse searchQueryInCache(SQLRequest sqlRequest) {
        Cache cache = this.cacheManager.getCache(QUERY_CACHE);
        Cache.ValueWrapper wrapper = cache.get(sqlRequest.getCacheKey());
        if (wrapper == null) {
            return null;
        }
        SQLResponse response = (SQLResponse)wrapper.get();
        if (response == null) {
            return null;
        }
        while (response.isRunning()) {
            if (System.currentTimeMillis() - response.getLazyQueryStartTime() >= this.getConfig().getLazyQueryWaitingTimeoutMilliSeconds()) {
                cache.evict(sqlRequest.getCacheKey());
                return null;
            }
            logger.info("Duplicated SQL request is running, waiting...");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            wrapper = cache.get(sqlRequest.getCacheKey());
            if (wrapper == null) {
                return null;
            }
            response = (SQLResponse)wrapper.get();
            if (response != null) continue;
            return null;
        }
        logger.info("The sqlResponse is found in QUERY_CACHE");
        if (this.getConfig().isQueryCacheSignatureEnabled() && !SQLResponseSignatureUtil.checkSignature(this.getConfig(), response, sqlRequest.getProject())) {
            logger.info("The sql response signature is changed. Remove it from QUERY_CACHE.");
            cache.evict(sqlRequest.getCacheKey());
            return null;
        }
        if (response.getIsException()) {
            response.setHitExceptionCache(true);
        } else {
            response.setStorageCacheUsed(true);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLResponse queryWithSqlMassage(SQLRequest sqlRequest) throws Exception {
        SQLResponse sQLResponse;
        String correctedSql;
        PreparedContext preparedContext;
        PreparedContextKey preparedContextKey;
        boolean borrowPrepareContext;
        Connection conn;
        block36: {
            boolean isPrepareRequest;
            block35: {
                String userInfo;
                block34: {
                    Object grantedAuthority2;
                    conn = null;
                    isPrepareRequest = this.isPrepareStatementWithParams(sqlRequest);
                    borrowPrepareContext = false;
                    preparedContextKey = null;
                    preparedContext = null;
                    conn = QueryConnection.getConnection((String)sqlRequest.getProject());
                    userInfo = SecurityContextHolder.getContext().getAuthentication().getName();
                    QueryContext context = QueryContextFacade.current();
                    context.setUsername(userInfo);
                    context.setGroups(AclPermissionUtil.getCurrentUserGroups());
                    context.setProject(sqlRequest.getProject());
                    Collection grantedAuthorities = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
                    for (Object grantedAuthority2 : grantedAuthorities) {
                        userInfo = userInfo + ",";
                        userInfo = userInfo + grantedAuthority2.getAuthority();
                    }
                    SQLResponse fakeResponse = TableauInterceptor.tableauIntercept(sqlRequest.getSql());
                    if (null == fakeResponse) break block34;
                    logger.debug("Return fake response, is exception? " + fakeResponse.getIsException());
                    grantedAuthority2 = fakeResponse;
                    DBUtils.closeQuietly((Connection)conn);
                    if (preparedContext != null) {
                        if (borrowPrepareContext) {
                            for (OLAPContext olapContext : preparedContext.olapContexts) {
                                if (!borrowPrepareContext) continue;
                                olapContext.isBorrowedContext = true;
                            }
                            this.preparedContextPool.returnObject(preparedContextKey, (Object)preparedContext);
                        } else {
                            preparedContext.close();
                        }
                    }
                    return grantedAuthority2;
                }
                correctedSql = QueryUtil.massageSql((String)sqlRequest.getSql(), (String)sqlRequest.getProject(), (int)sqlRequest.getLimit(), (int)sqlRequest.getOffset(), (String)conn.getSchema(), (String)"defaultCatalog");
                if (!correctedSql.equals(sqlRequest.getSql())) {
                    logger.info("The corrected query: " + correctedSql);
                }
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("UserAuthenInfo", userInfo);
                parameters.put("AcceptPartialResult", String.valueOf(sqlRequest.isAcceptPartial()));
                OLAPContext.setParameters(parameters);
                ArrayList results = Lists.newArrayList();
                ArrayList columnMetas = Lists.newArrayList();
                if (!BackdoorToggles.getPrepareOnly()) break block35;
                SQLResponse sQLResponse2 = this.getPrepareOnlySqlResponse(sqlRequest.getProject(), correctedSql, conn, false, results, columnMetas);
                DBUtils.closeQuietly((Connection)conn);
                if (preparedContext != null) {
                    if (borrowPrepareContext) {
                        for (OLAPContext olapContext : preparedContext.olapContexts) {
                            if (!borrowPrepareContext) continue;
                            olapContext.isBorrowedContext = true;
                        }
                        this.preparedContextPool.returnObject((Object)preparedContextKey, (Object)preparedContext);
                    } else {
                        preparedContext.close();
                    }
                }
                return sQLResponse2;
            }
            if (isPrepareRequest) break block36;
            SQLResponse sQLResponse3 = this.executeRequest(correctedSql, sqlRequest, conn);
            DBUtils.closeQuietly((Connection)conn);
            if (preparedContext != null) {
                if (borrowPrepareContext) {
                    for (OLAPContext olapContext : preparedContext.olapContexts) {
                        if (!borrowPrepareContext) continue;
                        olapContext.isBorrowedContext = true;
                    }
                    this.preparedContextPool.returnObject((Object)preparedContextKey, (Object)preparedContext);
                } else {
                    preparedContext.close();
                }
            }
            return sQLResponse3;
        }
        try {
            long prjLastModifyTime = this.getProjectManager().getProject(sqlRequest.getProject()).getLastModified();
            preparedContextKey = new PreparedContextKey(sqlRequest.getProject(), prjLastModifyTime, correctedSql);
            PrepareSqlRequest prepareSqlRequest = (PrepareSqlRequest)sqlRequest;
            if (this.getConfig().isQueryPreparedStatementCacheEnable() && prepareSqlRequest.isEnableStatementCache()) {
                try {
                    preparedContext = (PreparedContext)this.preparedContextPool.borrowObject((Object)preparedContextKey);
                    if (preparedContext.olapRel == null) {
                        preparedContext.olapRel = QueryContextFacade.current().getOlapRel();
                        preparedContext.resultType = QueryContextFacade.current().getResultType();
                    } else {
                        QueryContextFacade.current().setOlapRel(preparedContext.olapRel);
                        QueryContextFacade.current().setResultType(preparedContext.resultType);
                    }
                    borrowPrepareContext = true;
                }
                catch (NoSuchElementException noElementException) {
                    borrowPrepareContext = false;
                    preparedContext = QueryService.createPreparedContext(sqlRequest.getProject(), sqlRequest.getSql());
                }
                for (OLAPContext olapContext : preparedContext.olapContexts) {
                    this.resetRealizationInContext(olapContext);
                    OLAPContext.registerContext((OLAPContext)olapContext);
                }
            } else {
                preparedContext = QueryService.createPreparedContext(sqlRequest.getProject(), sqlRequest.getSql());
            }
            sQLResponse = this.executePrepareRequest(correctedSql, prepareSqlRequest, preparedContext);
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly((Connection)conn);
            if (preparedContext != null) {
                if (borrowPrepareContext) {
                    for (OLAPContext olapContext : preparedContext.olapContexts) {
                        if (!borrowPrepareContext) continue;
                        olapContext.isBorrowedContext = true;
                    }
                    this.preparedContextPool.returnObject(preparedContextKey, (Object)preparedContext);
                } else {
                    preparedContext.close();
                }
            }
            throw throwable;
        }
        DBUtils.closeQuietly((Connection)conn);
        if (preparedContext != null) {
            if (borrowPrepareContext) {
                for (OLAPContext olapContext : preparedContext.olapContexts) {
                    if (!borrowPrepareContext) continue;
                    olapContext.isBorrowedContext = true;
                }
                this.preparedContextPool.returnObject((Object)preparedContextKey, (Object)preparedContext);
            } else {
                preparedContext.close();
            }
        }
        return sQLResponse;
    }

    private void resetRealizationInContext(OLAPContext olapContext) {
        IRealization realization = olapContext.realization;
        if (realization == null) {
            return;
        }
        KylinConfig config = this.getConfig();
        HybridInstance hybridInstance = HybridManager.getInstance((KylinConfig)config).getHybridInstance(realization.getName());
        if (hybridInstance != null) {
            olapContext.realization = hybridInstance;
            return;
        }
        CubeInstance cubeInstance = CubeManager.getInstance((KylinConfig)config).getCube(realization.getName());
        if (cubeInstance != null) {
            olapContext.realization = cubeInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TableMeta> getMetadata(CubeManager cubeMgr, String project) throws SQLException {
        Connection conn = null;
        ResultSet columnMeta = null;
        LinkedList<TableMeta> tableMetas = null;
        if (StringUtils.isBlank((String)project)) {
            return Collections.emptyList();
        }
        ResultSet JDBCTableMeta = null;
        try {
            String schemaName;
            String catalogName;
            conn = QueryConnection.getConnection((String)project);
            DatabaseMetaData metaData = conn.getMetaData();
            JDBCTableMeta = metaData.getTables(null, null, null, null);
            tableMetas = new LinkedList<TableMeta>();
            HashMap<String, TableMeta> tableMap = new HashMap<String, TableMeta>();
            while (JDBCTableMeta.next()) {
                catalogName = JDBCTableMeta.getString(1);
                TableMeta tblMeta = new TableMeta(catalogName == null ? "defaultCatalog" : catalogName, (schemaName = JDBCTableMeta.getString(2)) == null ? "defaultSchema" : schemaName, JDBCTableMeta.getString(3), JDBCTableMeta.getString(4), JDBCTableMeta.getString(5), null, null, null, null, null);
                if ("metadata".equalsIgnoreCase(tblMeta.getTABLE_SCHEM())) continue;
                tableMetas.add(tblMeta);
                tableMap.put(tblMeta.getTABLE_SCHEM() + "#" + tblMeta.getTABLE_NAME(), tblMeta);
            }
            columnMeta = metaData.getColumns(null, null, null, null);
            while (columnMeta.next()) {
                catalogName = columnMeta.getString(1);
                ColumnMeta colmnMeta = new ColumnMeta(catalogName == null ? "defaultCatalog" : catalogName, (schemaName = columnMeta.getString(2)) == null ? "defaultSchema" : schemaName, columnMeta.getString(3), columnMeta.getString(4), columnMeta.getInt(5), columnMeta.getString(6), columnMeta.getInt(7), this.getInt(columnMeta.getString(8)), columnMeta.getInt(9), columnMeta.getInt(10), columnMeta.getInt(11), columnMeta.getString(12), columnMeta.getString(13), this.getInt(columnMeta.getString(14)), this.getInt(columnMeta.getString(15)), columnMeta.getInt(16), columnMeta.getInt(17), columnMeta.getString(18), columnMeta.getString(19), columnMeta.getString(20), columnMeta.getString(21), this.getShort(columnMeta.getString(22)), columnMeta.getString(23));
                if ("metadata".equalsIgnoreCase(colmnMeta.getTABLE_SCHEM()) || colmnMeta.getCOLUMN_NAME().toUpperCase(Locale.ROOT).startsWith("_KY_")) continue;
                ((TableMeta)tableMap.get(colmnMeta.getTABLE_SCHEM() + "#" + colmnMeta.getTABLE_NAME())).addColumn(colmnMeta);
            }
        }
        catch (Throwable throwable) {
            QueryService.close(columnMeta, null, conn);
            if (JDBCTableMeta != null) {
                JDBCTableMeta.close();
            }
            throw throwable;
        }
        QueryService.close(columnMeta, null, conn);
        if (JDBCTableMeta != null) {
            JDBCTableMeta.close();
        }
        return tableMetas;
    }

    public List<TableMetaWithType> getMetadataV2(String project) throws SQLException, IOException {
        return this.getMetadataV2(this.getCubeManager(), project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TableMetaWithType> getMetadataV2(CubeManager cubeMgr, String project) throws SQLException, IOException {
        Connection conn = null;
        ResultSet columnMeta = null;
        LinkedList<TableMetaWithType> tableMetas = null;
        HashMap<String, TableMetaWithType> tableMap = null;
        HashMap<String, ColumnMetaWithType> columnMap = null;
        if (StringUtils.isBlank((String)project)) {
            return Collections.emptyList();
        }
        ResultSet JDBCTableMeta = null;
        try {
            String schemaName;
            String catalogName;
            conn = QueryConnection.getConnection((String)project);
            DatabaseMetaData metaData = conn.getMetaData();
            JDBCTableMeta = metaData.getTables(null, null, null, null);
            tableMetas = new LinkedList<TableMetaWithType>();
            tableMap = new HashMap<String, TableMetaWithType>();
            columnMap = new HashMap<String, ColumnMetaWithType>();
            while (JDBCTableMeta.next()) {
                catalogName = JDBCTableMeta.getString(1);
                TableMetaWithType tblMeta = new TableMetaWithType(catalogName == null ? "defaultCatalog" : catalogName, (schemaName = JDBCTableMeta.getString(2)) == null ? "defaultSchema" : schemaName, JDBCTableMeta.getString(3), JDBCTableMeta.getString(4), JDBCTableMeta.getString(5), null, null, null, null, null);
                if ("metadata".equalsIgnoreCase(tblMeta.getTABLE_SCHEM())) continue;
                tableMetas.add(tblMeta);
                tableMap.put(tblMeta.getTABLE_SCHEM() + "#" + tblMeta.getTABLE_NAME(), tblMeta);
            }
            columnMeta = metaData.getColumns(null, null, null, null);
            while (columnMeta.next()) {
                catalogName = columnMeta.getString(1);
                ColumnMetaWithType colmnMeta = new ColumnMetaWithType(catalogName == null ? "defaultCatalog" : catalogName, (schemaName = columnMeta.getString(2)) == null ? "defaultSchema" : schemaName, columnMeta.getString(3), columnMeta.getString(4), columnMeta.getInt(5), columnMeta.getString(6), columnMeta.getInt(7), this.getInt(columnMeta.getString(8)), columnMeta.getInt(9), columnMeta.getInt(10), columnMeta.getInt(11), columnMeta.getString(12), columnMeta.getString(13), this.getInt(columnMeta.getString(14)), this.getInt(columnMeta.getString(15)), columnMeta.getInt(16), columnMeta.getInt(17), columnMeta.getString(18), columnMeta.getString(19), columnMeta.getString(20), columnMeta.getString(21), this.getShort(columnMeta.getString(22)), columnMeta.getString(23));
                if ("metadata".equalsIgnoreCase(colmnMeta.getTABLE_SCHEM()) || colmnMeta.getCOLUMN_NAME().toUpperCase(Locale.ROOT).startsWith("_KY_")) continue;
                ((TableMetaWithType)tableMap.get(colmnMeta.getTABLE_SCHEM() + "#" + colmnMeta.getTABLE_NAME())).addColumn((ColumnMeta)colmnMeta);
                columnMap.put(colmnMeta.getTABLE_SCHEM() + "#" + colmnMeta.getTABLE_NAME() + "#" + colmnMeta.getCOLUMN_NAME(), colmnMeta);
            }
        }
        catch (Throwable throwable) {
            QueryService.close(columnMeta, null, conn);
            if (JDBCTableMeta != null) {
                JDBCTableMeta.close();
            }
            throw throwable;
        }
        QueryService.close(columnMeta, null, conn);
        if (JDBCTableMeta != null) {
            JDBCTableMeta.close();
        }
        ProjectInstance projectInstance = this.getProjectManager().getProject(project);
        for (String modelName : projectInstance.getModels()) {
            String[] measures;
            Object lookupTable2;
            DataModelDesc dataModelDesc = this.modelService.getModel(modelName, project);
            if (dataModelDesc == null || dataModelDesc.isDraft()) continue;
            for (TableRef factTable : dataModelDesc.getFactTables()) {
                String factTableName = factTable.getTableIdentity().replace('.', '#');
                if (!tableMap.containsKey(factTableName)) continue;
                ((TableMetaWithType)tableMap.get(factTableName)).getTYPE().add(TableMetaWithType.tableTypeEnum.FACT);
            }
            for (Object lookupTable2 : dataModelDesc.getLookupTables()) {
                String lookupTableName = lookupTable2.getTableIdentity().replace('.', '#');
                if (!tableMap.containsKey(lookupTableName)) continue;
                ((TableMetaWithType)tableMap.get(lookupTableName)).getTYPE().add(TableMetaWithType.tableTypeEnum.LOOKUP);
            }
            for (JoinTableDesc joinTableDesc : dataModelDesc.getJoinTables()) {
                String columnIdentity;
                JoinDesc joinDesc = joinTableDesc.getJoin();
                for (String pk : joinDesc.getPrimaryKey()) {
                    columnIdentity = (dataModelDesc.findTable(pk.substring(0, pk.indexOf("."))).getTableIdentity() + pk.substring(pk.indexOf("."))).replace('.', '#');
                    if (!columnMap.containsKey(columnIdentity)) continue;
                    ((ColumnMetaWithType)columnMap.get(columnIdentity)).getTYPE().add(ColumnMetaWithType.columnTypeEnum.PK);
                }
                for (String fk : joinDesc.getForeignKey()) {
                    columnIdentity = (dataModelDesc.findTable(fk.substring(0, fk.indexOf("."))).getTableIdentity() + fk.substring(fk.indexOf("."))).replace('.', '#');
                    if (!columnMap.containsKey(columnIdentity)) continue;
                    ((ColumnMetaWithType)columnMap.get(columnIdentity)).getTYPE().add(ColumnMetaWithType.columnTypeEnum.FK);
                }
            }
            List dimensions = dataModelDesc.getDimensions();
            lookupTable2 = dimensions.iterator();
            while (lookupTable2.hasNext()) {
                ModelDimensionDesc dimension = (ModelDimensionDesc)lookupTable2.next();
                for (String column : dimension.getColumns()) {
                    String columnIdentity = (dataModelDesc.findTable(dimension.getTable()).getTableIdentity() + "." + column).replace('.', '#');
                    if (!columnMap.containsKey(columnIdentity)) continue;
                    ((ColumnMetaWithType)columnMap.get(columnIdentity)).getTYPE().add(ColumnMetaWithType.columnTypeEnum.DIMENSION);
                }
            }
            for (String measure : measures = dataModelDesc.getMetrics()) {
                String columnIdentity = (dataModelDesc.findTable(measure.substring(0, measure.indexOf("."))).getTableIdentity() + measure.substring(measure.indexOf("."))).replace('.', '#');
                if (!columnMap.containsKey(columnIdentity)) continue;
                ((ColumnMetaWithType)columnMap.get(columnIdentity)).getTYPE().add(ColumnMetaWithType.columnTypeEnum.MEASURE);
            }
        }
        return tableMetas;
    }

    protected void processStatementAttr(Statement s, SQLRequest sqlRequest) throws SQLException {
        Integer statementMaxRows = BackdoorToggles.getStatementMaxRows();
        if (statementMaxRows != null) {
            logger.info("Setting current statement's max rows to {}", (Object)statementMaxRows);
            s.setMaxRows(statementMaxRows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLResponse executeRequest(String correctedSql, SQLRequest sqlRequest, Connection conn) throws Exception {
        Statement stat = null;
        ResultSet resultSet = null;
        boolean isPushDown = false;
        Pair<List<List<String>>, List<SelectedColumnMeta>> r = null;
        try {
            stat = conn.createStatement();
            this.processStatementAttr(stat, sqlRequest);
            resultSet = stat.executeQuery(correctedSql);
            r = this.createResponseFromResultSet(resultSet);
        }
        catch (SQLException sqlException) {
            try {
                r = this.pushDownQuery(sqlRequest, correctedSql, conn, sqlException);
                if (r == null) {
                    throw sqlException;
                }
                isPushDown = true;
            }
            catch (Throwable throwable) {
                QueryService.close(resultSet, stat, null);
                throw throwable;
            }
            QueryService.close(resultSet, stat, null);
        }
        QueryService.close(resultSet, stat, null);
        return this.buildSqlResponse(sqlRequest.getProject(), isPushDown, (List)r.getFirst(), (List)r.getSecond());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLResponse executePrepareRequest(String correctedSql, PrepareSqlRequest sqlRequest, PreparedContext preparedContext) throws Exception {
        ResultSet resultSet = null;
        boolean isPushDown = false;
        Pair<List<List<String>>, List<SelectedColumnMeta>> r = null;
        Connection conn = preparedContext.conn;
        try {
            PreparedStatement preparedStatement = preparedContext.preparedStatement;
            this.processStatementAttr(preparedStatement, sqlRequest);
            for (int i = 0; i < sqlRequest.getParams().length; ++i) {
                this.setParam(preparedStatement, i + 1, sqlRequest.getParams()[i]);
            }
            resultSet = preparedStatement.executeQuery();
            r = this.createResponseFromResultSet(resultSet);
            DBUtils.closeQuietly((ResultSet)resultSet);
        }
        catch (SQLException sqlException) {
            r = this.pushDownQuery(sqlRequest, correctedSql, conn, sqlException);
            if (r == null) {
                throw sqlException;
            }
            isPushDown = true;
        }
        finally {
            DBUtils.closeQuietly(resultSet);
        }
        return this.buildSqlResponse(sqlRequest.getProject(), isPushDown, (List)r.getFirst(), (List)r.getSecond());
    }

    private Pair<List<List<String>>, List<SelectedColumnMeta>> pushDownQuery(SQLRequest sqlRequest, String correctedSql, Connection conn, SQLException sqlException) throws Exception {
        try {
            return PushDownUtil.tryPushDownSelectQuery((String)sqlRequest.getProject(), (String)correctedSql, (String)conn.getSchema(), (SQLException)sqlException, (boolean)BackdoorToggles.getPrepareOnly());
        }
        catch (Exception e2) {
            logger.error("pushdown engine failed current query too", (Throwable)e2);
            throw e2;
        }
    }

    private Pair<List<List<String>>, List<SelectedColumnMeta>> createResponseFromResultSet(ResultSet resultSet) throws Exception {
        ArrayList results = Lists.newArrayList();
        ArrayList columnMetas = Lists.newArrayList();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            columnMetas.add(new SelectedColumnMeta(metaData.isAutoIncrement(i), metaData.isCaseSensitive(i), metaData.isSearchable(i), metaData.isCurrency(i), metaData.isNullable(i), metaData.isSigned(i), metaData.getColumnDisplaySize(i), metaData.getColumnLabel(i), metaData.getColumnName(i), metaData.getSchemaName(i), metaData.getCatalogName(i), metaData.getTableName(i), metaData.getPrecision(i), metaData.getScale(i), metaData.getColumnType(i), metaData.getColumnTypeName(i), metaData.isReadOnly(i), metaData.isWritable(i), metaData.isDefinitelyWritable(i)));
        }
        while (resultSet.next()) {
            ArrayList oneRow = Lists.newArrayListWithCapacity((int)columnCount);
            for (int i = 0; i < columnCount; ++i) {
                oneRow.add(resultSet.getString(i + 1));
            }
            results.add(oneRow);
        }
        return new Pair((Object)results, (Object)columnMetas);
    }

    protected String makeErrorMsgUserFriendly(Throwable e) {
        return QueryUtil.makeErrorMsgUserFriendly((Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLResponse getPrepareOnlySqlResponse(String projectName, String correctedSql, Connection conn, Boolean isPushDown, List<List<String>> results, List<SelectedColumnMeta> columnMetas) throws SQLException {
        CalcitePrepareImpl.KYLIN_ONLY_PREPARE.set(true);
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = conn.prepareStatement(correctedSql);
                throw new IllegalStateException("Should have thrown OnlyPrepareEarlyAbortException");
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause != null && rootCause instanceof OnlyPrepareEarlyAbortException) {
                    OnlyPrepareEarlyAbortException abortException = (OnlyPrepareEarlyAbortException)rootCause;
                    CalcitePrepare.Context context = abortException.getContext();
                    CalcitePrepare.ParseResult preparedResult = abortException.getPreparedResult();
                    List fieldList = preparedResult.rowType.getFieldList();
                    CalciteConnectionConfig config = context.config();
                    for (int i = 0; i < fieldList.size(); ++i) {
                        RelDataTypeField field = (RelDataTypeField)fieldList.get(i);
                        String columnName = (String)field.getKey();
                        if (columnName.startsWith("_KY_")) continue;
                        BasicSqlType basicSqlType = (BasicSqlType)field.getValue();
                        columnMetas.add(new SelectedColumnMeta(false, config.caseSensitive(), false, false, basicSqlType.isNullable() ? 1 : 0, true, basicSqlType.getPrecision(), columnName, columnName, null, null, null, basicSqlType.getPrecision(), basicSqlType.getScale() < 0 ? 0 : basicSqlType.getScale(), basicSqlType.getSqlTypeName().getJdbcOrdinal(), basicSqlType.getSqlTypeName().getName(), true, false, false));
                    }
                } else {
                    throw e;
                }
                CalcitePrepareImpl.KYLIN_ONLY_PREPARE.set(false);
                DBUtils.closeQuietly((Statement)preparedStatement);
            }
        }
        catch (Throwable throwable) {
            CalcitePrepareImpl.KYLIN_ONLY_PREPARE.set(false);
            DBUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        return this.buildSqlResponse(projectName, isPushDown, results, columnMetas);
    }

    private boolean isPrepareStatementWithParams(SQLRequest sqlRequest) {
        return sqlRequest instanceof PrepareSqlRequest && ((PrepareSqlRequest)sqlRequest).getParams() != null && ((PrepareSqlRequest)sqlRequest).getParams().length > 0;
    }

    private SQLResponse buildSqlResponse(String projectName, Boolean isPushDown, List<List<String>> results, List<SelectedColumnMeta> columnMetas) {
        return this.buildSqlResponse(projectName, isPushDown, results, columnMetas, false, null);
    }

    private SQLResponse buildSqlResponse(String projectName, Boolean isPushDown, List<List<String>> results, List<SelectedColumnMeta> columnMetas, boolean isException, String exceptionMessage) {
        boolean isPartialResult = false;
        LinkedList realizations = Lists.newLinkedList();
        StringBuilder cubeSb = new StringBuilder();
        StringBuilder cuboidIdsSb = new StringBuilder();
        StringBuilder realizationTypeSb = new StringBuilder();
        StringBuilder logSb = new StringBuilder("Processed rows for each storageContext: ");
        QueryContext queryContext = QueryContextFacade.current();
        if (OLAPContext.getThreadLocalContexts() != null) {
            for (OLAPContext ctx : OLAPContext.getThreadLocalContexts()) {
                String realizationName = "NULL";
                int realizationType = -1;
                if (ctx.realization == null) continue;
                isPartialResult |= ctx.storageContext.isPartialResultReturned();
                if (cubeSb.length() > 0) {
                    cubeSb.append(",");
                }
                cubeSb.append(ctx.realization.getCanonicalName());
                Cuboid cuboid = ctx.storageContext.getCuboid();
                if (cuboid != null) {
                    if (cuboidIdsSb.length() > 0) {
                        cuboidIdsSb.append(",");
                    }
                    cuboidIdsSb.append(cuboid.getId());
                }
                logSb.append(ctx.storageContext.getProcessedRowCount()).append(" ");
                realizationName = ctx.realization.getName();
                realizationType = ctx.realization.getStorageType();
                if (realizationTypeSb.length() > 0) {
                    realizationTypeSb.append(",");
                }
                realizationTypeSb.append(realizationType);
                realizations.add(realizationName);
            }
        }
        logger.info(logSb.toString());
        SQLResponse response = new SQLResponse(columnMetas, results, cubeSb.toString(), 0, isException, exceptionMessage, isPartialResult, isPushDown);
        response.setCuboidIds(cuboidIdsSb.toString());
        response.setRealizationTypes(realizationTypeSb.toString());
        response.setTotalScanCount(queryContext.getScannedRows());
        response.setTotalScanFiles(queryContext.getScanFiles() < 0L ? -1L : queryContext.getScanFiles());
        response.setMetadataTime(queryContext.getMedataTime() < 0L ? -1L : queryContext.getMedataTime());
        response.setTotalSparkScanTime(queryContext.getScanTime() < 0L ? -1L : queryContext.getScanTime());
        response.setTotalScanBytes(queryContext.getScannedBytes() < 1L ? (queryContext.getSourceScanBytes() < 1L ? -1L : queryContext.getSourceScanBytes()) : queryContext.getScannedBytes());
        response.setCubeSegmentStatisticsList(queryContext.getCubeSegmentStatisticsResultList());
        response.setSparkPool(queryContext.getSparkPool());
        if (this.getConfig().isQueryCacheSignatureEnabled()) {
            response.setSignature(SQLResponseSignatureUtil.createSignature(this.getConfig(), response, projectName));
        }
        return response;
    }

    private void setParam(PreparedStatement preparedState, int index, PrepareSqlRequest.StateParam param) throws SQLException {
        Class<?> clazz;
        boolean isNull = null == param.getValue();
        try {
            clazz = Class.forName(param.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new InternalErrorException(e);
        }
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of(clazz);
        switch (rep) {
            case PRIMITIVE_CHAR: 
            case CHARACTER: 
            case STRING: {
                preparedState.setString(index, isNull ? null : String.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_INT: 
            case INTEGER: {
                preparedState.setInt(index, isNull ? 0 : Integer.parseInt(param.getValue()));
                break;
            }
            case PRIMITIVE_SHORT: 
            case SHORT: {
                preparedState.setShort(index, isNull ? (short)0 : Short.parseShort(param.getValue()));
                break;
            }
            case PRIMITIVE_LONG: 
            case LONG: {
                preparedState.setLong(index, isNull ? 0L : Long.parseLong(param.getValue()));
                break;
            }
            case PRIMITIVE_FLOAT: 
            case FLOAT: {
                preparedState.setFloat(index, isNull ? 0.0f : Float.parseFloat(param.getValue()));
                break;
            }
            case PRIMITIVE_DOUBLE: 
            case DOUBLE: {
                preparedState.setDouble(index, isNull ? 0.0 : Double.parseDouble(param.getValue()));
                break;
            }
            case PRIMITIVE_BOOLEAN: 
            case BOOLEAN: {
                preparedState.setBoolean(index, !isNull && Boolean.parseBoolean(param.getValue()));
                break;
            }
            case PRIMITIVE_BYTE: 
            case BYTE: {
                preparedState.setByte(index, isNull ? (byte)0 : Byte.parseByte(param.getValue()));
                break;
            }
            case JAVA_UTIL_DATE: 
            case JAVA_SQL_DATE: {
                preparedState.setDate(index, isNull ? null : Date.valueOf(param.getValue()));
                break;
            }
            case JAVA_SQL_TIME: {
                preparedState.setTime(index, isNull ? null : Time.valueOf(param.getValue()));
                break;
            }
            case JAVA_SQL_TIMESTAMP: {
                preparedState.setTimestamp(index, isNull ? null : Timestamp.valueOf(param.getValue()));
                break;
            }
            default: {
                preparedState.setObject(index, isNull ? null : param.getValue());
            }
        }
    }

    protected int getInt(String content) {
        try {
            return Integer.parseInt(content);
        }
        catch (Exception e) {
            return -1;
        }
    }

    protected short getShort(String content) {
        try {
            return Short.parseShort(content);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private static PreparedContext createPreparedContext(String project, String sql) throws Exception {
        Connection conn = QueryConnection.getConnection((String)project);
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        Collection olapContexts = OLAPContext.getThreadLocalContexts();
        for (OLAPContext olapContext : olapContexts) {
            olapContext.isBorrowedContext = false;
        }
        return new PreparedContext(conn, preparedStatement, olapContexts);
    }

    private static class PreparedContext {
        private Connection conn;
        private PreparedStatement preparedStatement;
        private Collection<OLAPContext> olapContexts;
        private Object olapRel;
        private Object resultType;

        public PreparedContext(Connection conn, PreparedStatement preparedStatement, Collection<OLAPContext> olapContexts) {
            this.conn = conn;
            this.preparedStatement = preparedStatement;
            this.olapContexts = olapContexts;
        }

        public void close() {
            if (this.conn != null) {
                DBUtils.closeQuietly((Connection)this.conn);
            }
            if (this.preparedStatement != null) {
                DBUtils.closeQuietly((Statement)this.preparedStatement);
            }
        }
    }

    private static class PreparedContextKey {
        private String project;
        private long prjLastModifyTime;
        private String sql;

        public PreparedContextKey(String project, long prjLastModifyTime, String sql) {
            this.project = project;
            this.prjLastModifyTime = prjLastModifyTime;
            this.sql = sql;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PreparedContextKey that = (PreparedContextKey)o;
            if (this.prjLastModifyTime != that.prjLastModifyTime) {
                return false;
            }
            if (this.project != null ? !this.project.equals(that.project) : that.project != null) {
                return false;
            }
            return this.sql != null ? this.sql.equals(that.sql) : that.sql == null;
        }

        public int hashCode() {
            int result = this.project != null ? this.project.hashCode() : 0;
            result = 31 * result + (int)(this.prjLastModifyTime ^ this.prjLastModifyTime >>> 32);
            result = 31 * result + (this.sql != null ? this.sql.hashCode() : 0);
            return result;
        }
    }

    private static class PreparedContextFactory
    extends BaseKeyedPooledObjectFactory<PreparedContextKey, PreparedContext> {
        private PreparedContextFactory() {
        }

        public PreparedContext create(PreparedContextKey key) throws Exception {
            return QueryService.createPreparedContext(key.project, key.sql);
        }

        public PooledObject<PreparedContext> wrap(PreparedContext value) {
            return new DefaultPooledObject((Object)value);
        }

        public void destroyObject(PreparedContextKey key, PooledObject<PreparedContext> p) {
            PreparedContext cachedContext = (PreparedContext)p.getObject();
            cachedContext.close();
        }

        public boolean validateObject(PreparedContextKey key, PooledObject<PreparedContext> p) {
            return true;
        }
    }

    private static class QueryRecordSerializer
    implements Serializer<QueryRecord> {
        private static final QueryRecordSerializer serializer = new QueryRecordSerializer();

        QueryRecordSerializer() {
        }

        public static QueryRecordSerializer getInstance() {
            return serializer;
        }

        public void serialize(QueryRecord record, DataOutputStream out) throws IOException {
            String jsonStr = JsonUtil.writeValueAsString((Object)((Object)record));
            out.writeUTF(jsonStr);
        }

        public QueryRecord deserialize(DataInputStream in) throws IOException {
            String jsonStr = in.readUTF();
            return (QueryRecord)((Object)JsonUtil.readValue((String)jsonStr, QueryRecord.class));
        }
    }
}

