/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.request.AccessRequest;
import org.apache.kylin.rest.response.AccessEntryResponse;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.security.AclPermissionFactory;
import org.apache.kylin.rest.security.ExternalAclProvider;
import org.apache.kylin.rest.security.springacl.MutableAclRecord;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.TableACLService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.rest.util.ValidateUtil;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/access"})
public class AccessController
extends BasicController
implements InitializingBean {
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="projectService")
    private ProjectService projectService;
    @Autowired
    @Qualifier(value="TableAclService")
    private TableACLService tableACLService;
    @Autowired
    @Qualifier(value="userService")
    private UserService userService;
    @Autowired
    @Qualifier(value="validateUtil")
    private ValidateUtil validateUtil;

    public void afterPropertiesSet() throws Exception {
        ExternalAclProvider.getInstance();
    }

    @RequestMapping(value={"/user/permission/{project}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getUserPermissionInPrj(@PathVariable(value="project") String project) {
        return this.accessService.getUserPermissionInPrj(project);
    }

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<AccessEntryResponse> getAccessEntities(@PathVariable String type, @PathVariable String uuid) throws IOException {
        ExternalAclProvider eap = ExternalAclProvider.getInstance();
        if (eap != null) {
            ArrayList<AccessEntryResponse> ret = new ArrayList<AccessEntryResponse>();
            List<Pair<String, AclPermission>> acl = eap.getAcl(type, uuid);
            if (acl != null) {
                for (Pair<String, AclPermission> pair : acl) {
                    PrincipalSid sid = new PrincipalSid((String)pair.getFirst());
                    ret.add(new AccessEntryResponse(null, (Sid)sid, (Permission)pair.getSecond(), true));
                }
            } else {
                for (UserDetails userDetails : this.userService.listUsers()) {
                    PrincipalSid sid = new PrincipalSid(userDetails.getUsername());
                    List<String> authorities = AclPermissionUtil.transformAuthorities(userDetails.getAuthorities());
                    for (Permission p : AclPermissionFactory.getPermissions()) {
                        if (!eap.checkPermission(userDetails.getUsername(), authorities, type, uuid, p)) continue;
                        ret.add(new AccessEntryResponse(null, (Sid)sid, p, true));
                    }
                }
            }
            return ret;
        }
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        MutableAclRecord acl = this.accessService.getAcl((AclEntity)ae);
        return this.accessService.generateAceResponses(acl);
    }

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public List<AccessEntryResponse> grant(@PathVariable String type, @PathVariable String uuid, @RequestBody AccessRequest accessRequest) throws IOException {
        boolean isPrincipal = accessRequest.isPrincipal();
        String name = accessRequest.getSid();
        this.validateUtil.checkIdentifiersExists(name, isPrincipal);
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        Sid sid = this.accessService.getSid(name, isPrincipal);
        Permission permission = AclPermissionFactory.getPermission(accessRequest.getPermission());
        MutableAclRecord acl = this.accessService.grant((AclEntity)ae, permission, sid);
        return this.accessService.generateAceResponses(acl);
    }

    @RequestMapping(value={"batch/{type}/{uuid}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public void batchGrant(@PathVariable String type, @PathVariable String uuid, @RequestBody List<Object[]> reqs) throws IOException {
        HashMap<Sid, Permission> sidToPerm = new HashMap<Sid, Permission>();
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        for (Object[] req : reqs) {
            Preconditions.checkArgument((req.length == 3 ? 1 : 0) != 0, (Object)"error access requests.");
            String name = (String)req[0];
            boolean isPrincipal = (Boolean)req[1];
            this.validateUtil.checkIdentifiersExists(name, isPrincipal);
            Sid sid = this.accessService.getSid(name, isPrincipal);
            Permission permission = AclPermissionFactory.getPermission((String)req[2]);
            sidToPerm.put(sid, permission);
        }
        this.accessService.batchGrant((AclEntity)ae, sidToPerm);
    }

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public List<AccessEntryResponse> update(@PathVariable String type, @PathVariable String uuid, @RequestBody AccessRequest accessRequest) {
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        Permission permission = AclPermissionFactory.getPermission(accessRequest.getPermission());
        MutableAclRecord acl = this.accessService.update((AclEntity)ae, accessRequest.getAccessEntryId(), permission);
        return this.accessService.generateAceResponses(acl);
    }

    @RequestMapping(value={"/{type}/{uuid}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public List<AccessEntryResponse> revoke(@PathVariable String type, @PathVariable String uuid, AccessRequest accessRequest) throws IOException {
        RootPersistentEntity ae = this.accessService.getAclEntity(type, uuid);
        MutableAclRecord acl = this.accessService.revoke((AclEntity)ae, accessRequest.getAccessEntryId());
        if (accessRequest.isPrincipal()) {
            this.revokeTableACL(type, uuid, accessRequest.getSid(), "user");
        } else {
            this.revokeTableACL(type, uuid, accessRequest.getSid(), "group");
        }
        return this.accessService.generateAceResponses(acl);
    }

    private void revokeTableACL(String entityType, String uuid, String name, String identityType) throws IOException {
        String prj;
        if ("ProjectInstance".equals(entityType) && this.tableACLService.exists(prj = this.projectService.getProjectManager().getPrjByUuid(uuid).getName(), name, identityType)) {
            this.tableACLService.deleteFromTableACL(prj, name, identityType);
        }
    }

    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }
}

