/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.util.List;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.response.MetricsResponse;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.rest.service.DashboardService;
import org.apache.kylin.rest.service.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dashboard"})
public class DashboardController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(DashboardController.class);
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private QueryService queryService;
    @Autowired
    private CubeService cubeService;

    @RequestMapping(value={"/metric/cube"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsResponse getCubeMetrics(@RequestParam(value="projectName", required=false) String projectName, @RequestParam(value="cubeName", required=false) String cubeName) {
        this.checkAuthorization(projectName);
        return this.dashboardService.getCubeMetrics(projectName, cubeName);
    }

    @RequestMapping(value={"/metric/query"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsResponse getQueryMetrics(@RequestParam(value="projectName", required=false) String projectName, @RequestParam(value="cubeName", required=false) String cubeName, @RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        this.checkAuthorization(projectName);
        MetricsResponse queryMetrics = new MetricsResponse();
        String sql = this.dashboardService.getQueryMetricsSQL(startTime, endTime, projectName, cubeName);
        SQLResponse sqlResponse = this.queryService.querySystemCube(sql);
        if (!sqlResponse.getIsException()) {
            queryMetrics.increase("queryCount", this.dashboardService.getMetricValue(sqlResponse.getResults().get(0).get(0)));
            queryMetrics.increase("avgQueryLatency", this.dashboardService.getMetricValue(sqlResponse.getResults().get(0).get(1)));
            queryMetrics.increase("maxQueryLatency", this.dashboardService.getMetricValue(sqlResponse.getResults().get(0).get(2)));
            queryMetrics.increase("minQueryLatency", this.dashboardService.getMetricValue(sqlResponse.getResults().get(0).get(3)));
        }
        return queryMetrics;
    }

    @RequestMapping(value={"/metric/job"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsResponse getJobMetrics(@RequestParam(value="projectName", required=false) String projectName, @RequestParam(value="cubeName", required=false) String cubeName, @RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        this.checkAuthorization(projectName);
        MetricsResponse jobMetrics = new MetricsResponse();
        String sql = this.dashboardService.getJobMetricsSQL(startTime, endTime, projectName, cubeName);
        SQLResponse sqlResponse = this.queryService.querySystemCube(sql);
        if (!sqlResponse.getIsException()) {
            jobMetrics.increase("jobCount", this.dashboardService.getMetricValue(sqlResponse.getResults().get(0).get(0)));
            jobMetrics.increase("avgJobBuildTime", this.dashboardService.getMetricValue(sqlResponse.getResults().get(0).get(1)));
            jobMetrics.increase("maxJobBuildTime", this.dashboardService.getMetricValue(sqlResponse.getResults().get(0).get(2)));
            jobMetrics.increase("minJobBuildTime", this.dashboardService.getMetricValue(sqlResponse.getResults().get(0).get(3)));
        }
        return jobMetrics;
    }

    @RequestMapping(value={"/chart/{category}/{metric}/{dimension}"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsResponse getChartData(@PathVariable String dimension, @PathVariable String metric, @PathVariable String category, @RequestParam(value="projectName", required=false) String projectName, @RequestParam(value="cubeName", required=false) String cubeName, @RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        this.checkAuthorization(projectName);
        String sql = this.dashboardService.getChartSQL(startTime, endTime, projectName, cubeName, dimension, metric, category);
        return this.dashboardService.transformChartData(this.queryService.querySystemCube(sql));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAuthorization(String projectName) {
        if (projectName != null && !projectName.isEmpty()) {
            ProjectInstance project = this.dashboardService.getProjectManager().getProject(projectName);
            try {
                this.dashboardService.checkAuthorization(project);
                return;
            }
            catch (AccessDeniedException e) {
                List<CubeInstance> cubes = this.cubeService.listAllCubes(null, projectName, null, true);
                if (!cubes.isEmpty()) return;
                throw new AccessDeniedException("Access is denied");
            }
        } else {
            this.dashboardService.checkAuthorization();
        }
    }
}

