/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.acl.TableACL;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.querymeta.TableMeta;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="TableAclService")
public class TableACLService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(TableACLService.class);
    @Autowired
    private AclEvaluate aclEvaluate;

    private TableACL getTableACLByProject(String project) throws IOException {
        return this.getTableACLManager().getTableACLByCache(project);
    }

    public boolean exists(String project, String name, String type) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        return this.getTableACLByProject(project).contains(name, type);
    }

    public List<String> getNoAccessList(String project, String table, String type) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        return this.getTableACLByProject(project).getNoAccessList(table, type);
    }

    public List<String> getCanAccessList(String project, String table, Set<String> allIdentifiers, String type) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        return this.getTableACLByProject(project).getCanAccessList(table, allIdentifiers, type);
    }

    public void addToTableACL(String project, String name, String table, String type) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().addTableACL(project, name, table, type);
    }

    public void deleteFromTableACL(String project, String name, String table, String type) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().deleteTableACL(project, name, table, type);
    }

    public void deleteFromTableACL(String project, String name, String type) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().deleteTableACL(project, name, type);
    }

    public void deleteFromTableACLByTbl(String project, String table) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getTableACLManager().deleteTableACLByTbl(project, table);
    }

    public List<TableMeta> filterTableMetasByAcl(List<TableMeta> tableMeta, String project) throws IOException {
        return this.filterByAcl(tableMeta, project, new AclFilter<TableMeta>(){

            @Override
            public boolean filter(TableMeta table, Set<String> blockedTables) {
                String identity = table.getTABLE_SCHEM() + "." + table.getTABLE_NAME();
                return !blockedTables.contains(identity);
            }
        });
    }

    private <T> List<T> filterByAcl(List<T> tables, String project, AclFilter filter) throws IOException {
        ProjectManager projectManager = ProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        if (this.aclEvaluate.hasProjectAdminPermission(projectManager.getProject(project))) {
            return tables;
        }
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        Set<String> blockedTables = this.getBlockedTablesByUser(project, username, "user");
        ArrayList result = Lists.newArrayList();
        for (T table : tables) {
            if (!filter.filter(table, blockedTables)) continue;
            result.add(table);
        }
        return result;
    }

    private Set<String> getBlockedTablesByUser(String project, String username, String type) throws IOException {
        return this.getTableACLByProject(project).getBlockedTablesByUser(username, type);
    }

    private static interface AclFilter<T> {
        public boolean filter(T var1, Set<String> var2);
    }
}

