/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.job.dao.ExecutableDao;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.execution.ExecutableState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCleanupJob {
    private static final Logger logger = LoggerFactory.getLogger(MetadataCleanupJob.class);
    private static final long NEW_RESOURCE_THREADSHOLD_MS = 43200000L;
    final KylinConfig config;
    private List<String> garbageResources = Collections.emptyList();

    public MetadataCleanupJob() {
        this(KylinConfig.getInstanceFromEnv());
    }

    public MetadataCleanupJob(KylinConfig config) {
        this.config = config;
    }

    public List<String> getGarbageResources() {
        return this.garbageResources;
    }

    public List<String> cleanup(boolean delete, int jobOutdatedDays) throws Exception {
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)this.config);
        ResourceStore store = ResourceStore.getStore((KylinConfig)this.config);
        long newResourceTimeCut = System.currentTimeMillis() - 43200000L;
        ArrayList toDeleteCandidates = Lists.newArrayList();
        for (String resourceRoot : new String[]{"/table_snapshot", "/cube_statistics", "/ext_table_snapshot"}) {
            for (String dir : this.noNull(store.listResources(resourceRoot))) {
                for (String res : this.noNull(store.listResources(dir))) {
                    if (store.getResourceTimestamp(res) >= newResourceTimeCut) continue;
                    toDeleteCandidates.add(res);
                }
            }
        }
        for (String resourceRoot : new String[]{"/dict"}) {
            for (String dir : this.noNull(store.listResources(resourceRoot))) {
                for (String dir2 : this.noNull(store.listResources(dir))) {
                    for (String res : this.noNull(store.listResources(dir2))) {
                        if (store.getResourceTimestamp(res) >= newResourceTimeCut) continue;
                        toDeleteCandidates.add(res);
                    }
                }
            }
        }
        HashSet activeResources = Sets.newHashSet();
        for (CubeInstance cube : cubeManager.listAllCubes()) {
            activeResources.addAll(cube.getSnapshots().values());
            for (CubeSegment segment : cube.getSegments()) {
                activeResources.addAll(segment.getSnapshotPaths());
                activeResources.addAll(segment.getDictionaryPaths());
                activeResources.add(segment.getStatisticsResourcePath());
            }
        }
        toDeleteCandidates.removeAll(activeResources);
        long outdatedJobTimeCut = System.currentTimeMillis() - (long)(jobOutdatedDays * 24 * 3600) * 1000L;
        ExecutableDao executableDao = ExecutableDao.getInstance((KylinConfig)this.config);
        List allExecutable = executableDao.getJobs();
        for (ExecutablePO executable : allExecutable) {
            long lastModified = executable.getLastModified();
            String jobStatus = executableDao.getJobOutput(executable.getUuid()).getStatus();
            if (lastModified >= outdatedJobTimeCut || !ExecutableState.SUCCEED.toString().equals(jobStatus) && !ExecutableState.DISCARDED.toString().equals(jobStatus)) continue;
            toDeleteCandidates.add("/execute/" + executable.getUuid());
            toDeleteCandidates.add("/execute_output/" + executable.getUuid());
            for (ExecutablePO task : executable.getTasks()) {
                toDeleteCandidates.add("/execute_output/" + task.getUuid());
            }
        }
        this.garbageResources = this.cleanupConclude(delete, toDeleteCandidates);
        return this.garbageResources;
    }

    private List<String> cleanupConclude(boolean delete, List<String> toDeleteResources) {
        if (toDeleteResources.isEmpty()) {
            logger.info("No metadata resource to clean up");
            return toDeleteResources;
        }
        logger.info(toDeleteResources.size() + " metadata resource to clean up");
        if (delete) {
            ResourceStore store = ResourceStore.getStore((KylinConfig)this.config);
            for (String res : toDeleteResources) {
                logger.info("Deleting metadata " + res);
                try {
                    store.deleteResource(res);
                }
                catch (IOException e) {
                    logger.error("Failed to delete resource " + res, (Throwable)e);
                }
            }
        } else {
            for (String res : toDeleteResources) {
                logger.info("Dry run, pending delete metadata " + res);
            }
        }
        return toDeleteResources;
    }

    private NavigableSet<String> noNull(NavigableSet<String> list) {
        return list == null ? new TreeSet() : list;
    }
}

