/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.streaming.StreamingConfig;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.response.TableDescResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.KafkaConfigService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.StreamingService;
import org.apache.kylin.rest.service.TableSchemaUpdateChecker;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceFactory;
import org.apache.kylin.source.hive.cardinality.HiveColumnCardinalityJob;
import org.apache.kylin.source.hive.cardinality.HiveColumnCardinalityUpdateJob;
import org.apache.kylin.source.kafka.config.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="tableService")
public class TableService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(TableService.class);
    @Autowired
    @Qualifier(value="modelMgmtService")
    private ModelService modelService;
    @Autowired
    @Qualifier(value="streamingMgmtService")
    private StreamingService streamingService;
    @Autowired
    @Qualifier(value="kafkaMgmtService")
    private KafkaConfigService kafkaConfigService;
    @Autowired
    private AclEvaluate aclEvaluate;

    public List<TableDesc> getTableDescByProject(String project, boolean withExt) throws IOException {
        this.aclEvaluate.checkProjectReadPermission(project);
        List<TableDesc> tables = this.getProjectManager().listDefinedTables(project);
        if (null == tables) {
            return Collections.emptyList();
        }
        if (withExt) {
            this.aclEvaluate.checkProjectWritePermission(project);
            tables = this.cloneTableDesc(tables, project);
        }
        return tables;
    }

    public TableDesc getTableDescByName(String tableName, boolean withExt, String prj) {
        this.aclEvaluate.checkProjectReadPermission(prj);
        TableDesc table = this.getTableManager().getTableDesc(tableName, prj);
        if (withExt) {
            this.aclEvaluate.checkProjectWritePermission(prj);
            table = this.cloneTableDesc(table, prj);
        }
        return table;
    }

    public String[] loadHiveTablesToProject(String[] tables, String project) throws Exception {
        this.aclEvaluate.checkProjectAdminPermission(project);
        List<Pair<TableDesc, TableExtDesc>> allMeta = this.getAllMeta(tables, project);
        return this.loadHiveTablesToProject(project, allMeta);
    }

    String[] loadHiveTablesToProject(String project, List<Pair<TableDesc, TableExtDesc>> allMeta) throws Exception {
        TableMetadataManager metaMgr = this.getTableManager();
        CubeManager cubeMgr = this.getCubeManager();
        TableSchemaUpdateChecker checker = new TableSchemaUpdateChecker(metaMgr, cubeMgr);
        for (Pair<TableDesc, TableExtDesc> pair : allMeta) {
            TableDesc tableDesc = (TableDesc)pair.getFirst();
            TableSchemaUpdateChecker.CheckResult result = checker.allowReload(tableDesc, project);
            result.raiseExceptionWhenInvalid();
        }
        ArrayList saved = Lists.newArrayList();
        for (Pair<TableDesc, TableExtDesc> pair : allMeta) {
            TableDesc tableDesc = (TableDesc)pair.getFirst();
            TableExtDesc extDesc = (TableExtDesc)pair.getSecond();
            TableDesc origTable = metaMgr.getTableDesc(tableDesc.getIdentity(), project);
            if (origTable == null || origTable.getProject() == null) {
                tableDesc.setUuid(UUID.randomUUID().toString());
                tableDesc.setLastModified(0L);
            } else {
                tableDesc.setUuid(origTable.getUuid());
                tableDesc.setLastModified(origTable.getLastModified());
            }
            metaMgr.saveSourceTable(tableDesc, project);
            TableExtDesc origExt = metaMgr.getTableExt(tableDesc.getIdentity(), project);
            if (origExt == null || origExt.getProject() == null) {
                extDesc.setUuid(UUID.randomUUID().toString());
                extDesc.setLastModified(0L);
            } else {
                extDesc.setUuid(origExt.getUuid());
                extDesc.setLastModified(origExt.getLastModified());
            }
            extDesc.init(project);
            metaMgr.saveTableExt(extDesc, project);
            saved.add(tableDesc.getIdentity());
        }
        String[] result = saved.toArray(new String[saved.size()]);
        this.addTableToProject(result, project);
        return result;
    }

    private List<Pair<TableDesc, TableExtDesc>> getAllMeta(String[] tables, String project) throws Exception {
        LinkedHashMultimap db2tables = LinkedHashMultimap.create();
        for (String fullTableName : tables) {
            String[] parts = HadoopUtil.parseHiveTableName((String)fullTableName);
            db2tables.put((Object)parts[0], (Object)parts[1]);
        }
        ArrayList allMeta = Lists.newArrayList();
        ISourceMetadataExplorer explr = SourceFactory.getDefaultSource().getSourceMetadataExplorer();
        for (Map.Entry entry : db2tables.entries()) {
            Pair pair = explr.loadTableMetadata((String)entry.getKey(), (String)entry.getValue(), project);
            TableDesc tableDesc = (TableDesc)pair.getFirst();
            Preconditions.checkState((boolean)tableDesc.getDatabase().equals(((String)entry.getKey()).toUpperCase()));
            Preconditions.checkState((boolean)tableDesc.getName().equals(((String)entry.getValue()).toUpperCase()));
            Preconditions.checkState((boolean)tableDesc.getIdentity().equals(((String)entry.getKey()).toUpperCase() + "." + ((String)entry.getValue()).toUpperCase()));
            TableExtDesc extDesc = (TableExtDesc)pair.getSecond();
            Preconditions.checkState((boolean)tableDesc.getIdentity().equals(extDesc.getIdentity()));
            allMeta.add(pair);
        }
        return allMeta;
    }

    public Map<String, String[]> loadHiveTables(String[] tableNames, String project, boolean isNeedProfile) throws Exception {
        this.aclEvaluate.checkProjectAdminPermission(project);
        String submitter = SecurityContextHolder.getContext().getAuthentication().getName();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        String[] loaded = this.loadHiveTablesToProject(tableNames, project);
        result.put("result.loaded", loaded);
        HashSet<String> allTables = new HashSet<String>();
        for (String tableName : tableNames) {
            allTables.add(this.normalizeHiveTableName(tableName));
        }
        for (String loadedTableName : loaded) {
            allTables.remove(loadedTableName);
        }
        String[] unloaded = new String[allTables.size()];
        allTables.toArray(unloaded);
        result.put("result.unloaded", unloaded);
        if (isNeedProfile) {
            this.calculateCardinalityIfNotPresent(loaded, submitter, project);
        }
        return result;
    }

    public Map<String, String[]> unloadHiveTables(String[] tableNames, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        HashSet unLoadSuccess = Sets.newHashSet();
        HashSet unLoadFail = Sets.newHashSet();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String tableName : tableNames) {
            if (this.unloadHiveTable(tableName, project)) {
                unLoadSuccess.add(tableName);
                continue;
            }
            unLoadFail.add(tableName);
        }
        result.put("result.unload.success", unLoadSuccess.toArray(new String[unLoadSuccess.size()]));
        result.put("result.unload.fail", unLoadFail.toArray(new String[unLoadFail.size()]));
        return result;
    }

    private void addTableToProject(String[] tables, String project) throws IOException {
        this.getProjectManager().addTableDescToProject(tables, project);
    }

    protected void removeTableFromProject(String tableName, String projectName) throws IOException {
        tableName = this.normalizeHiveTableName(tableName);
        this.getProjectManager().removeTableDescFromProject(tableName, projectName);
    }

    public boolean unloadHiveTable(String tableName, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        Message msg = MsgPicker.getMsg();
        boolean rtn = false;
        int tableType = 0;
        tableName = this.normalizeHiveTableName(tableName);
        TableDesc desc = this.getTableManager().getTableDesc(tableName, project);
        if (desc == null || desc.getProject() == null) {
            logger.warn("Unload Table {} in Project {} failed, could not find TableDesc or related Project", (Object)tableName, (Object)project);
            return false;
        }
        tableType = desc.getSourceType();
        if (this.modelService.isTableInModel(desc, project)) {
            List<String> models = this.modelService.getModelsUsingTable(desc, project);
            throw new BadRequestException(String.format(msg.getTABLE_IN_USE_BY_MODEL(), models));
        }
        this.removeTableFromProject(tableName, project);
        rtn = true;
        TableMetadataManager metaMgr = this.getTableManager();
        metaMgr.removeTableExt(tableName, project);
        metaMgr.removeSourceTable(tableName, project);
        if (tableType == 1) {
            StreamingConfig config = null;
            KafkaConfig kafkaConfig = null;
            try {
                config = this.streamingService.getStreamingManager().getStreamingConfig(tableName);
                kafkaConfig = this.kafkaConfigService.getKafkaConfig(tableName, project);
                this.streamingService.dropStreamingConfig(config, project);
                this.kafkaConfigService.dropKafkaConfig(kafkaConfig, project);
                rtn = true;
            }
            catch (Exception e) {
                rtn = false;
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return rtn;
    }

    public void addStreamingTable(TableDesc desc, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        desc.setUuid(UUID.randomUUID().toString());
        this.getTableManager().saveSourceTable(desc, project);
        this.addTableToProject(new String[]{desc.getIdentity()}, project);
    }

    public List<String> getHiveDbNames() throws Exception {
        ISourceMetadataExplorer explr = SourceFactory.getDefaultSource().getSourceMetadataExplorer();
        return explr.listDatabases();
    }

    public List<String> getHiveTableNames(String database) throws Exception {
        ISourceMetadataExplorer explr = SourceFactory.getDefaultSource().getSourceMetadataExplorer();
        List hiveTableNames = explr.listTables(database);
        Iterable kylinApplicationTableNames = Iterables.filter((Iterable)hiveTableNames, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return input != null && !input.startsWith("kylin_intermediate_");
            }
        });
        return Lists.newArrayList((Iterable)kylinApplicationTableNames);
    }

    private TableDescResponse cloneTableDesc(TableDesc table, String prj) {
        TableExtDesc tableExtDesc = this.getTableManager().getTableExt(table.getIdentity(), prj);
        TableDescResponse rtableDesc = new TableDescResponse(table);
        HashMap<String, Long> cardinality = new HashMap<String, Long>();
        HashMap<String, String> dataSourceProp = new HashMap<String, String>();
        String scard = tableExtDesc.getCardinality();
        if (!StringUtils.isEmpty((String)scard)) {
            String[] cards = StringUtils.split((String)scard, (String)",");
            ColumnDesc[] cdescs = rtableDesc.getColumns();
            for (int i = 0; i < cdescs.length; ++i) {
                ColumnDesc columnDesc = cdescs[i];
                if (cards.length <= i) {
                    logger.error("The result cardinality is not identical with hive table metadata, cardinality : " + scard + " column array length: " + cdescs.length);
                    break;
                }
                cardinality.put(columnDesc.getName(), Long.parseLong(cards[i]));
            }
            rtableDesc.setCardinality(cardinality);
        }
        dataSourceProp.putAll(tableExtDesc.getDataSourceProp());
        rtableDesc.setDescExd(dataSourceProp);
        return rtableDesc;
    }

    private List<TableDesc> cloneTableDesc(List<TableDesc> tables, String prj) throws IOException {
        ArrayList<TableDesc> descs = new ArrayList<TableDesc>();
        for (TableDesc table : tables) {
            TableDescResponse rtableDesc = this.cloneTableDesc(table, prj);
            descs.add(rtableDesc);
        }
        return descs;
    }

    public void calculateCardinalityIfNotPresent(String[] tables, String submitter, String prj) throws Exception {
        TableMetadataManager metaMgr = this.getTableManager();
        ExecutableManager exeMgt = ExecutableManager.getInstance((KylinConfig)this.getConfig());
        for (String table : tables) {
            TableExtDesc tableExtDesc = metaMgr.getTableExt(table, prj);
            String jobID = tableExtDesc.getJodID();
            if (null != jobID && ExecutableState.RUNNING == exeMgt.getOutput(jobID).getState()) continue;
            this.calculateCardinality(table, submitter, prj);
        }
    }

    public void calculateCardinality(String tableName, String submitter, String prj) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(prj);
        Message msg = MsgPicker.getMsg();
        tableName = this.normalizeHiveTableName(tableName);
        TableDesc table = this.getTableManager().getTableDesc(tableName, prj);
        TableExtDesc tableExt = this.getTableManager().getTableExt(tableName, prj);
        if (table == null) {
            BadRequestException e = new BadRequestException(String.format(msg.getTABLE_DESC_NOT_FOUND(), tableName));
            logger.error("Cannot find table descriptor " + tableName, (Throwable)e);
            throw e;
        }
        DefaultChainedExecutable job = new DefaultChainedExecutable();
        job.setParam("segmentId", tableName);
        job.setName("Hive Column Cardinality calculation for table '" + tableName + "'");
        job.setSubmitter(submitter);
        String outPath = this.getConfig().getHdfsWorkingDirectory() + "cardinality/" + job.getId() + "/" + tableName;
        String param = "-table " + tableName + " -output " + outPath + " -project " + prj;
        MapReduceExecutable step1 = new MapReduceExecutable();
        step1.setMapReduceJobClass(HiveColumnCardinalityJob.class);
        step1.setMapReduceParams(param);
        step1.setParam("segmentId", tableName);
        job.addTask((AbstractExecutable)step1);
        HadoopShellExecutable step2 = new HadoopShellExecutable();
        step2.setJobClass(HiveColumnCardinalityUpdateJob.class);
        step2.setJobParams(param);
        step2.setParam("segmentId", tableName);
        job.addTask((AbstractExecutable)step2);
        tableExt.setJodID(job.getId());
        this.getTableManager().saveTableExt(tableExt, prj);
        this.getExecutableManager().addJob((AbstractExecutable)job);
    }

    public String normalizeHiveTableName(String tableName) {
        String[] dbTableName = HadoopUtil.parseHiveTableName((String)tableName);
        return (dbTableName[0] + "." + dbTableName[1]).toUpperCase();
    }
}

