/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.source.kafka.config.KafkaConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="kafkaMgmtService")
public class KafkaConfigService
extends BasicService {
    @Autowired
    private AclEvaluate aclEvaluate;

    public List<KafkaConfig> listAllKafkaConfigs(String kafkaConfigName) throws IOException {
        ArrayList<KafkaConfig> kafkaConfigs = new ArrayList();
        if (null == kafkaConfigName) {
            kafkaConfigs = this.getKafkaManager().listAllKafkaConfigs();
        } else {
            List configs = this.getKafkaManager().listAllKafkaConfigs();
            for (KafkaConfig config : configs) {
                if (!kafkaConfigName.equals(config.getName())) continue;
                kafkaConfigs.add(config);
            }
        }
        return kafkaConfigs;
    }

    public List<KafkaConfig> getKafkaConfigs(String kafkaConfigName, String project, Integer limit, Integer offset) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        List<KafkaConfig> kafkaConfigs = this.listAllKafkaConfigs(kafkaConfigName);
        if (limit == null || offset == null) {
            return kafkaConfigs;
        }
        if (kafkaConfigs.size() - offset < limit) {
            return kafkaConfigs.subList(offset, kafkaConfigs.size());
        }
        return kafkaConfigs.subList(offset, offset + limit);
    }

    public KafkaConfig createKafkaConfig(KafkaConfig config, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        Message msg = MsgPicker.getMsg();
        if (this.getKafkaManager().getKafkaConfig(config.getName()) != null) {
            throw new BadRequestException(String.format(msg.getKAFKA_CONFIG_ALREADY_EXIST(), config.getName()));
        }
        this.getKafkaManager().createKafkaConfig(config);
        return config;
    }

    public KafkaConfig updateKafkaConfig(KafkaConfig config, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        return this.getKafkaManager().updateKafkaConfig(config);
    }

    public KafkaConfig getKafkaConfig(String configName, String project) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        return this.getKafkaManager().getKafkaConfig(configName);
    }

    public void dropKafkaConfig(KafkaConfig config, String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        this.getKafkaManager().removeKafkaConfig(config);
    }
}

