/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.service.AceInfo;
import org.apache.kylin.rest.service.AclRecord;
import org.apache.kylin.rest.service.DomainObjectInfo;
import org.apache.kylin.rest.service.SidInfo;
import org.apache.kylin.rest.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.acls.domain.AccessControlEntryImpl;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AclImpl;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.ChildrenExistException;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.util.FieldUtils;
import org.springframework.stereotype.Component;

@Component(value="aclService")
public class AclService
implements MutableAclService {
    private static final Logger logger = LoggerFactory.getLogger(AclService.class);
    private final Field fieldAces = FieldUtils.getField(AclImpl.class, (String)"aces");
    private final Field fieldAcl = FieldUtils.getField(AccessControlEntryImpl.class, (String)"acl");
    public static final String DIR_PREFIX = "/acl/";
    public static final Serializer<AclRecord> SERIALIZER = new JsonSerializer(AclRecord.class);
    @Autowired
    protected PermissionGrantingStrategy permissionGrantingStrategy;
    @Autowired
    protected PermissionFactory aclPermissionFactory;
    @Autowired
    protected AclAuthorizationStrategy aclAuthorizationStrategy;
    @Autowired
    protected AuditLogger auditLogger;
    protected ResourceStore aclStore;
    @Autowired
    @Qualifier(value="userService")
    protected UserService userService;

    public AclService() throws IOException {
        this.fieldAces.setAccessible(true);
        this.fieldAcl.setAccessible(true);
        this.aclStore = ResourceStore.getStore((KylinConfig)KylinConfig.getInstanceFromEnv());
    }

    public List<ObjectIdentity> findChildren(ObjectIdentity parentIdentity) {
        ArrayList<ObjectIdentity> oids = new ArrayList<ObjectIdentity>();
        try {
            List allAclRecords = this.aclStore.getAllResources(String.valueOf(DIR_PREFIX), AclRecord.class, SERIALIZER);
            for (AclRecord record : allAclRecords) {
                DomainObjectInfo parent = record.getParentDomainObjectInfo();
                if (parent == null || !parent.getId().equals(String.valueOf(parentIdentity.getIdentifier()))) continue;
                DomainObjectInfo child = record.getDomainObjectInfo();
                oids.add((ObjectIdentity)new ObjectIdentityImpl(child.getType(), (Serializable)((Object)child.getId())));
            }
            return oids;
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    public Acl readAclById(ObjectIdentity object) throws NotFoundException {
        Map<ObjectIdentity, Acl> aclsMap = this.readAclsById(Arrays.asList(object), null);
        return aclsMap.get(object);
    }

    public Acl readAclById(ObjectIdentity object, List<Sid> sids) throws NotFoundException {
        Message msg = MsgPicker.getMsg();
        Map<ObjectIdentity, Acl> aclsMap = this.readAclsById(Arrays.asList(object), sids);
        if (!aclsMap.containsKey(object)) {
            throw new BadRequestException(String.format(msg.getNO_ACL_ENTRY(), object));
        }
        return aclsMap.get(object);
    }

    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects) throws NotFoundException {
        return this.readAclsById(objects, null);
    }

    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> oids, List<Sid> sids) throws NotFoundException {
        Message msg = MsgPicker.getMsg();
        HashMap<ObjectIdentity, Acl> aclMaps = new HashMap<ObjectIdentity, Acl>();
        try {
            for (ObjectIdentity oid : oids) {
                AclRecord record = (AclRecord)this.aclStore.getResource(AclService.getQueryKeyById(String.valueOf(oid.getIdentifier())), AclRecord.class, SERIALIZER);
                if (record != null && record.getOwnerInfo() != null) {
                    SidInfo owner = record.getOwnerInfo();
                    PrincipalSid ownerSid = owner.isPrincipal() ? new PrincipalSid(owner.getSid()) : new GrantedAuthoritySid(owner.getSid());
                    boolean entriesInheriting = record.isEntriesInheriting();
                    Acl parentAcl = null;
                    DomainObjectInfo parent = record.getParentDomainObjectInfo();
                    if (parent != null) {
                        ObjectIdentityImpl parentObject = new ObjectIdentityImpl(parent.getType(), (Serializable)((Object)parent.getId()));
                        parentAcl = this.readAclById((ObjectIdentity)parentObject, null);
                    }
                    AclImpl acl = new AclImpl(oid, oid.getIdentifier(), this.aclAuthorizationStrategy, this.permissionGrantingStrategy, parentAcl, null, entriesInheriting, (Sid)ownerSid);
                    this.genAces(sids, record, acl);
                    aclMaps.put(oid, (Acl)acl);
                    continue;
                }
                throw new NotFoundException(String.format(msg.getACL_INFO_NOT_FOUND(), oid));
            }
            return aclMaps;
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    public MutableAcl createAcl(ObjectIdentity objectIdentity) throws AlreadyExistsException {
        Acl acl = null;
        try {
            acl = this.readAclById(objectIdentity);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (null != acl) {
            throw new AlreadyExistsException("ACL of " + objectIdentity + " exists!");
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        PrincipalSid sid = new PrincipalSid(auth);
        try {
            AclRecord record = new AclRecord(new DomainObjectInfo(objectIdentity), null, new SidInfo((Sid)sid), true, null);
            this.aclStore.putResource(AclService.getQueryKeyById(String.valueOf(objectIdentity.getIdentifier())), (RootPersistentEntity)record, 0L, SERIALIZER);
            logger.debug("ACL of " + objectIdentity + " created successfully.");
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
        return (MutableAcl)this.readAclById(objectIdentity);
    }

    public void deleteAcl(ObjectIdentity objectIdentity, boolean deleteChildren) throws ChildrenExistException {
        Message msg = MsgPicker.getMsg();
        try {
            List<ObjectIdentity> children = this.findChildren(objectIdentity);
            if (!deleteChildren && children.size() > 0) {
                throw new BadRequestException(String.format(msg.getIDENTITY_EXIST_CHILDREN(), objectIdentity));
            }
            for (ObjectIdentity oid : children) {
                this.deleteAcl(oid, deleteChildren);
            }
            this.aclStore.deleteResource(AclService.getQueryKeyById(String.valueOf(objectIdentity.getIdentifier())));
            logger.debug("ACL of " + objectIdentity + " deleted successfully.");
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    public MutableAcl updateAcl(MutableAcl mutableAcl) throws NotFoundException {
        Message msg = MsgPicker.getMsg();
        this.readAclById(mutableAcl.getObjectIdentity());
        try {
            String id = AclService.getQueryKeyById(String.valueOf(mutableAcl.getObjectIdentity().getIdentifier()));
            AclRecord record = (AclRecord)this.aclStore.getResource(id, AclRecord.class, SERIALIZER);
            if (mutableAcl.getParentAcl() != null) {
                record.setParentDomainObjectInfo(new DomainObjectInfo(mutableAcl.getParentAcl().getObjectIdentity()));
            }
            if (record.getAllAceInfo() == null) {
                record.setAllAceInfo(new HashMap<String, AceInfo>());
            }
            Map<String, AceInfo> allAceInfo = record.getAllAceInfo();
            allAceInfo.clear();
            for (AccessControlEntry ace : mutableAcl.getEntries()) {
                PrincipalSid psid;
                String userName;
                if (ace.getSid() instanceof PrincipalSid && !this.userService.userExists(userName = (psid = (PrincipalSid)ace.getSid()).getPrincipal())) {
                    logger.error("Grant project access error," + String.format(msg.getUSER_NOT_EXIST(), userName));
                }
                AceInfo aceInfo = new AceInfo(ace);
                allAceInfo.put(String.valueOf(aceInfo.getSidInfo().getSid()), aceInfo);
            }
            this.aclStore.putResourceWithoutCheck(id, (RootPersistentEntity)record, System.currentTimeMillis(), SERIALIZER);
            logger.debug("ACL of " + mutableAcl.getObjectIdentity() + " updated successfully.");
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
        return (MutableAcl)this.readAclById(mutableAcl.getObjectIdentity());
    }

    protected void genAces(List<Sid> sids, AclRecord record, AclImpl acl) throws JsonParseException, JsonMappingException, IOException {
        ArrayList<AceInfo> aceInfos = new ArrayList<AceInfo>();
        Map<String, AceInfo> allAceInfos = record.getAllAceInfo();
        if (allAceInfos != null) {
            if (sids != null) {
                for (Sid sid : sids) {
                    AceInfo aceInfo;
                    String sidName = null;
                    if (sid instanceof PrincipalSid) {
                        sidName = ((PrincipalSid)sid).getPrincipal();
                    } else if (sid instanceof GrantedAuthoritySid) {
                        sidName = ((GrantedAuthoritySid)sid).getGrantedAuthority();
                    }
                    if ((aceInfo = allAceInfos.get(sidName)) == null) continue;
                    aceInfos.add(aceInfo);
                }
            } else {
                aceInfos.addAll(allAceInfos.values());
            }
        }
        ArrayList<AccessControlEntry> newAces = new ArrayList<AccessControlEntry>();
        for (int i = 0; i < aceInfos.size(); ++i) {
            AceInfo aceInfo = (AceInfo)aceInfos.get(i);
            if (null == aceInfo) continue;
            PrincipalSid sid = aceInfo.getSidInfo().isPrincipal() ? new PrincipalSid(aceInfo.getSidInfo().getSid()) : new GrantedAuthoritySid(aceInfo.getSidInfo().getSid());
            AccessControlEntryImpl ace = new AccessControlEntryImpl((Serializable)Long.valueOf(i), (Acl)acl, (Sid)sid, this.aclPermissionFactory.buildFromMask(aceInfo.getPermissionMask()), true, false, false);
            newAces.add((AccessControlEntry)ace);
        }
        this.setAces(acl, newAces);
    }

    private void setAces(AclImpl acl, List<AccessControlEntry> aces) {
        try {
            this.fieldAces.set(acl, aces);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not set AclImpl entries", e);
        }
    }

    public static String getQueryKeyById(String id) {
        return DIR_PREFIX + id;
    }
}

