/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.model.Query;
import org.apache.kylin.rest.model.SelectedColumnMeta;
import org.apache.kylin.rest.model.TableMeta;
import org.apache.kylin.rest.request.MetaRequest;
import org.apache.kylin.rest.request.PrepareSqlRequest;
import org.apache.kylin.rest.request.SQLRequest;
import org.apache.kylin.rest.request.SaveSqlRequest;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.service.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

@Controller
public class QueryController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(QueryController.class);
    @Autowired
    private QueryService queryService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    @ResponseBody
    public SQLResponse query(@RequestBody SQLRequest sqlRequest) {
        return this.queryService.doQueryWithCache(sqlRequest);
    }

    @RequestMapping(value={"/query/prestate"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public SQLResponse prepareQuery(@RequestBody PrepareSqlRequest sqlRequest) {
        return this.queryService.doQueryWithCache(sqlRequest);
    }

    @RequestMapping(value={"/saved_queries"}, method={RequestMethod.POST})
    @ResponseBody
    public void saveQuery(@RequestBody SaveSqlRequest sqlRequest) throws IOException {
        String creator = SecurityContextHolder.getContext().getAuthentication().getName();
        Query newQuery = new Query(sqlRequest.getName(), sqlRequest.getProject(), sqlRequest.getSql(), sqlRequest.getDescription());
        this.queryService.saveQuery(creator, newQuery);
    }

    @RequestMapping(value={"/saved_queries/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeQuery(@PathVariable String id) throws IOException {
        String creator = SecurityContextHolder.getContext().getAuthentication().getName();
        this.queryService.removeQuery(creator, id);
    }

    @RequestMapping(value={"/saved_queries"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Query> getQueries() throws IOException {
        String creator = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.queryService.getQueries(creator);
    }

    @RequestMapping(value={"/query/format/{format}"}, method={RequestMethod.GET})
    @ResponseBody
    public void downloadQueryResult(@PathVariable String format, SQLRequest sqlRequest, HttpServletResponse response) {
        SQLResponse result = this.queryService.doQueryWithCache(sqlRequest);
        response.setContentType("text/" + format + ";charset=utf-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"result." + format + "\"");
        CsvListWriter csvWriter = null;
        try {
            csvWriter = new CsvListWriter((Writer)response.getWriter(), CsvPreference.STANDARD_PREFERENCE);
            ArrayList<String> headerList = new ArrayList<String>();
            for (SelectedColumnMeta column : result.getColumnMetas()) {
                headerList.add(column.getName());
            }
            String[] headers = new String[headerList.size()];
            csvWriter.writeHeader(headerList.toArray(headers));
            for (List<String> row : result.getResults()) {
                csvWriter.write(row);
            }
        }
        catch (IOException e) {
            try {
                throw new InternalErrorException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(csvWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)csvWriter);
    }

    @RequestMapping(value={"/tables_and_columns"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TableMeta> getMetadata(MetaRequest metaRequest) {
        try {
            return this.queryService.getMetadata(metaRequest.getProject());
        }
        catch (SQLException e) {
            throw new InternalErrorException(e.getLocalizedMessage(), e);
        }
    }

    public void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }
}

