/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobTimeFilterEnum;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.request.JobListRequest;
import org.apache.kylin.rest.service.JobService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"jobs"})
public class JobController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(JobController.class);
    @Autowired
    private JobService jobService;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseBody
    public List<JobInstance> list(JobListRequest jobRequest) {
        List<JobInstance> jobInstanceList = Collections.emptyList();
        ArrayList<JobStatusEnum> statusList = new ArrayList<JobStatusEnum>();
        if (null != jobRequest.getStatus()) {
            for (int status : jobRequest.getStatus()) {
                statusList.add(JobStatusEnum.getByCode((int)status));
            }
        }
        JobTimeFilterEnum timeFilter = JobTimeFilterEnum.getByCode((int)jobRequest.getTimeFilter());
        try {
            jobInstanceList = this.jobService.searchJobs(jobRequest.getCubeName(), jobRequest.getProjectName(), statusList, jobRequest.getLimit(), jobRequest.getOffset(), timeFilter);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e);
        }
        return jobInstanceList;
    }

    @RequestMapping(value={"/{jobId}"}, method={RequestMethod.GET})
    @ResponseBody
    public JobInstance get(@PathVariable String jobId) {
        JobInstance jobInstance = null;
        try {
            jobInstance = this.jobService.getJobInstance(jobId);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e);
        }
        return jobInstance;
    }

    @RequestMapping(value={"/{jobId}/steps/{stepId}/output"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getStepOutput(@PathVariable String jobId, @PathVariable String stepId) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("jobId", jobId);
        result.put("stepId", String.valueOf(stepId));
        result.put("cmd_output", this.jobService.getExecutableManager().getOutput(stepId).getVerboseMsg());
        return result;
    }

    @RequestMapping(value={"/{jobId}/resume"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance resume(@PathVariable String jobId) {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(jobId);
            this.jobService.resumeJob(jobInstance);
            return this.jobService.getJobInstance(jobId);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e);
        }
    }

    @RequestMapping(value={"/{jobId}/cancel"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance cancel(@PathVariable String jobId) {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(jobId);
            return this.jobService.cancelJob(jobInstance);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e);
        }
    }

    @RequestMapping(value={"/{jobId}/pause"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance pause(@PathVariable String jobId) {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(jobId);
            return this.jobService.pauseJob(jobInstance);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e);
        }
    }

    @RequestMapping(value={"/{jobId}/steps/{stepId}/rollback"}, method={RequestMethod.PUT})
    @ResponseBody
    public JobInstance rollback(@PathVariable String jobId, @PathVariable String stepId) {
        try {
            JobInstance jobInstance = this.jobService.getJobInstance(jobId);
            this.jobService.rollbackJob(jobInstance, stepId);
            return this.jobService.getJobInstance(jobId);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw new InternalErrorException(e);
        }
    }

    public void setJobService(JobService jobService) {
        this.jobService = jobService;
    }
}

