/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.Optional;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.fun.SqlFloorFunction;
import org.apache.calcite.sql.type.NotConstant;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;

public class CalcitePlanRouterVisitor
extends RexVisitorImpl<Boolean> {
    public CalcitePlanRouterVisitor() {
        super(true);
    }

    public Boolean visitCall(RexCall call) {
        if (this.isConstantUdfContained(call) || this.isFloorFunctionContained(call)) {
            return Boolean.TRUE;
        }
        return call.getOperands().stream().anyMatch(operand -> CalcitePlanRouterVisitor.defaultForEmpty((Boolean)operand.accept((RexVisitor)this)));
    }

    private static Boolean defaultForEmpty(Boolean result) {
        return Optional.ofNullable(result).orElse(Boolean.FALSE);
    }

    private boolean isConstantUdfContained(RexCall call) {
        if (call.getOperator() instanceof SqlUserDefinedFunction && ((SqlUserDefinedFunction)call.getOperator()).getFunction() instanceof ScalarFunctionImpl) {
            SqlUserDefinedFunction sqlUserDefinedFunction = (SqlUserDefinedFunction)call.getOperator();
            ScalarFunctionImpl scalarFunction = (ScalarFunctionImpl)sqlUserDefinedFunction.getFunction();
            if (NotConstant.class.isAssignableFrom(scalarFunction.method.getDeclaringClass())) {
                return true;
            }
        }
        return false;
    }

    private boolean isFloorFunctionContained(RexCall call) {
        return call.getOperator() instanceof SqlFloorFunction;
    }
}

