/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;

public class AggregateMultipleExpandRule
extends RelOptRule {
    public static final AggregateMultipleExpandRule INSTANCE = new AggregateMultipleExpandRule(AggregateMultipleExpandRule.operand(LogicalAggregate.class, null, input -> input != null && input.getGroupType() != Aggregate.Group.SIMPLE, (RelOptRuleOperand)AggregateMultipleExpandRule.operand(RelNode.class, (RelOptRuleOperandChildren)AggregateMultipleExpandRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "AggregateMultipleExpandRule");

    private AggregateMultipleExpandRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    private static List<ImmutableBitSet> asList(ImmutableBitSet groupSet) {
        ArrayList<ImmutableBitSet> l = new ArrayList<ImmutableBitSet>(1);
        l.add(groupSet);
        return l;
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalAggregate aggr = (LogicalAggregate)call.getRelList().get(0);
        RelNode input = aggr.getInput();
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = aggr.getCluster().getRexBuilder();
        for (ImmutableBitSet groupSet : aggr.getGroupSets()) {
            this.buildForIndividualGroup(aggr, input, relBuilder, rexBuilder, groupSet);
        }
        RelNode unionAggr = relBuilder.union(true, aggr.getGroupSets().size()).build();
        call.transformTo(unionAggr);
    }

    private void buildForIndividualGroup(LogicalAggregate aggr, RelNode input, RelBuilder relBuilder, RexBuilder rexBuilder, ImmutableBitSet groupSet) {
        RexInputRef node;
        LinkedList<AggregateCall> newAggCallList = new LinkedList<AggregateCall>();
        for (AggregateCall aggCall : aggr.getAggCallList()) {
            newAggCallList.add(aggCall.adaptTo(aggr.getInput(), aggCall.getArgList(), aggCall.filterArg, aggr.getGroupCount(), groupSet.cardinality()));
        }
        LogicalAggregate newAgg = aggr.copy(aggr.getTraitSet(), input, groupSet, AggregateMultipleExpandRule.asList(groupSet), newAggCallList);
        relBuilder.push((RelNode)newAgg);
        ImmutableList.Builder rexNodes = new ImmutableList.Builder();
        int index = 0;
        Iterator groupSetIter = aggr.getGroupSet().iterator();
        Iterator typeIterator = aggr.getRowType().getFieldList().iterator();
        Iterator groupKeyIter = groupSet.iterator();
        int groupKey = (Integer)groupKeyIter.next();
        while (groupSetIter.hasNext()) {
            Integer aggrGroupKey = (Integer)groupSetIter.next();
            RelDataType targetType = ((RelDataTypeField)typeIterator.next()).getType();
            if (groupKey == aggrGroupKey) {
                RelDataTypeField field = newAgg.getRowType().getField(((RelDataTypeField)newAgg.getInput().getRowType().getFieldList().get(groupKey)).getName(), true, false);
                node = rexBuilder.makeInputRef(field.getType(), index++);
                rexNodes.add((Object)rexBuilder.ensureType(targetType, (RexNode)node, false));
                groupKey = (Integer)groupKeyIter.next();
                continue;
            }
            rexNodes.add((Object)rexBuilder.makeNullLiteral(targetType));
        }
        aggr.getClass();
        for (AggregateCall newAggCall : newAggCallList) {
            RelDataType targetType = ((RelDataTypeField)typeIterator.next()).getType();
            node = rexBuilder.makeInputRef(newAggCall.type, index++);
            rexNodes.add((Object)rexBuilder.ensureType(targetType, (RexNode)node, false));
        }
        relBuilder.project((Iterable)rexNodes.build());
    }
}

