/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.adaptor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.sdk.datasource.adaptor.AdaptorConfig;
import org.apache.kylin.sdk.datasource.adaptor.DefaultAdaptor;

public class MssqlAdaptor
extends DefaultAdaptor {
    private static final Pattern ASYM = Pattern.compile("BETWEEN(\\s*)ASYMMETRIC");
    private static final Pattern SYM = Pattern.compile("BETWEEN(\\s*)SYMMETRIC");

    public MssqlAdaptor(AdaptorConfig config) throws Exception {
        super(config);
    }

    @Override
    public String fixSql(String sql) {
        int idx;
        sql = sql.replaceAll(" DOUBLE", " FLOAT");
        boolean hasOrderBy = sql.toLowerCase(Locale.ROOT).contains("order by ");
        boolean hasOffset = sql.toLowerCase(Locale.ROOT).contains("offset ");
        if (!hasOrderBy) {
            int idx2 = sql.indexOf("OFFSET ");
            if (idx2 >= 0) {
                sql = sql.substring(0, idx2) + " ORDER BY 1 " + sql.substring(idx2);
            }
        } else if (!hasOffset && (idx = sql.toLowerCase(Locale.ROOT).indexOf("fetch ")) >= 0) {
            sql = sql.substring(0, idx) + "OFFSET 0 ROWS \n" + sql.substring(idx);
        }
        sql = sql.replaceAll("CEIL\\(", "CEILING\\(");
        sql = this.resolveBetweenAsymmetricSymmetric(sql);
        return sql;
    }

    @Override
    public List<String> listDatabases() throws SQLException {
        ArrayList<String> ret = new ArrayList<String>();
        try (Connection con = this.getConnection();){
            String database = con.getCatalog();
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)database), (Object)"SQL Server needs a specific database in connection string.");
            try (ResultSet rs = con.getMetaData().getSchemas(database, "%");){
                while (rs.next()) {
                    String schema = rs.getString("TABLE_SCHEM");
                    String catalog = rs.getString("TABLE_CATALOG");
                    if (!database.equals(catalog) && !schema.equals("dbo")) continue;
                    ret.add(schema);
                }
            }
        }
        return ret;
    }

    @Override
    public String toSourceTypeName(String kylinTypeName) {
        String lower;
        switch (lower = kylinTypeName.toLowerCase(Locale.ROOT)) {
            case "double": {
                return "float";
            }
        }
        return lower;
    }

    private String resolveBetweenAsymmetricSymmetric(String sql) {
        String sqlReturn = sql;
        Matcher matcher = ASYM.matcher(sql);
        if (matcher.find()) {
            sqlReturn = sql.replace(matcher.group(), "BETWEEN");
        }
        if ((matcher = SYM.matcher(sql)).find()) {
            sqlReturn = sqlReturn.replace(matcher.group(), "BETWEEN");
        }
        return sqlReturn;
    }
}

