/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.adaptor;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.rowset.CachedRowSet;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.sdk.datasource.adaptor.AdaptorConfig;
import org.apache.kylin.sdk.datasource.adaptor.DefaultAdaptor;
import org.apache.kylin.sdk.datasource.framework.FixedCachedRowSetImpl;
import org.apache.kylin.sdk.datasource.framework.conv.DefaultConfigurer;
import org.apache.kylin.sdk.datasource.framework.conv.SqlConverter;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDef;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDefProvider;
import org.apache.kylin.source.SupportsSparkCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcAdaptor
implements Closeable,
SupportsSparkCatalog {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultAdaptor.class);
    protected final BasicDataSource dataSource;
    protected final AdaptorConfig config;
    protected final DataSourceDef dataSourceDef;
    protected SqlConverter.IConfigurer configurer;
    protected final Cache<String, List<String>> DATABASES_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(4096L).build();
    protected final Cache<String, List<String>> TABLES_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(4096L).build();
    protected final Cache<String, List<String>> COLUMNS_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(4096L).build();
    private static Joiner joiner = Joiner.on((String)"_");

    @VisibleForTesting
    public AdaptorConfig getConfig() {
        return this.config;
    }

    @VisibleForTesting
    public BasicDataSource getDataSource() {
        return this.dataSource;
    }

    protected AbstractJdbcAdaptor() {
        this.dataSource = null;
        this.config = null;
        this.dataSourceDef = null;
    }

    protected AbstractJdbcAdaptor(AdaptorConfig config) throws Exception {
        this.config = config;
        this.dataSourceDef = DataSourceDefProvider.getInstance().getById(config.datasourceId);
        Class.forName(config.driver);
        Properties props = new Properties();
        props.setProperty("driverClassName", config.driver);
        props.setProperty("url", config.url);
        props.setProperty("username", config.username);
        props.setProperty("password", config.password);
        props.setProperty("maxTotal", String.valueOf(config.poolMaxTotal));
        props.setProperty("maxIdle", String.valueOf(config.poolMaxIdle));
        props.setProperty("minIdle", String.valueOf(config.poolMinIdle));
        this.dataSource = BasicDataSourceFactory.createDataSource((Properties)props);
        DataSourceDefProvider provider = DataSourceDefProvider.getInstance();
        DataSourceDef jdbcDs = provider.getById(this.getDataSourceId());
        this.configurer = new DefaultConfigurer(this, jdbcDs);
    }

    protected String getSourceValidationSql() {
        if (this.dataSourceDef.getValidationQuery() != null) {
            return this.dataSourceDef.getValidationQuery();
        }
        switch (this.config.driver) {
            case "org.hsqldb.jdbcDriver": {
                return "select 1 from INFORMATION_SCHEMA.SYSTEM_USERS";
            }
            case "oracle.jdbc.driver.OracleDriver": 
            case "oracle.jdbc.OracleDriver": {
                return "select 1 from dual";
            }
            case "com.ibm.db2.jcc.DB2Driver": {
                return "select 1 from sysibm.sysdummy1";
            }
            case "org.postgresql.Driver": {
                return "select version();";
            }
            case "org.apache.derby.jdbc.ClientDriver": {
                return "values 1";
            }
        }
        return "select 1";
    }

    protected CachedRowSet cacheResultSet(ResultSet resultSet) throws SQLException {
        FixedCachedRowSetImpl crs = new FixedCachedRowSetImpl();
        crs.populate(resultSet);
        return crs;
    }

    public Connection getConnection() throws SQLException {
        if (this.config.getConnectRetryTimes() > 0) {
            int retry = 0;
            while (true) {
                try {
                    ++retry;
                    return this.dataSource.getConnection();
                }
                catch (SQLException ex) {
                    logger.warn("Try connect to {} {} time(s) with error {}.", new Object[]{this.config.url, retry, ex.getLocalizedMessage()});
                    if (retry < this.config.getConnectRetryTimes()) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(this.config.getSleepMillisecBetweenRetry());
                        }
                        catch (InterruptedException e) {
                            logger.error("Retry connecting to {} is interrupted whiling sleeping:", (Object)this.config.url, (Object)e);
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    throw new SQLException(String.format(Locale.ROOT, "Can not connect to %s after retry %d time(s)", this.config.url, this.config.getConnectRetryTimes()));
                }
                break;
            }
        }
        return this.dataSource.getConnection();
    }

    public void setDefaultDb(Connection connection, String db) throws SQLException {
    }

    public Connection getConnectionWithDefaultDB(String dbName) throws SQLException {
        Connection connection = this.getConnection();
        if (StringUtils.isNotBlank((CharSequence)dbName)) {
            this.setDefaultDb(connection, dbName);
        }
        return connection;
    }

    protected void close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.dataSource.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String sql) throws SQLException {
        Statement statement = null;
        Connection connection = this.getConnection();
        try {
            statement = connection.createStatement();
            statement.execute(sql);
        }
        finally {
            this.close(statement);
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String[] sqls) throws SQLException {
        Statement statement = null;
        Connection connection = this.getConnection();
        try {
            statement = connection.createStatement();
            for (String sql : sqls) {
                statement.execute(sql);
            }
        }
        finally {
            this.close(statement);
            this.close(connection);
        }
    }

    public String getJdbcUrl() {
        return this.dataSource.getUrl();
    }

    public String getJdbcDriver() {
        return this.dataSource.getDriverClassName();
    }

    public String getJdbcUser() {
        return this.dataSource.getUsername();
    }

    public String getJdbcPassword() {
        return this.dataSource.getPassword();
    }

    public String getDataSourceId() {
        return this.config.datasourceId == null ? "default" : this.config.datasourceId;
    }

    public abstract int toKylinTypeId(String var1, int var2);

    public abstract String toKylinTypeName(int var1);

    public abstract String toSourceTypeName(String var1);

    public abstract String fixSql(String var1);

    public abstract String fixIdentifierCaseSensitive(String var1);

    public abstract List<String> listDatabases() throws SQLException;

    public List<String> listDatabasesWithCache() throws SQLException {
        return this.listDatabasesWithCache(false);
    }

    public List<String> listDatabasesWithCache(boolean init) throws SQLException {
        if (this.configurer.enableCache()) {
            List cachedDatabases;
            String cacheKey = joiner.join((Object)this.config.datasourceId, (Object)this.config.url, new Object[]{"databases"});
            if (init || (cachedDatabases = (List)this.DATABASES_CACHE.getIfPresent((Object)cacheKey)) == null) {
                cachedDatabases = this.listDatabases();
                this.DATABASES_CACHE.put((Object)cacheKey, (Object)cachedDatabases);
            }
            return cachedDatabases;
        }
        return this.listDatabases();
    }

    public abstract List<String> listTables(String var1) throws SQLException;

    public List<String> listTablesWithCache(String database, boolean init) throws SQLException {
        if (this.configurer.enableCache()) {
            List cachedTables;
            String cacheKey = joiner.join((Object)this.config.datasourceId, (Object)this.config.url, new Object[]{database, "tables"});
            if (init || (cachedTables = (List)this.TABLES_CACHE.getIfPresent((Object)cacheKey)) == null) {
                cachedTables = this.listTables(database);
                this.TABLES_CACHE.put((Object)cacheKey, (Object)cachedTables);
            }
            return cachedTables;
        }
        return this.listTables(database);
    }

    public abstract List<String> listColumns(String var1, String var2) throws SQLException;

    public abstract CachedRowSet getTable(String var1, String var2) throws SQLException;

    public abstract CachedRowSet getTableColumns(String var1, String var2) throws SQLException;

    public abstract String[] buildSqlToCreateSchema(String var1);

    public abstract String[] buildSqlToLoadDataFromLocal(String var1, String var2);

    public abstract String[] buildSqlToCreateTable(String var1, LinkedHashMap<String, String> var2);

    public abstract String[] buildSqlToCreateView(String var1, String var2);

    public boolean isCaseSensitive() {
        return this.configurer.isCaseSensitive();
    }

    protected void addConnectionProperty(String name, String value) {
        this.dataSource.addConnectionProperty(name, value);
    }
}

