/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.job.InternalTableLoadingJob;
import org.apache.kylin.engine.spark.job.NSparkSnapshotJob;
import org.apache.kylin.engine.spark.job.NTableSamplingJob;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ChainedExecutable;
import org.apache.kylin.job.execution.ChainedStageExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobSchedulerModeEnum;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.execution.StageExecutable;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.SegmentStatusEnumToDisplay;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.apache.kylin.rest.response.ExecutableStepResponse;

public class ExecutableResponse
implements Comparable<ExecutableResponse> {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="last_modified")
    private long lastModified;
    @JsonProperty(value="duration")
    private long duration;
    @JsonProperty(value="total_duration")
    private long totalDuration;
    @JsonProperty(value="exec_start_time")
    private long execStartTime;
    @JsonManagedReference
    @JsonProperty(value="steps")
    private List<ExecutableStepResponse> steps;
    @JsonProperty(value="job_status")
    private JobStatusEnum status;
    @JsonProperty(value="scheduler_state")
    private ExecutableState schedulerState;
    @JsonProperty(value="job_name")
    private String jobName;
    @JsonProperty(value="data_range_start")
    private long dataRangeStart;
    @JsonProperty(value="data_range_end")
    private long dataRangeEnd;
    @JsonProperty(value="target_model")
    private String targetModel;
    @JsonProperty(value="target_segments")
    private List<String> targetSegments;
    @JsonProperty(value="step_ratio")
    private float stepRatio;
    @JsonProperty(value="create_time")
    private long createTime;
    @JsonProperty(value="wait_time")
    private long waitTime;
    @JsonProperty(value="target_subject")
    private String targetSubject;
    @JsonProperty(value="target_subject_error")
    private boolean targetSubjectError = false;
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="submitter")
    private String submitter;
    @JsonProperty(value="exec_end_time")
    private long execEndTime;
    @JsonProperty(value="discard_safety")
    private boolean discardSafety;
    @JsonProperty(value="tag")
    private Object tag;
    @JsonProperty(value="snapshot_data_range")
    private String snapshotDataRange;
    @JsonProperty(value="job_scheduler_mode")
    private JobSchedulerModeEnum jobSchedulerMode;
    @JsonProperty(value="segments")
    private List<SegmentResponse> segments;
    private static final String SNAPSHOT_FULL_RANGE = "FULL";
    private static final String SNAPSHOT_INC_RANGE = "INC";
    @JsonProperty(value="version")
    protected String version;
    @JsonUnwrapped
    private OldParams oldParams;

    @JsonProperty(value="related_segment")
    public String getRelatedSegment() {
        return CollectionUtils.isEmpty(this.targetSegments) ? "" : String.join((CharSequence)",", this.targetSegments);
    }

    @JsonProperty(value="progress")
    public double getProgress() {
        int completedStepCount = 0;
        for (ExecutableStepResponse step : this.getSteps()) {
            if (step.getStatus() != JobStatusEnum.FINISHED) continue;
            ++completedStepCount;
        }
        if (this.steps.isEmpty()) {
            return 0.0;
        }
        return 100.0 * (double)completedStepCount / (double)this.steps.size();
    }

    public List<ExecutableStepResponse> getSteps() {
        if (this.steps == null) {
            this.steps = Collections.emptyList();
        }
        return this.steps;
    }

    private static ExecutableResponse newInstance(AbstractExecutable abstractExecutable, ExecutablePO executablePO) {
        Output output = abstractExecutable.getOutput(executablePO);
        ExecutableResponse executableResponse = new ExecutableResponse();
        executableResponse.setDataRangeEnd(abstractExecutable.getDataRangeEnd());
        executableResponse.setDataRangeStart(abstractExecutable.getDataRangeStart());
        executableResponse.setJobName(abstractExecutable.getName());
        executableResponse.setId(abstractExecutable.getId());
        executableResponse.setExecStartTime(AbstractExecutable.getStartTime((Output)output));
        executableResponse.setCreateTime(AbstractExecutable.getCreateTime((Output)output));
        executableResponse.setDuration(abstractExecutable.getDurationFromStepOrStageDurationSum(executablePO));
        executableResponse.setLastModified(AbstractExecutable.getLastModified((Output)output));
        executableResponse.setTargetModel(abstractExecutable.getTargetSubject());
        executableResponse.setTargetSegments(abstractExecutable.getTargetSegments());
        executableResponse.setTargetSubject(abstractExecutable.getTargetSubjectAlias());
        executableResponse.setWaitTime(abstractExecutable.getWaitTime(executablePO));
        executableResponse.setSubmitter(abstractExecutable.getSubmitter());
        executableResponse.setExecEndTime(AbstractExecutable.getEndTime((Output)output));
        executableResponse.setDiscardSafety(abstractExecutable.safetyIfDiscard());
        executableResponse.setTotalDuration(executableResponse.getWaitTime() + executableResponse.getDuration());
        executableResponse.setTag(abstractExecutable.getTag());
        executableResponse.setJobSchedulerMode(abstractExecutable.getJobSchedulerMode());
        return executableResponse;
    }

    public static ExecutableResponse create(AbstractExecutable abstractExecutable, ExecutablePO executablePO) {
        ExecutableResponse executableResponse = ExecutableResponse.newInstance(abstractExecutable, executablePO);
        if (abstractExecutable instanceof NTableSamplingJob) {
            NTableSamplingJob samplingJob = (NTableSamplingJob)abstractExecutable;
            executableResponse.setDataRangeEnd(Long.MAX_VALUE);
            executableResponse.setTargetSubject(samplingJob.getParam("table"));
            if (NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)abstractExecutable.getProject()).getTableDesc(executableResponse.getTargetSubject()) == null) {
                executableResponse.setTargetSubject(executableResponse.getTargetSubject() + " deleted");
                executableResponse.setTargetSubjectError(true);
            }
        } else if (abstractExecutable instanceof NSparkSnapshotJob) {
            NSparkSnapshotJob snapshotJob = (NSparkSnapshotJob)abstractExecutable;
            executableResponse.setDataRangeEnd(Long.MAX_VALUE);
            executableResponse.setTargetSubject(snapshotJob.getParam("table"));
            executableResponse.setSnapshotDataRange(ExecutableResponse.getDataRangeBySnapshotJob(snapshotJob));
            TableDesc tableDesc = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)abstractExecutable.getProject()).getTableDesc(executableResponse.getTargetSubject());
            if (snapshotJob.getStatusInMem().isFinalState() && (tableDesc == null || tableDesc.getLastSnapshotPath() == null)) {
                executableResponse.setTargetSubject("The snapshot is deleted");
                executableResponse.setTargetSubjectError(true);
            }
        } else if (abstractExecutable instanceof InternalTableLoadingJob) {
            InternalTableLoadingJob internalTableJob = (InternalTableLoadingJob)abstractExecutable;
            if ("false".equals(internalTableJob.getParam("incrementalBuild")) || "true".equals(internalTableJob.getParam("deletePartition"))) {
                executableResponse.setDataRangeEnd(Long.MAX_VALUE);
            } else {
                executableResponse.setDataRangeStart(Long.parseLong(internalTableJob.getParam("startTime")));
                executableResponse.setDataRangeEnd(Long.parseLong(internalTableJob.getParam("endTime")));
            }
            executableResponse.setTargetSubject(internalTableJob.getParam("table"));
            InternalTableDesc internalTableDesc = InternalTableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)abstractExecutable.getProject()).getInternalTableDesc(executableResponse.getTargetSubject());
            if (internalTableDesc == null || internalTableDesc.getLocation() == null) {
                executableResponse.setTargetSubject(executableResponse.getTargetSubject() + "not exist or has been deleted");
                executableResponse.setTargetSubjectError(true);
            }
        } else {
            NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)abstractExecutable.getProject()).getDataflow(abstractExecutable.getTargetSubject());
            if (dataflow == null) {
                executableResponse.setTargetSubject("The model is deleted");
                executableResponse.setTargetSubjectError(true);
            } else if (dataflow.checkBrokenWithRelatedInfo()) {
                executableResponse.setTargetSubject(executableResponse.getTargetSubject() + " broken");
                executableResponse.setTargetSubjectError(true);
            }
        }
        float stepRatio = ExecutableResponse.calculateStepRatio(abstractExecutable, executablePO);
        executableResponse.setStepRatio(stepRatio);
        executableResponse.setProject(abstractExecutable.getProject());
        return executableResponse;
    }

    public static float calculateStepRatio(AbstractExecutable abstractExecutable, ExecutablePO executablePO) {
        List tasks = ((ChainedExecutable)abstractExecutable).getTasks();
        double successSteps = 0.0;
        int stageCount = 0;
        for (AbstractExecutable task : tasks) {
            ChainedStageExecutable stageExecutable;
            Map stageMap;
            int taskMapStageCount;
            if (task instanceof ChainedStageExecutable && 0 != (taskMapStageCount = ((List)((Collection)Optional.of((stageMap = Optional.ofNullable((stageExecutable = (ChainedStageExecutable)task).getStagesMap()).orElse(Maps.newHashMap())).values()).orElse(Lists.newArrayList())).stream().findFirst().orElse(Lists.newArrayList())).size())) {
                stageCount = taskMapStageCount - 1;
                successSteps += ExecutableResponse.calculateSuccessStageInTaskMap(task, stageMap, executablePO);
                continue;
            }
            if (!task.getStatusInMem().isNotBad()) continue;
            successSteps += 1.0;
        }
        int stepCount = tasks.size() + stageCount;
        float stepRatio = (float)successSteps / (float)stepCount;
        if (stepRatio == 1.0f && ExecutableState.SUCCEED != abstractExecutable.getStatusInMem()) {
            stepRatio = 0.99f;
        }
        return stepRatio;
    }

    public static double calculateSuccessStageInTaskMap(AbstractExecutable task, Map<String, List<StageExecutable>> stageMap, ExecutablePO executablePO) {
        double successStages = 0.0;
        boolean calculateIndexExecRadio = stageMap.size() == 1;
        for (Map.Entry<String, List<StageExecutable>> entry : stageMap.entrySet()) {
            double count = ExecutableResponse.calculateSuccessStage(task, entry.getKey(), entry.getValue(), calculateIndexExecRadio, executablePO);
            successStages += count;
        }
        return successStages / (double)stageMap.size();
    }

    public static double calculateSuccessStage(AbstractExecutable task, String segmentId, List<StageExecutable> stageExecutables, boolean calculateIndexExecRadio, ExecutablePO executablePO) {
        double successStages = 0.0;
        for (StageExecutable stage : stageExecutables) {
            if (ExecutableState.SUCCEED == stage.getStatusInMem(segmentId) || ExecutableState.SKIP == stage.getStatusInMem(segmentId) || ExecutableState.WARNING == stage.getStatusInMem(segmentId)) {
                successStages += 1.0;
                continue;
            }
            String indexCountString = task.getParam("indexCount");
            String indexSuccess = stage.getOutput(segmentId, executablePO).getExtra().getOrDefault("indexSuccessCount", "");
            if (!calculateIndexExecRadio || !StringUtils.isNotBlank((CharSequence)indexCountString) || !StringUtils.isNotBlank((CharSequence)indexSuccess)) continue;
            int indexCount = Integer.parseInt(indexCountString);
            int indexSuccessCount = Integer.parseInt(indexSuccess);
            successStages += (double)indexSuccessCount / (double)indexCount;
        }
        return successStages;
    }

    private static String getDataRangeBySnapshotJob(NSparkSnapshotJob snapshotJob) {
        boolean increment = false;
        if ("true".equals(snapshotJob.getParam("incrementalBuild"))) {
            increment = true;
        }
        String partitionToBuild = snapshotJob.getParam("selectedPartition");
        String partitionCol = snapshotJob.getParam("selectedPartitionCol");
        if (partitionCol == null) {
            return SNAPSHOT_FULL_RANGE;
        }
        if (partitionToBuild != null) {
            List partitions = JsonUtil.readValueAsList((String)partitionToBuild);
            partitions.sort(String::compareTo);
            return JsonUtil.writeValueAsString((Object)partitions);
        }
        if (increment) {
            return SNAPSHOT_INC_RANGE;
        }
        return SNAPSHOT_FULL_RANGE;
    }

    @Override
    public int compareTo(ExecutableResponse o) {
        return Long.compare(o.lastModified, this.lastModified);
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setTotalDuration(long totalDuration) {
        this.totalDuration = totalDuration;
    }

    @Generated
    public void setExecStartTime(long execStartTime) {
        this.execStartTime = execStartTime;
    }

    @Generated
    public void setSteps(List<ExecutableStepResponse> steps) {
        this.steps = steps;
    }

    @Generated
    public void setStatus(JobStatusEnum status) {
        this.status = status;
    }

    @Generated
    public void setSchedulerState(ExecutableState schedulerState) {
        this.schedulerState = schedulerState;
    }

    @Generated
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Generated
    public void setDataRangeStart(long dataRangeStart) {
        this.dataRangeStart = dataRangeStart;
    }

    @Generated
    public void setDataRangeEnd(long dataRangeEnd) {
        this.dataRangeEnd = dataRangeEnd;
    }

    @Generated
    public void setTargetModel(String targetModel) {
        this.targetModel = targetModel;
    }

    @Generated
    public void setTargetSegments(List<String> targetSegments) {
        this.targetSegments = targetSegments;
    }

    @Generated
    public void setStepRatio(float stepRatio) {
        this.stepRatio = stepRatio;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    @Generated
    public void setTargetSubject(String targetSubject) {
        this.targetSubject = targetSubject;
    }

    @Generated
    public void setTargetSubjectError(boolean targetSubjectError) {
        this.targetSubjectError = targetSubjectError;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    @Generated
    public void setExecEndTime(long execEndTime) {
        this.execEndTime = execEndTime;
    }

    @Generated
    public void setDiscardSafety(boolean discardSafety) {
        this.discardSafety = discardSafety;
    }

    @Generated
    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Generated
    public void setSnapshotDataRange(String snapshotDataRange) {
        this.snapshotDataRange = snapshotDataRange;
    }

    @Generated
    public void setJobSchedulerMode(JobSchedulerModeEnum jobSchedulerMode) {
        this.jobSchedulerMode = jobSchedulerMode;
    }

    @Generated
    public void setSegments(List<SegmentResponse> segments) {
        this.segments = segments;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setOldParams(OldParams oldParams) {
        this.oldParams = oldParams;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public long getLastModified() {
        return this.lastModified;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public long getTotalDuration() {
        return this.totalDuration;
    }

    @Generated
    public long getExecStartTime() {
        return this.execStartTime;
    }

    @Generated
    public JobStatusEnum getStatus() {
        return this.status;
    }

    @Generated
    public ExecutableState getSchedulerState() {
        return this.schedulerState;
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public long getDataRangeStart() {
        return this.dataRangeStart;
    }

    @Generated
    public long getDataRangeEnd() {
        return this.dataRangeEnd;
    }

    @Generated
    public String getTargetModel() {
        return this.targetModel;
    }

    @Generated
    public List<String> getTargetSegments() {
        return this.targetSegments;
    }

    @Generated
    public float getStepRatio() {
        return this.stepRatio;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getWaitTime() {
        return this.waitTime;
    }

    @Generated
    public String getTargetSubject() {
        return this.targetSubject;
    }

    @Generated
    public boolean isTargetSubjectError() {
        return this.targetSubjectError;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getSubmitter() {
        return this.submitter;
    }

    @Generated
    public long getExecEndTime() {
        return this.execEndTime;
    }

    @Generated
    public boolean isDiscardSafety() {
        return this.discardSafety;
    }

    @Generated
    public Object getTag() {
        return this.tag;
    }

    @Generated
    public String getSnapshotDataRange() {
        return this.snapshotDataRange;
    }

    @Generated
    public JobSchedulerModeEnum getJobSchedulerMode() {
        return this.jobSchedulerMode;
    }

    @Generated
    public List<SegmentResponse> getSegments() {
        return this.segments;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public OldParams getOldParams() {
        return this.oldParams;
    }

    public static class SegmentResponse {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="status_to_display")
        private SegmentStatusEnumToDisplay statusToDisplay;

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public SegmentStatusEnumToDisplay getStatusToDisplay() {
            return this.statusToDisplay;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setStatusToDisplay(SegmentStatusEnumToDisplay statusToDisplay) {
            this.statusToDisplay = statusToDisplay;
        }

        @Generated
        public SegmentResponse() {
        }

        @Generated
        public SegmentResponse(String id, SegmentStatusEnumToDisplay statusToDisplay) {
            this.id = id;
            this.statusToDisplay = statusToDisplay;
        }
    }

    public static class OldParams {
        @JsonProperty(value="project_name")
        private String projectName;
        @JsonProperty(value="related_cube")
        private String relatedCube;
        @JsonProperty(value="display_cube_name")
        private String displayCubeName;
        @JsonProperty(value="uuid")
        private String uuid;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="exec_interrupt_time")
        private long execInterruptTime;
        @JsonProperty(value="mr_waiting")
        private long mrWaiting;

        @Generated
        public String getProjectName() {
            return this.projectName;
        }

        @Generated
        public String getRelatedCube() {
            return this.relatedCube;
        }

        @Generated
        public String getDisplayCubeName() {
            return this.displayCubeName;
        }

        @Generated
        public String getUuid() {
            return this.uuid;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public long getExecInterruptTime() {
            return this.execInterruptTime;
        }

        @Generated
        public long getMrWaiting() {
            return this.mrWaiting;
        }

        @Generated
        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Generated
        public void setRelatedCube(String relatedCube) {
            this.relatedCube = relatedCube;
        }

        @Generated
        public void setDisplayCubeName(String displayCubeName) {
            this.displayCubeName = displayCubeName;
        }

        @Generated
        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setExecInterruptTime(long execInterruptTime) {
            this.execInterruptTime = execInterruptTime;
        }

        @Generated
        public void setMrWaiting(long mrWaiting) {
            this.mrWaiting = mrWaiting;
        }
    }
}

