/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.ZookeeperConfig;
import org.apache.kylin.common.util.ZookeeperAclBuilder;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.shaded.curator.org.apache.curator.RetryPolicy;
import org.apache.kylin.shaded.curator.org.apache.curator.framework.CuratorFramework;
import org.apache.kylin.shaded.curator.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.kylin.shaded.curator.org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.kylin.shaded.curator.org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.kylin.shaded.curator.org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.kylin.shaded.curator.org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZKUtil.class);
    private static final KylinConfig defaultKylinConfig = KylinConfig.getInstanceFromEnv();
    public static final String ZK_ROOT = ZKUtil.fixPath(defaultKylinConfig.getZookeeperBasePath(), defaultKylinConfig.getClusterName());
    private static Cache<KylinConfig, CuratorFramework> CACHE = CacheBuilder.newBuilder().removalListener(notification -> {
        logger.info("CuratorFramework for zkString " + notification.getKey() + " is removed due to " + notification.getCause());
        CuratorFramework curator = (CuratorFramework)notification.getValue();
        try {
            if (curator != null) {
                curator.close();
            }
        }
        catch (Exception ex) {
            logger.error("Error at closing " + curator, (Throwable)ex);
        }
    }).expireAfterWrite(1L, TimeUnit.DAYS).build();

    private ZKUtil() {
    }

    private static String fixPath(String parent, String child) {
        String path = ZKPaths.makePath((String)parent, (String)child);
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("get canonical path failed, use original path", (Throwable)e);
            return path;
        }
    }

    public static CuratorFramework getZookeeperClient(KylinConfig config, ConnectionStateListener listener) throws Exception {
        if (config == null) {
            throw new IllegalArgumentException("KylinConfig can not be null");
        }
        RetryPolicy retryPolicy = ZKUtil.getRetryPolicy(config);
        return ZKUtil.getZookeeperClient(config, retryPolicy, listener);
    }

    public static CuratorFramework getZookeeperClient(KylinConfig config) throws Exception {
        return ZKUtil.getZookeeperClient(config, null);
    }

    private static CuratorFramework getZookeeperClient(final KylinConfig config, final RetryPolicy retryPolicy, final ConnectionStateListener listener) throws Exception {
        final String zkString = ZKUtil.getZKConnectString(config);
        try {
            CuratorFramework instance = (CuratorFramework)CACHE.get((Object)config, (Callable)new Callable<CuratorFramework>(){

                @Override
                public CuratorFramework call() throws Exception {
                    return ZKUtil.newZookeeperClient(config, zkString, retryPolicy, listener);
                }
            });
            if (instance.getState() != CuratorFrameworkState.STARTED || !instance.getZookeeperClient().isConnected()) {
                logger.warn("curator for {} is not available, reinitialize a new one", (Object)zkString);
                CACHE.invalidate((Object)config);
                instance = ZKUtil.getZookeeperClient(config, retryPolicy, listener);
            }
            return instance;
        }
        catch (ExecutionException e) {
            return ZKUtil.newZookeeperClient(config, zkString, retryPolicy, listener);
        }
    }

    private static String getZKConnectString(KylinConfig config) {
        return config.getZookeeperConnectString();
    }

    private static CuratorFramework newZookeeperClient(KylinConfig config, String zkString, RetryPolicy retryPolicy, ConnectionStateListener listener) throws Exception {
        logger.info("zookeeper connection string: {} with namespace {}", (Object)zkString, (Object)ZK_ROOT);
        CuratorFramework instance = ZKUtil.getCuratorFramework(config, zkString, ZK_ROOT, retryPolicy);
        instance.start();
        logger.info("new zookeeper Client start: {}", (Object)zkString);
        if (listener != null) {
            instance.getConnectionStateListenable().addListener((Object)listener);
        }
        ZKUtil.createzkRootIfNecessary(config, instance, zkString);
        return instance;
    }

    private static RetryPolicy getRetryPolicy(KylinConfig config) {
        int baseSleepTimeMs = config.getZKBaseSleepTimeMs();
        int maxRetries = config.getZKMaxRetries();
        return new ExponentialBackoffRetry(baseSleepTimeMs, maxRetries);
    }

    private static synchronized void createzkRootIfNecessary(KylinConfig config, CuratorFramework instance, String zkString) throws Exception {
        try {
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
            if (instance.checkExists().forPath("/") == null) {
                CuratorFramework tmpCurator = ZKUtil.getCuratorFramework(config, zkString, null, (RetryPolicy)retryPolicy);
                tmpCurator.start();
                tmpCurator.create().creatingParentsIfNeeded().forPath(ZK_ROOT);
                tmpCurator.close();
            }
        }
        catch (KeeperException.NodeExistsException e) {
            logger.warn("The zkRoot znode {} has been created by others", (Object)ZK_ROOT);
        }
        catch (Exception e) {
            logger.error("Fail to check or create znode for zkRoot {}", (Object)ZK_ROOT);
            throw e;
        }
    }

    private static CuratorFramework getCuratorFramework(KylinConfig config, String zkString, String zkRoot, RetryPolicy retryPolicy) {
        if (!Strings.isNullOrEmpty((String)zkRoot)) {
            zkString = zkString + zkRoot;
        }
        int sessionTimeout = ZookeeperConfig.geZKClientSessionTimeoutMs();
        int connectionTimeout = ZookeeperConfig.geZKClientConnectionTimeoutMs();
        ZookeeperAclBuilder aclBuilder = new ZookeeperAclBuilder().invoke();
        return aclBuilder.setZKAclBuilder(CuratorFrameworkFactory.builder()).connectString(zkString).sessionTimeoutMs(sessionTimeout).connectionTimeoutMs(connectionTimeout).retryPolicy(retryPolicy).build();
    }

    public static boolean pathExisted(String path, KylinConfig kylinConfig) throws Exception {
        try {
            CuratorFramework zkClient = ZKUtil.getZookeeperClient(kylinConfig);
            return zkClient.checkExists().forPath(path) != null;
        }
        catch (Exception e) {
            logger.error("Failed to create path: {}", (Object)path);
            throw e;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.info("Going to remove {} cached curator clients", (Object)CACHE.size());
            CACHE.invalidateAll();
        }));
    }
}

