/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.integration.test;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transport {
    private static final Logger LOG = LoggerFactory.getLogger(Transport.class);

    public static class Message {
        public byte[] header;
        public byte[] body;

        Message(byte[] header, byte[] body) {
            this.header = header;
            this.body = body;
        }

        public Message(String header, byte[] body) {
            this.header = header.getBytes(StandardCharsets.UTF_8);
            this.body = body;
        }
    }

    public static class Connection {
        private Socket socket;
        private DataInputStream instream;
        private DataOutputStream outstream;

        public Connection(Socket socket) throws IOException {
            this.socket = socket;
            this.instream = new DataInputStream(socket.getInputStream());
            this.outstream = new DataOutputStream(socket.getOutputStream());
        }

        public void close() throws IOException {
            this.socket.close();
        }

        public void sendToken(byte[] token) throws IOException {
            if (token != null) {
                this.outstream.writeInt(token.length);
                this.outstream.write(token);
            } else {
                this.outstream.writeInt(0);
            }
            this.outstream.flush();
        }

        public void sendMessage(Message msg) throws IOException {
            if (msg != null) {
                this.sendToken(msg.header);
                this.sendToken(msg.body);
            }
        }

        public void sendMessage(byte[] header, byte[] body) throws IOException {
            this.sendMessage(new Message(header, body));
        }

        public void sendMessage(String header, byte[] body) throws IOException {
            this.sendMessage(new Message(header, body));
        }

        public byte[] recvToken() throws IOException {
            int len = this.instream.readInt();
            if (len > 0) {
                byte[] token = new byte[len];
                this.instream.readFully(token);
                return token;
            }
            return null;
        }

        public Message recvMessage() throws IOException {
            byte[] header = this.recvToken();
            byte[] body = this.recvToken();
            Message msg = new Message(header, body);
            return msg;
        }
    }

    public static class Connector {
        public static Connection connect(String host, int port) throws IOException {
            Socket socket = new Socket(host, port);
            return new Connection(socket);
        }
    }

    public static class Acceptor {
        ServerSocket serverSocket;

        public Acceptor(int listenPort) throws IOException {
            this.serverSocket = new ServerSocket(listenPort);
        }

        public Connection accept() {
            try {
                Socket socket = this.serverSocket.accept();
                return new Connection(socket);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        public void close() {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close acceptor. " + e.toString());
            }
        }
    }
}

