/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kinit;

import org.apache.kerby.KOption;
import org.apache.kerby.KOptionGroup;
import org.apache.kerby.KOptionInfo;
import org.apache.kerby.KOptionType;
import org.apache.kerby.kerberos.kerb.client.KrbOptionGroup;

public enum KinitOption implements KOption
{
    NONE(null),
    CLIENT_PRINCIPAL(new KOptionInfo("client-principal", "Client principal", (KOptionGroup)KrbOptionGroup.KRB, KOptionType.STR)),
    LIFE_TIME(new KOptionInfo("-l", "lifetime", (KOptionGroup)KrbOptionGroup.KRB, KOptionType.DURATION)),
    START_TIME(new KOptionInfo("-s", "start time", (KOptionGroup)KrbOptionGroup.KRB, KOptionType.DURATION)),
    RENEWABLE_LIFE(new KOptionInfo("-r", "renewable lifetime", (KOptionGroup)KrbOptionGroup.KRB, KOptionType.DURATION)),
    AS_ENTERPRISE_PN(new KOptionInfo("-E", "client is enterprise principal name", (KOptionGroup)KrbOptionGroup.KRB)),
    INCLUDE_ADDRESSES(new KOptionInfo("-a", "include addresses", (KOptionGroup)KrbOptionGroup.KRB)),
    NOT_INCLUDE_ADDRESSES(new KOptionInfo("-A", "do not include addresses", (KOptionGroup)KrbOptionGroup.KRB)),
    FORWARDABLE(new KOptionInfo("-f", "forwardable", (KOptionGroup)KrbOptionGroup.KDC_FLAGS)),
    NOT_FORWARDABLE(new KOptionInfo("-F", "not forwardable", (KOptionGroup)KrbOptionGroup.KDC_FLAGS)),
    PROXIABLE(new KOptionInfo("-p", "proxiable", (KOptionGroup)KrbOptionGroup.KDC_FLAGS)),
    NOT_PROXIABLE(new KOptionInfo("-P", "not proxiable", (KOptionGroup)KrbOptionGroup.KDC_FLAGS)),
    ANONYMOUS(new KOptionInfo("-n", "anonymous", (KOptionGroup)KrbOptionGroup.KDC_FLAGS)),
    VALIDATE(new KOptionInfo("-v", "validate", (KOptionGroup)KrbOptionGroup.KDC_FLAGS)),
    RENEW(new KOptionInfo("-R", "renew", (KOptionGroup)KrbOptionGroup.KDC_FLAGS)),
    CANONICALIZE(new KOptionInfo("-C", "canonicalize", (KOptionGroup)KrbOptionGroup.KDC_FLAGS)),
    USE_PASSWD(new KOptionInfo("using-password", "using password", (KOptionGroup)KrbOptionGroup.KRB)),
    USER_PASSWD(new KOptionInfo("user-passwd", "User plain password", (KOptionGroup)KrbOptionGroup.KRB)),
    USE_KEYTAB(new KOptionInfo("-k", "use keytab", (KOptionGroup)KrbOptionGroup.KRB)),
    USE_DFT_KEYTAB(new KOptionInfo("-i", "use default client keytab (with -k)", (KOptionGroup)KrbOptionGroup.KRB)),
    KEYTAB_FILE(new KOptionInfo("-t", "filename of keytab to use", (KOptionGroup)KrbOptionGroup.KRB, KOptionType.FILE)),
    KRB5_CACHE(new KOptionInfo("-c", "Kerberos 5 cache name", (KOptionGroup)KrbOptionGroup.KRB, KOptionType.STR)),
    SERVICE(new KOptionInfo("-S", "service", (KOptionGroup)KrbOptionGroup.KRB, KOptionType.STR)),
    ARMOR_CACHE(new KOptionInfo("-T", "armor credential cache", (KOptionGroup)KrbOptionGroup.KRB, KOptionType.FILE)),
    XATTR(new KOptionInfo("-X", "<attribute>[=<value>]", KOptionType.STR)),
    CONF_DIR(new KOptionInfo("-conf", "conf dir", (KOptionGroup)KrbOptionGroup.KRB, KOptionType.DIR));

    private final KOptionInfo optionInfo;

    private KinitOption(KOptionInfo optionInfo) {
        this.optionInfo = optionInfo;
    }

    public KOptionInfo getOptionInfo() {
        return this.optionInfo;
    }

    public static KinitOption fromName(String name) {
        if (name != null) {
            for (KinitOption ko : KinitOption.values()) {
                if (ko.optionInfo == null || !ko.optionInfo.getName().equals(name)) continue;
                return ko;
            }
        }
        return NONE;
    }
}

