/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.karaf.features.BootFinished;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.main.Main;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@Mojo(name="run", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=false)
public class RunMojo
extends MojoSupport {
    @Parameter(defaultValue="${project.build.directory}/karaf")
    private File karafDirectory = null;
    @Parameter(defaultValue="mvn:org.apache.karaf/apache-karaf/LATEST/zip")
    private String karafDistribution = null;
    @Parameter(defaultValue="true")
    private boolean deployProjectArtifact = true;
    @Parameter
    private File fallbackLocalProjectArtifact;
    @Parameter(defaultValue="false")
    private boolean deployAfterFeatures = false;
    @Parameter
    private String[] featureRepositories = null;
    @Parameter
    private String[] mainArgs;
    @Parameter
    private String consoleLogLevel;
    @Parameter
    private Map<String, String> systemProperties;
    @Parameter(defaultValue="")
    private String featuresToInstall = null;
    @Parameter(defaultValue="true")
    private boolean keepRunning = true;
    @Parameter(defaultValue="false")
    private String startSsh = "false";
    @Parameter(defaultValue="180000")
    private long maximumStartupDuration;
    @Parameter
    private List<String> forbiddenDelegationPackages;
    private static final Pattern mvnPattern = Pattern.compile("mvn:([^/ ]+)/([^/ ]+)/([^/ ]*)(/([^/ ]+)(/([^/ ]+))?)?");

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties originalProperties = new Properties();
        originalProperties.putAll((Map<?, ?>)System.getProperties());
        String[] args = this.handleArgs(this.karafDirectory, this.mainArgs == null ? new String[]{} : this.mainArgs);
        if (this.karafDirectory.exists()) {
            this.getLog().info((CharSequence)("Using Karaf container located " + this.karafDirectory.getAbsolutePath()));
        } else {
            this.getLog().info((CharSequence)"Extracting Karaf container");
            try {
                File karafArchiveFile = this.resolveFile(this.karafDistribution);
                RunMojo.extract(karafArchiveFile, this.karafDirectory);
            }
            catch (Exception e) {
                throw new MojoFailureException("Can't extract Karaf container", (Throwable)e);
            }
        }
        this.getLog().info((CharSequence)"Starting Karaf container");
        System.setProperty("karaf.home", this.karafDirectory.getAbsolutePath());
        System.setProperty("karaf.base", this.karafDirectory.getAbsolutePath());
        System.setProperty("karaf.data", this.karafDirectory.getAbsolutePath() + "/data");
        System.setProperty("karaf.etc", this.karafDirectory.getAbsolutePath() + "/etc");
        System.setProperty("karaf.log", this.karafDirectory.getAbsolutePath() + "/data/log");
        System.setProperty("karaf.instances", this.karafDirectory.getAbsolutePath() + "/instances");
        if (System.getProperty("karaf.startLocalConsole") == null) {
            System.setProperty("karaf.startLocalConsole", "false");
        }
        System.setProperty("karaf.startRemoteShell", this.startSsh);
        System.setProperty("karaf.lock", "false");
        if (this.consoleLogLevel != null && !this.consoleLogLevel.isEmpty()) {
            System.setProperty("karaf.log.console", this.consoleLogLevel);
        }
        if (this.systemProperties != null) {
            this.systemProperties.forEach(System::setProperty);
        }
        final String featureBootFinished = BootFinished.class.getName();
        Thread bootThread = Thread.currentThread();
        ClassLoader classRealm = bootThread.getContextClassLoader();
        ClassLoader bootLoader = new ClassLoader(classRealm){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (featureBootFinished.equals(name)) {
                    throw new ClassNotFoundException("avoid to use the classrealm loader which will prevent felix to match its reference");
                }
                if (name != null && RunMojo.this.forbiddenDelegationPackages != null) {
                    if (RunMojo.this.forbiddenDelegationPackages.stream().anyMatch(name::startsWith)) {
                        throw new ClassNotFoundException(name);
                    }
                }
                return super.loadClass(name, resolve);
            }
        };
        Main main = this.newMain(bootLoader, args);
        try {
            long start = System.nanoTime();
            main.launch();
            while (main.getFramework().getState() != 32 && this.checkDurationTimeout(start)) {
                this.waitForValidState();
            }
            if (main.getFramework().getState() != 32) {
                try {
                    main.destroy();
                }
                catch (Throwable e) {
                    this.getLog().debug((CharSequence)e.getMessage(), e);
                }
                throw this.startupTimeout(start);
            }
            BundleContext featureBundleCtx = null;
            Object bootFinished = null;
            while (bootFinished == null && this.checkDurationTimeout(start)) {
                ServiceReference ref;
                this.waitForValidState();
                if (featureBundleCtx == null) {
                    featureBundleCtx = Stream.of(main.getFramework().getBundleContext().getBundles()).filter(b -> b.getSymbolicName().equals("org.apache.karaf.deployer.features")).findFirst().map(Bundle::getBundleContext).orElse(null);
                }
                if (featureBundleCtx == null || (ref = featureBundleCtx.getServiceReference(featureBundleCtx.getBundle().loadClass(featureBootFinished))) == null) continue;
                bootFinished = featureBundleCtx.getService(ref);
            }
            if (bootFinished == null) {
                try {
                    main.destroy();
                }
                catch (Throwable e) {
                    this.getLog().debug((CharSequence)e.getMessage(), e);
                }
                throw this.startupTimeout(start);
            }
            Object featureService = this.findFeatureService(featureBundleCtx);
            this.addFeatureRepositories(featureService);
            if (!this.deployAfterFeatures) {
                this.deploy(featureBundleCtx, featureService);
            }
            this.addFeatures(featureService);
            if (this.deployAfterFeatures) {
                this.deploy(featureBundleCtx, featureService);
            }
            if (this.keepRunning) {
                main.awaitShutdown();
            }
            main.destroy();
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Can't start container", e);
        }
        finally {
            System.gc();
            System.getProperties().clear();
            System.getProperties().putAll((Map<?, ?>)originalProperties);
        }
    }

    private String[] handleArgs(File base, String[] strings) {
        return (String[])Stream.of(strings).filter(it -> {
            switch (it) {
                case "console": {
                    System.setProperty("karaf.startLocalConsole", "true");
                    return false;
                }
                case "clean": {
                    if (base.exists()) {
                        this.getLog().info((CharSequence)("Cleaning " + String.valueOf(base)));
                        try {
                            FileUtils.deleteDirectory((File)base);
                        }
                        catch (IOException e) {
                            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                        }
                    }
                    return false;
                }
            }
            return true;
        }).toArray(String[]::new);
    }

    protected Main newMain(final ClassLoader bootLoader, String[] args) {
        return new Main(args){

            protected ClassLoader getParentClassLoader() {
                return bootLoader;
            }
        };
    }

    private void waitForValidState() throws InterruptedException {
        Thread.sleep(1000L);
    }

    private IllegalStateException startupTimeout(long start) {
        return new IllegalStateException("Server didn't start in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + "ms");
    }

    private boolean checkDurationTimeout(long start) {
        return this.maximumStartupDuration <= 0L || TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) < this.maximumStartupDuration;
    }

    void addFeatureRepositories(Object featureService) throws MojoExecutionException {
        if (this.featureRepositories != null) {
            try {
                Class<?> serviceClass = featureService.getClass();
                Method addRepositoryMethod = serviceClass.getMethod("addRepository", URI.class);
                for (String featureRepo : this.featureRepositories) {
                    addRepositoryMethod.invoke(featureService, URI.create(featureRepo));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to add feature repositories to karaf", e);
            }
        }
    }

    void deploy(BundleContext bundleContext, Object featureService) throws MojoExecutionException {
        if (this.deployProjectArtifact) {
            boolean attachedFeatureFileExists;
            boolean artifactExists;
            File artifact = this.getProjectArtifact();
            File attachedFeatureFile = this.getAttachedFeatureFile(this.project);
            boolean bl = artifactExists = artifact != null && artifact.exists();
            if (!artifactExists) {
                artifact = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".jar");
                artifactExists = artifact != null && artifact.exists();
            }
            boolean bl2 = attachedFeatureFileExists = attachedFeatureFile != null && attachedFeatureFile.exists();
            if (attachedFeatureFileExists) {
                this.getLog().info((CharSequence)("Deploying features repository " + attachedFeatureFile.getAbsolutePath()));
                this.addFeaturesAttachmentAsFeatureRepository(featureService, attachedFeatureFile);
            } else if (artifactExists) {
                try {
                    this.getLog().info((CharSequence)("Deploying bundle " + artifact.getAbsolutePath()));
                    Bundle bundle = bundleContext.installBundle(artifact.toURI().toURL().toString());
                    bundle.start();
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Can't deploy project artifact in container", e);
                }
            } else {
                throw new MojoExecutionException("No artifact to deploy");
            }
            this.getLog().info((CharSequence)"Artifact deployed");
        }
    }

    private File getProjectArtifact() {
        File file = this.project.getArtifact().getFile();
        if ((file == null || !file.exists()) && this.fallbackLocalProjectArtifact != null && this.fallbackLocalProjectArtifact.exists()) {
            return this.fallbackLocalProjectArtifact;
        }
        return file;
    }

    void addFeatures(Object featureService) throws MojoExecutionException {
        if (this.featuresToInstall != null) {
            try {
                String[] features;
                Class<?> serviceClass = featureService.getClass();
                Method installFeatureMethod = serviceClass.getMethod("installFeature", String.class);
                for (String feature : features = this.featuresToInstall.split(" *, *")) {
                    installFeatureMethod.invoke(featureService, feature);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to add features to karaf", e);
            }
        }
    }

    public static void extract(File sourceFile, File targetFolder) throws IOException {
        if (sourceFile.getAbsolutePath().indexOf(".zip") > 0) {
            RunMojo.extractZipDistribution(sourceFile, targetFolder);
        } else if (sourceFile.getAbsolutePath().indexOf(".tar.gz") > 0) {
            RunMojo.extractTarGzDistribution(sourceFile, targetFolder);
        } else {
            throw new IllegalStateException("Unknown packaging of distribution; only zip or tar.gz could be handled.");
        }
    }

    private static void extractTarGzDistribution(File sourceDistribution, File _targetFolder) throws IOException {
        File uncompressedFile = Files.createTempFile("uncompressedTarGz-", ".tar", new FileAttribute[0]).toFile();
        RunMojo.extractGzArchive(new FileInputStream(sourceDistribution), uncompressedFile);
        RunMojo.extract((ArchiveInputStream)new TarArchiveInputStream((InputStream)new FileInputStream(uncompressedFile)), _targetFolder);
        FileUtils.forceDelete((File)uncompressedFile);
    }

    private static void extractZipDistribution(File sourceDistribution, File _targetFolder) throws IOException {
        RunMojo.extract((ArchiveInputStream)new ZipArchiveInputStream((InputStream)new FileInputStream(sourceDistribution)), _targetFolder);
    }

    private static void extractGzArchive(InputStream tarGz, File tar) throws IOException {
        BufferedInputStream in = new BufferedInputStream(tarGz);
        FileOutputStream out = new FileOutputStream(tar);
        GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
        byte[] buffer = new byte[1000];
        int n = 0;
        while (-1 != (n = gzIn.read(buffer))) {
            out.write(buffer, 0, n);
        }
        out.close();
        gzIn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extract(ArchiveInputStream is, File targetDir) throws IOException {
        try {
            if (targetDir.exists()) {
                FileUtils.forceDelete((File)targetDir);
            }
            targetDir.mkdirs();
            ArchiveEntry entry = is.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                name = name.substring(name.indexOf("/") + 1);
                File file = new File(targetDir, name);
                Object canonicalizedTargetDir = targetDir.getCanonicalPath();
                if (!((String)canonicalizedTargetDir).endsWith(File.separator)) {
                    canonicalizedTargetDir = (String)canonicalizedTargetDir + File.separator;
                }
                if (!file.getCanonicalPath().startsWith((String)canonicalizedTargetDir)) {
                    throw new IOException("Archive cannot contain paths with .. characters");
                }
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    file.getParentFile().mkdirs();
                    FileOutputStream os = new FileOutputStream(file);
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)os);
                    }
                }
                entry = is.getNextEntry();
            }
        }
        finally {
            is.close();
        }
    }

    protected static boolean isMavenUrl(String name) {
        Matcher m = mvnPattern.matcher(name);
        return m.matches();
    }

    private File resolveFile(String file) {
        File fileResolved;
        block7: {
            fileResolved = null;
            if (RunMojo.isMavenUrl(file)) {
                fileResolved = new File(RunMojo.fromMaven(file));
                try {
                    Artifact artifactTemp = this.resourceToArtifact(file, false);
                    if (fileResolved.exists()) break block7;
                    try {
                        this.artifactResolver.resolve(artifactTemp, this.remoteRepos, this.localRepo);
                        fileResolved = artifactTemp.getFile();
                    }
                    catch (ArtifactResolutionException e) {
                        this.getLog().error((CharSequence)"Artifact was not resolved", (Throwable)e);
                    }
                    catch (ArtifactNotFoundException e) {
                        this.getLog().error((CharSequence)"Artifact was not found", (Throwable)e);
                    }
                }
                catch (MojoExecutionException e) {
                    this.getLog().error((Throwable)e);
                }
            } else {
                fileResolved = new File(file);
            }
        }
        return fileResolved;
    }

    private static String fromMaven(String name) {
        Matcher m = mvnPattern.matcher(name);
        if (!m.matches()) {
            return name;
        }
        StringBuilder b = new StringBuilder();
        b.append(m.group(1));
        for (int i = 0; i < b.length(); ++i) {
            if (b.charAt(i) != '.') continue;
            b.setCharAt(i, '/');
        }
        b.append("/");
        String artifactId = m.group(2);
        String version = m.group(3);
        String extension = m.group(5);
        String classifier = m.group(7);
        b.append(artifactId).append("/");
        b.append(version).append("/");
        b.append(artifactId).append("-").append(version);
        if (RunMojo.present(classifier)) {
            b.append("-").append(classifier);
        }
        if (RunMojo.present(classifier)) {
            b.append(".").append(extension);
        } else {
            b.append(".jar");
        }
        return b.toString();
    }

    private static boolean present(String part) {
        return part != null && !part.isEmpty();
    }

    private File getAttachedFeatureFile(MavenProject project) {
        List attachedArtifacts = project.getAttachedArtifacts();
        for (Artifact artifact : attachedArtifacts) {
            if (!"features".equals(artifact.getClassifier()) || !"xml".equals(artifact.getType())) continue;
            return artifact.getFile();
        }
        return null;
    }

    Object findFeatureService(BundleContext bundleContext) {
        ServiceReference ref = bundleContext.getServiceReference(FeaturesService.class);
        if (ref != null) {
            Object featureService = bundleContext.getService(ref);
            return featureService;
        }
        return null;
    }

    private void addFeaturesAttachmentAsFeatureRepository(Object featureService, File attachedFeatureFile) throws MojoExecutionException {
        if (featureService != null) {
            try {
                Class<?> serviceClass = featureService.getClass();
                Method addRepositoryMethod = serviceClass.getMethod("addRepository", URI.class);
                addRepositoryMethod.invoke(featureService, attachedFeatureFile.toURI());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to register attachment as feature repository", e);
            }
        } else {
            throw new MojoExecutionException("Failed to find the FeatureService when adding a feature repository");
        }
    }
}

