/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Conditional;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.ConfigFile;
import org.apache.karaf.features.internal.model.Dependency;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JacksonUtil;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.osgi.framework.Version;

public abstract class AbstractFeatureMojo
extends MojoSupport {
    @Parameter
    protected List<String> descriptors;
    protected Set<Artifact> descriptorArtifacts = new HashSet<Artifact>();
    @Parameter
    protected List<String> features;
    @Parameter
    protected boolean addTransitiveFeatures = true;
    @Parameter
    private boolean includeMvnBasedDescriptors = false;
    @Parameter
    private boolean failOnArtifactResolutionError = true;
    @Parameter
    private boolean resolveDefinedRepositoriesRecursively = true;
    @Parameter
    protected boolean skipNonMavenProtocols = true;
    @Parameter(defaultValue="false")
    protected boolean ignoreDependencyFlag;
    @Parameter
    private int defaultStartLevel = 80;
    @Parameter(defaultValue="false")
    protected boolean useJson;
    private int resolveCount = 0;

    protected void addFeatureRepo(String featureUrl) throws MojoExecutionException {
        Artifact featureDescArtifact = this.resourceToArtifact(featureUrl, true);
        if (featureDescArtifact == null) {
            return;
        }
        try {
            this.resolveArtifact(featureDescArtifact, this.remoteRepos);
            this.descriptors.add(0, featureUrl);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Can't add " + featureUrl + " in the descriptors set"));
            this.getLog().debug((Throwable)e);
        }
    }

    protected void retrieveDescriptorsRecursively(String uri, Set<String> bundles, Map<String, Feature> featuresMap) {
        Artifact descriptor;
        try {
            descriptor = this.resourceToArtifact(uri, true);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (descriptor != null) {
            this.resolveArtifact(descriptor, this.remoteRepos);
            this.descriptorArtifacts.add(descriptor);
        }
        if (this.includeMvnBasedDescriptors) {
            bundles.add(uri);
        }
        String uriToUse = descriptor != null ? descriptor.getFile().toURI().toString() : this.translateFromMaven(uri);
        Features repo = null;
        if (JacksonUtil.isJson((String)uriToUse)) {
            try {
                repo = JacksonUtil.unmarshal((String)uriToUse);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error unmarshalling features json", (Throwable)e);
                return;
            }
        } else {
            repo = JaxbUtil.unmarshal((String)uriToUse, (boolean)true);
        }
        for (Feature f : repo.getFeature()) {
            featuresMap.put(f.getId(), f);
        }
        if (this.resolveDefinedRepositoriesRecursively) {
            for (String r : repo.getRepository()) {
                this.retrieveDescriptorsRecursively(r, bundles, featuresMap);
            }
        }
    }

    protected void resolveArtifact(Artifact artifact, List<ArtifactRepository> remoteRepos) {
        try {
            if (artifact == null) {
                return;
            }
            List<ArtifactRepository> usedRemoteRepos = artifact.getRepository() != null ? Collections.singletonList(artifact.getRepository()) : remoteRepos;
            this.artifactResolver.resolve(artifact, usedRemoteRepos, this.localRepo);
        }
        catch (Exception e) {
            if (this.failOnArtifactResolutionError) {
                throw new RuntimeException("Can't resolve artifact " + String.valueOf(artifact), e);
            }
            this.getLog().warn((CharSequence)("Can't resolve artifact " + String.valueOf(artifact)));
            this.getLog().debug((Throwable)e);
        }
    }

    protected void addFeatures(List<String> featureNames, Set<Feature> features, Map<String, Feature> featuresMap, boolean transitive) {
        for (String feature : featureNames) {
            String[] split = feature.split("/");
            List<Feature> innerFeatures = this.getMatchingFeature(featuresMap, split[0], split.length > 1 ? split[1] : null);
            for (Feature f : innerFeatures) {
                features.add(f);
                if (!transitive) continue;
                this.addFeaturesDependencies(f.getFeature(), features, featuresMap, true);
            }
        }
    }

    protected void addFeaturesDependencies(List<Dependency> featureNames, Set<Feature> features, Map<String, Feature> featuresMap, boolean transitive) {
        for (Dependency dependency : featureNames) {
            List<Feature> innerFeatures = this.getMatchingFeature(featuresMap, dependency.getName(), dependency.getVersion());
            for (Feature f : innerFeatures) {
                features.add(f);
                if (!transitive) continue;
                this.addFeaturesDependencies(f.getFeature(), features, featuresMap, true);
            }
        }
    }

    private List<Feature> getMatchingFeature(Map<String, Feature> featuresMap, String feature, String version) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        Pattern namePattern = Pattern.compile(feature);
        if (version != null && !version.equals("0.0.0")) {
            Feature f = null;
            for (String string : featuresMap.keySet()) {
                String[] nameAndVersion = string.split("/");
                Matcher matcher = namePattern.matcher(nameAndVersion[0]);
                if (!matcher.matches() || !version.equals(nameAndVersion[1])) continue;
                f = featuresMap.get(string);
                features.add(f);
            }
            if (f == null) {
                VersionRange versionRange = new VersionRange(version);
                for (String key : featuresMap.keySet()) {
                    String verStr;
                    Version ver;
                    String[] nameVersion = key.split("/");
                    Matcher matcher = namePattern.matcher(nameVersion[0]);
                    if (!matcher.matches() || !versionRange.contains(ver = VersionTable.getVersion((String)(verStr = featuresMap.get(key).getVersion()))) || f != null && VersionTable.getVersion((String)f.getVersion()).compareTo(VersionTable.getVersion((String)featuresMap.get(key).getVersion())) >= 0) continue;
                    features.add(featuresMap.get(key));
                }
            }
        } else {
            for (String key : featuresMap.keySet()) {
                String[] stringArray = key.split("/");
                Matcher matcher = namePattern.matcher(stringArray[0]);
                if (!matcher.matches()) continue;
                features.add(featuresMap.get(key));
            }
        }
        if (features.size() == 0) {
            throw new IllegalArgumentException("Unable to find the feature '" + feature + "'");
        }
        return features;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Set<Feature> resolveFeatures() throws MojoExecutionException {
        HashSet<Feature> featuresSet = new HashSet<Feature>();
        try {
            HashSet<String> artifactsToCopy = new HashSet<String>();
            HashMap<String, Feature> featuresMap = new HashMap<String, Feature>();
            for (String uri : this.descriptors) {
                this.retrieveDescriptorsRecursively(uri, artifactsToCopy, featuresMap);
            }
            if (this.features == null) {
                this.features = new ArrayList(featuresMap.keySet());
            }
            this.addFeatures(this.features, featuresSet, featuresMap, this.addTransitiveFeatures);
            this.getLog().info((CharSequence)("Using local repository at: " + this.localRepo.getUrl()));
            for (Feature feature : featuresSet) {
                try {
                    for (Bundle bundle : feature.getBundle()) {
                        this.resolveArtifact(bundle.getLocation());
                    }
                    for (Conditional conditional : feature.getConditional()) {
                        for (BundleInfo bundle : conditional.getBundles()) {
                            if (!this.ignoreDependencyFlag && (this.ignoreDependencyFlag || bundle.isDependency())) continue;
                            this.resolveArtifact(bundle.getLocation());
                        }
                    }
                    for (ConfigFile configfile : feature.getConfigfile()) {
                        this.resolveArtifact(configfile.getLocation());
                    }
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Error resolving feature " + feature.getName() + "/" + feature.getVersion(), e);
                    return featuresSet;
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error populating repository", e);
        }
    }

    private Artifact resolveArtifact(String location) throws MojoExecutionException {
        Artifact artifact = this.resourceToArtifact(location, this.skipNonMavenProtocols);
        if (artifact != null) {
            try {
                this.resolveArtifact(artifact, this.remoteRepos);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error resolving artifact " + location, e);
            }
        }
        this.checkDoGarbageCollect();
        return artifact;
    }

    protected void checkDoGarbageCollect() {
        if (this.resolveCount++ % 100 == 0) {
            System.gc();
            System.runFinalization();
        }
    }
}

