/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;

public class ManifestUtils {
    private ManifestUtils() {
    }

    public static List<Clause> getImports(Manifest manifest) {
        Clause[] clauses;
        LinkedList<Clause> result = new LinkedList<Clause>();
        for (Clause clause : clauses = Parser.parseHeader((String)ManifestUtils.getHeader("Import-Package", manifest))) {
            result.add(clause);
        }
        return result;
    }

    public static List<Clause> getMandatoryImports(Manifest manifest) {
        LinkedList<Clause> result = new LinkedList<Clause>();
        for (Clause clause : ManifestUtils.getImports(manifest)) {
            if (ManifestUtils.isOptional(clause)) continue;
            result.add(clause);
        }
        return result;
    }

    public static List<Clause> getExports(Manifest manifest) {
        Clause[] clauses;
        LinkedList<Clause> result = new LinkedList<Clause>();
        for (Clause clause : clauses = Parser.parseHeader((String)ManifestUtils.getHeader("Export-Package", manifest))) {
            result.add(clause);
        }
        return result;
    }

    public static boolean isOptional(Clause clause) {
        return "optional".equals(clause.getDirective("resolution"));
    }

    public static boolean isBundle(Manifest manifest) {
        return ManifestUtils.getBsn(manifest) != null;
    }

    public static boolean matches(Clause requirement, Clause export) {
        if (requirement.getName().equals(export.getName())) {
            VersionRange exportVersionRange;
            VersionRange importVersionRange = ManifestUtils.getVersionRange(requirement);
            VersionRange intersection = importVersionRange.intersect(exportVersionRange = ManifestUtils.getVersionRange(export));
            return intersection != null;
        }
        return false;
    }

    public static String getHeader(String name, Manifest manifest) {
        String value = manifest.getMainAttributes().getValue(name);
        return value;
    }

    public static String getBsn(Manifest manifest) {
        String bsn = ManifestUtils.getHeader("Bundle-SymbolicName", manifest);
        return bsn;
    }

    public static VersionRange getVersionRange(Clause clause) {
        String v = clause.getAttribute("version");
        if (v == null) {
            v = clause.getAttribute("specification-version");
        }
        if (v == null) {
            v = clause.getAttribute("bundle-version");
        }
        return VersionRange.parseVersionRange((String)v);
    }
}

