/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.tooling.commands.AbstractCommandHelpPrinter;
import org.apache.karaf.tooling.commands.AsciiDoctorCommandHelpPrinter;
import org.apache.karaf.tooling.commands.DocBookCommandHelpPrinter;
import org.apache.karaf.tooling.commands.UserConfCommandHelpPrinter;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.xbean.finder.ClassFinder;

@Mojo(name="commands-generate-help", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME, inheritByDefault=false)
public class GenerateHelpMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/docbkx/sources")
    protected File targetFolder;
    @Parameter(defaultValue="docbx")
    protected String format;
    @Parameter(defaultValue="project")
    protected String classLoader;
    @Parameter(defaultValue="true")
    protected boolean includeHelpOption;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    private static final String FORMAT_CONF = "conf";
    private static final String FORMAT_DOCBX = "docbx";
    private static final String FORMAT_ASCIIDOC = "asciidoc";

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            ClassFinder finder;
            List classes;
            if (!(FORMAT_DOCBX.equals(this.format) || FORMAT_CONF.equals(this.format) || FORMAT_ASCIIDOC.equals(this.format))) {
                throw new MojoFailureException("Unsupported format: " + this.format + ". Supported formats are: asciidoc, docbx, or conf.");
            }
            if (!this.targetFolder.exists()) {
                this.targetFolder.mkdirs();
            }
            if ((classes = (finder = this.createFinder(this.classLoader)).findAnnotatedClasses(Command.class)).isEmpty()) {
                throw new MojoFailureException("No command found");
            }
            AbstractCommandHelpPrinter helpPrinter = null;
            if (FORMAT_ASCIIDOC.equals(this.format)) {
                helpPrinter = new AsciiDoctorCommandHelpPrinter();
            }
            if (FORMAT_CONF.equals(this.format)) {
                helpPrinter = new UserConfCommandHelpPrinter();
            }
            if (FORMAT_DOCBX.equals(this.format)) {
                helpPrinter = new DocBookCommandHelpPrinter();
            }
            TreeMap<String, Set<String>> commands = new TreeMap<String, Set<String>>();
            String commandSuffix = null;
            if (FORMAT_ASCIIDOC.equals(this.format)) {
                commandSuffix = "adoc";
            }
            if (FORMAT_CONF.equals(this.format)) {
                commandSuffix = FORMAT_CONF;
            }
            if (FORMAT_DOCBX.equals(this.format)) {
                commandSuffix = "xml";
            }
            for (Class clazz : classes) {
                try {
                    Action action = (Action)clazz.newInstance();
                    Command cmd = clazz.getAnnotation(Command.class);
                    if (cmd.scope().equals("*")) continue;
                    File output = new File(this.targetFolder, cmd.scope() + "-" + cmd.name() + "." + commandSuffix);
                    FileOutputStream outStream = new FileOutputStream(output);
                    PrintStream out = new PrintStream(outStream);
                    helpPrinter.printHelp(action, out, this.includeHelpOption);
                    out.close();
                    outStream.close();
                    TreeSet<String> cmds = (TreeSet<String>)commands.get(cmd.scope());
                    if (cmds == null) {
                        cmds = new TreeSet<String>();
                        commands.put(cmd.scope(), cmds);
                    }
                    cmds.add(cmd.name());
                    this.getLog().info((CharSequence)("Found command: " + cmd.scope() + ":" + cmd.name()));
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Unable to write help for " + clazz.getName()), (Throwable)e);
                }
            }
            String overViewSuffix = null;
            if (FORMAT_ASCIIDOC.equals(this.format)) {
                overViewSuffix = "adoc";
            }
            if (FORMAT_CONF.equals(this.format)) {
                overViewSuffix = FORMAT_CONF;
            }
            if (FORMAT_DOCBX.equals(this.format)) {
                overViewSuffix = "xml";
            }
            PrintStream writer = new PrintStream(new FileOutputStream(new File(this.targetFolder, "commands." + overViewSuffix)));
            helpPrinter.printOverview(commands, writer);
            writer.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error building commands help", e);
        }
    }

    private ClassFinder createFinder(String classloaderType) throws DependencyResolutionRequiredException, MalformedURLException, Exception, MojoFailureException {
        ClassFinder finder;
        if ("project".equals(classloaderType)) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Object object : this.project.getCompileClasspathElements()) {
                String path = (String)object;
                urls.add(new File(path).toURI().toURL());
            }
            URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            finder = new ClassFinder((ClassLoader)loader, urls);
        } else if ("plugin".equals(this.classLoader)) {
            finder = new ClassFinder(((Object)((Object)this)).getClass().getClassLoader());
        } else {
            throw new MojoFailureException("classLoader attribute must be 'project' or 'plugin'");
        }
        return finder;
    }
}

